/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.world.RecruitsClaim;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MessageToClientUpdateClaims
implements Message<MessageToClientUpdateClaims> {
    private CompoundTag claimsListNBT;
    private int claimCost;
    private int chunkCost;
    private boolean cascadeOfCost;
    private ItemStack currencyItemStack;

    public MessageToClientUpdateClaims() {
    }

    public MessageToClientUpdateClaims(List<RecruitsClaim> list, int claimCost, int chunkCost, boolean cascadeOfCost, ItemStack currencyItemStack) {
        this.claimsListNBT = RecruitsClaim.toNBT(list);
        this.claimCost = claimCost;
        this.chunkCost = chunkCost;
        this.cascadeOfCost = cascadeOfCost;
        this.currencyItemStack = currencyItemStack;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClientSide(NetworkEvent.Context context) {
        ClientManager.recruitsClaims = RecruitsClaim.getListFromNBT(this.claimsListNBT);
        ClientManager.configValueClaimCost = this.claimCost;
        ClientManager.configValueChunkCost = this.chunkCost;
        ClientManager.configValueCascadeClaimCost = this.cascadeOfCost;
        ClientManager.currencyItemStack = this.currencyItemStack;
    }

    @Override
    public MessageToClientUpdateClaims fromBytes(FriendlyByteBuf buf) {
        this.claimsListNBT = buf.m_130260_();
        this.claimCost = buf.readInt();
        this.chunkCost = buf.readInt();
        this.cascadeOfCost = buf.readBoolean();
        this.currencyItemStack = buf.m_130267_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.claimsListNBT);
        buf.writeInt(this.claimCost);
        buf.writeInt(this.chunkCost);
        buf.writeBoolean(this.cascadeOfCost);
        buf.writeItemStack(this.currencyItemStack, false);
    }
}

