/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.world.RecruitsClaim;
import de.maxhenkel.recruits.corelib.net.Message;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MessageToClientUpdateClaim
implements Message<MessageToClientUpdateClaim> {
    private CompoundTag claimNBT;

    public MessageToClientUpdateClaim() {
    }

    public MessageToClientUpdateClaim(RecruitsClaim claim) {
        this.claimNBT = claim.toNBT();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClientSide(NetworkEvent.Context context) {
        this.updateOrAddClaimFromNBT(this.claimNBT);
    }

    public void updateOrAddClaimFromNBT(CompoundTag claimNBT) {
        RecruitsClaim newClaim = RecruitsClaim.fromNBT(claimNBT);
        for (int i = 0; i < ClientManager.recruitsClaims.size(); ++i) {
            RecruitsClaim existing = ClientManager.recruitsClaims.get(i);
            if (!existing.getUUID().equals(newClaim.getUUID())) continue;
            ClientManager.recruitsClaims.set(i, newClaim);
            return;
        }
        ClientManager.recruitsClaims.add(newClaim);
    }

    @Override
    public MessageToClientUpdateClaim fromBytes(FriendlyByteBuf buf) {
        this.claimNBT = buf.m_130260_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.claimNBT);
    }
}

