/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageStrategicFire
implements Message<MessageStrategicFire> {
    private UUID player;
    private UUID group;
    private boolean should;

    public MessageStrategicFire() {
    }

    public MessageStrategicFire(UUID player, UUID group, boolean should) {
        this.player = player;
        this.group = group;
        this.should = should;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = Objects.requireNonNull(context.getSender());
        serverPlayer.m_20193_().m_45976_(AbstractRecruitEntity.class, serverPlayer.m_20191_().m_82400_(100.0)).forEach(recruit -> CommandEvents.onStrategicFireCommand((Player)serverPlayer, this.player, recruit, this.group, this.should));
    }

    @Override
    public MessageStrategicFire fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.group = buf.m_130259_();
        this.should = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130077_(this.group);
        buf.writeBoolean(this.should);
    }
}

