/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMergeGroup
implements Message<MessageMergeGroup> {
    private UUID groupUUID;
    private UUID mergeUUID;

    public MessageMergeGroup() {
    }

    public MessageMergeGroup(UUID mergeUUID, UUID groupUUID) {
        this.mergeUUID = mergeUUID;
        this.groupUUID = groupUUID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        RecruitsGroup groupToMerge = RecruitEvents.recruitsGroupsManager.getGroup(this.mergeUUID);
        RecruitsGroup baseGroup = RecruitEvents.recruitsGroupsManager.getGroup(this.groupUUID);
        if (groupToMerge == null || baseGroup == null) {
            return;
        }
        RecruitEvents.recruitsGroupsManager.mergeGroups(groupToMerge, baseGroup, player.m_284548_());
    }

    @Override
    public MessageMergeGroup fromBytes(FriendlyByteBuf buf) {
        this.groupUUID = buf.m_130259_();
        this.mergeUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.groupUUID);
        buf.m_130077_(this.mergeUUID);
    }
}

