/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.VillagerEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsHireTrade;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageHireFromNobleVillager
implements Message<MessageHireFromNobleVillager> {
    private UUID nobleUUID;
    private UUID villagerUUID;
    private int cost;
    private boolean needsVillager;
    private boolean closing;
    private ResourceLocation resource;
    private UUID groupUUID;

    public MessageHireFromNobleVillager() {
    }

    public MessageHireFromNobleVillager(UUID nobleUUID, UUID villagerUUID, RecruitsHireTrade trade, RecruitsGroup group, boolean needsVillager, boolean closing) {
        this.nobleUUID = nobleUUID;
        this.villagerUUID = villagerUUID;
        this.groupUUID = group.getUUID();
        if (trade != null) {
            this.cost = trade.cost;
            this.resource = trade.resourceLocation;
        } else {
            this.cost = 0;
            this.resource = new ResourceLocation("", "");
        }
        this.needsVillager = needsVillager;
        this.closing = closing;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        ServerLevel serverLevel = player.m_284548_();
        VillagerNobleEntity villagerNoble = (VillagerNobleEntity)((Object)player.m_20193_().m_6443_(VillagerNobleEntity.class, player.m_20191_().m_82400_(32.0), noble -> noble.m_20148_().equals(this.nobleUUID) && noble.m_6084_()).stream().findAny().get());
        if (this.closing) {
            villagerNoble.isTrading(false);
            return;
        }
        RecruitsGroup group = RecruitEvents.recruitsGroupsManager.getGroup(this.groupUUID);
        if (this.needsVillager) {
            player.m_20193_().m_6443_(Villager.class, player.m_20191_().m_82400_(32.0), villager -> villager.m_20148_().equals(this.villagerUUID) && villager.m_6084_()).forEach(villager -> this.createRecruit(serverLevel, (Villager)villager, villagerNoble, (Player)player, group));
        } else {
            String string = this.resource.toString();
            Optional optionalType = EntityType.m_20632_((String)string);
            optionalType.ifPresent(type -> VillagerEvents.spawnHiredRecruit(serverLevel, (EntityType<? extends AbstractRecruitEntity>)type, (Player)player, group));
            villagerNoble.doTrade(this.resource);
        }
    }

    public void createRecruit(ServerLevel serverLevel, Villager villager, VillagerNobleEntity villagerNoble, Player player, RecruitsGroup group) {
        String string = this.resource.toString();
        Optional optionalType = EntityType.m_20632_((String)string);
        optionalType.ifPresent(type -> VillagerEvents.createHiredRecruitFromVillager(serverLevel, villager, (EntityType<? extends AbstractRecruitEntity>)type, player, group));
        villagerNoble.doTrade(this.resource);
    }

    @Override
    public MessageHireFromNobleVillager fromBytes(FriendlyByteBuf buf) {
        this.nobleUUID = buf.m_130259_();
        this.villagerUUID = buf.m_130259_();
        this.cost = buf.readInt();
        this.resource = buf.m_130281_();
        this.needsVillager = buf.readBoolean();
        this.closing = buf.readBoolean();
        this.groupUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.nobleUUID);
        buf.m_130077_(this.villagerUUID);
        buf.writeInt(this.cost);
        buf.m_130085_(this.resource);
        buf.writeBoolean(this.needsVillager);
        buf.writeBoolean(this.closing);
        buf.m_130077_(this.groupUUID);
    }
}

