/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageGroup
implements Message<MessageGroup> {
    private UUID groupUUID;
    private UUID recruitUUID;

    public MessageGroup() {
    }

    public MessageGroup(UUID groupUUID, UUID recruitUUID) {
        this.groupUUID = groupUUID;
        this.recruitUUID = recruitUUID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0), recruit -> recruit.m_20148_().equals(this.recruitUUID)).forEach(recruit -> this.setGroup((AbstractRecruitEntity)((Object)recruit), player, this.groupUUID));
    }

    public void setGroup(AbstractRecruitEntity recruit, ServerPlayer player, UUID groupUUID) {
        RecruitsGroup oldGroup = RecruitEvents.recruitsGroupsManager.getGroup(recruit.getGroup());
        RecruitsGroup newGroup = RecruitEvents.recruitsGroupsManager.getGroup(groupUUID);
        if (oldGroup != null && newGroup != null && oldGroup.getUUID().equals(newGroup.getUUID())) {
            return;
        }
        if (oldGroup != null) {
            RecruitEvents.recruitsGroupsManager.removeMember(oldGroup.getUUID(), recruit.m_20148_(), player.m_284548_());
        }
        if (newGroup != null) {
            RecruitEvents.recruitsGroupsManager.addMember(newGroup.getUUID(), recruit.m_20148_(), player.m_284548_());
        }
        recruit.setGroupUUID(newGroup.getUUID());
    }

    @Override
    public MessageGroup fromBytes(FriendlyByteBuf buf) {
        this.groupUUID = buf.m_130259_();
        this.recruitUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.groupUUID);
        buf.m_130077_(this.recruitUUID);
    }
}

