/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.util.NPCArmy;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAssignGroupToCompanion
implements Message<MessageAssignGroupToCompanion> {
    private UUID ownerUUID;
    private UUID companionUUID;

    public MessageAssignGroupToCompanion() {
    }

    public MessageAssignGroupToCompanion(UUID owner, UUID companionUUID) {
        this.ownerUUID = owner;
        this.companionUUID = companionUUID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        ServerLevel serverLevel = serverPlayer.m_284548_();
        AbstractRecruitEntity companionEntity = null;
        List list = serverLevel.m_45976_(LivingEntity.class, serverPlayer.m_20191_().m_82400_(100.0));
        for (LivingEntity companion : list) {
            if (!companion.m_20148_().equals(this.companionUUID)) continue;
            companionEntity = (AbstractLeaderEntity)companion;
            break;
        }
        if (companionEntity == null) {
            return;
        }
        RecruitsGroup group = RecruitEvents.recruitsGroupsManager.getGroup(companionEntity.getGroup());
        if (group == null) {
            return;
        }
        list.removeIf(living -> {
            AbstractRecruitEntity recruit;
            return !(living instanceof AbstractRecruitEntity) || (recruit = (AbstractRecruitEntity)((Object)living)).getGroup() == null || !recruit.getGroup().equals(group.getUUID()) || recruit.m_20148_().equals(this.companionUUID);
        });
        for (LivingEntity living2 : list) {
            if (!(living2 instanceof AbstractRecruitEntity)) continue;
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)living2;
            ICompanion.assignToLeaderCompanion((AbstractLeaderEntity)companionEntity, recruit);
        }
        ((AbstractLeaderEntity)companionEntity).army = new NPCArmy(serverLevel, list, null);
        group.leaderUUID = this.companionUUID;
        companionEntity.setGroupUUID(group.getUUID());
        RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer((Player)serverPlayer);
    }

    @Override
    public MessageAssignGroupToCompanion fromBytes(FriendlyByteBuf buf) {
        this.ownerUUID = buf.m_130259_();
        this.companionUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.ownerUUID);
        buf.m_130077_(this.companionUUID);
    }
}

