/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageApplyNoGroup
implements Message<MessageApplyNoGroup> {
    private UUID owner;
    private UUID groupID;

    public MessageApplyNoGroup() {
    }

    public MessageApplyNoGroup(UUID owner, UUID groupID) {
        this.owner = owner;
        this.groupID = groupID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        ArrayList<AbstractRecruitEntity> recruitList = new ArrayList<AbstractRecruitEntity>();
        ServerLevel serverLevel = (ServerLevel)player.m_20193_();
        for (Entity entity : serverLevel.m_142646_().m_142273_()) {
            AbstractRecruitEntity recruit;
            if (!(entity instanceof AbstractRecruitEntity) || (recruit = (AbstractRecruitEntity)entity).getGroup() == null || !recruit.getGroup().equals(this.groupID)) continue;
            recruitList.add(recruit);
        }
        for (AbstractRecruitEntity recruit : recruitList) {
            recruit.setGroupUUID(null);
        }
    }

    @Override
    public MessageApplyNoGroup fromBytes(FriendlyByteBuf buf) {
        this.owner = buf.m_130259_();
        this.groupID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.owner);
        buf.m_130077_(this.groupID);
    }
}

