/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAggro
implements Message<MessageAggro> {
    private UUID player;
    private UUID recruit;
    private int state;
    private UUID group;
    private boolean fromGui;

    public MessageAggro() {
    }

    public MessageAggro(UUID player, int state, UUID group) {
        this.player = player;
        this.state = state;
        this.group = group;
        this.fromGui = false;
        this.recruit = null;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        double boundBoxInflateModifier = 16.0;
        if (!this.fromGui) {
            boundBoxInflateModifier = 100.0;
        }
        player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(boundBoxInflateModifier)).forEach(recruit -> {
            if (this.fromGui && !recruit.m_20148_().equals(this.recruit)) {
                return;
            }
            CommandEvents.onAggroCommand(this.player, recruit, this.state, this.group, this.fromGui);
        });
    }

    @Override
    public MessageAggro fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.state = buf.readInt();
        this.group = buf.m_130259_();
        if (this.recruit != null) {
            this.recruit = buf.m_130259_();
        }
        this.fromGui = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.writeInt(this.state);
        buf.m_130077_(this.group);
        buf.writeBoolean(this.fromGui);
        if (this.recruit != null) {
            buf.m_130077_(this.recruit);
        }
    }
}

