/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.items;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class RecruitsSpawnEgg
extends ForgeSpawnEggItem {
    private final Supplier<? extends EntityType<? extends AbstractRecruitEntity>> entityType;

    public RecruitsSpawnEgg(Supplier<? extends EntityType<? extends AbstractRecruitEntity>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
        this.entityType = entityType;
    }

    @NotNull
    public EntityType<?> m_43228_(CompoundTag compound) {
        CompoundTag entityTag;
        if (compound != null && compound.m_128425_("EntityTag", 10) && (entityTag = compound.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)entityTag.m_128461_("id")).orElse(this.entityType.get());
        }
        return this.entityType.get();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        EntityType<?> entitytype = this.m_43228_(stack.m_41783_());
        Entity entity = entitytype.m_20615_(world);
        CompoundTag entityTag = stack.m_41783_();
        if (entity instanceof AbstractRecruitEntity) {
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)entity;
            if (entityTag != null) {
                RecruitsSpawnEgg.fillRecruit(recruit, entityTag, pos);
                world.m_7967_((Entity)recruit);
                if (!context.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public static void fillRecruit(AbstractRecruitEntity recruit, CompoundTag entityTag, BlockPos pos) {
        Optional<UUID> uuid;
        if (recruit.m_20193_().m_5776_()) {
            return;
        }
        CompoundTag nbt = entityTag.m_128469_("EntityTag");
        if (nbt.m_128441_("Team")) {
            boolean flag;
            String s = nbt.m_128461_("Team");
            PlayerTeam playerteam = recruit.m_20193_().m_6188_().m_83489_(s);
            boolean bl = flag = playerteam != null && recruit.m_20193_().m_6188_().m_6546_(recruit.m_20149_(), playerteam);
            if (!flag) {
                Main.LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s);
            }
        }
        String name = nbt.m_128461_("Name");
        recruit.m_6593_((Component)Component.m_237113_((String)name));
        recruit.setXpLevel(nbt.m_128451_("Level"));
        recruit.setAggroState(nbt.m_128451_("AggroState"));
        recruit.setFollowState(nbt.m_128451_("FollowState"));
        recruit.setShouldFollow(nbt.m_128471_("ShouldFollow"));
        recruit.setShouldMount(nbt.m_128471_("ShouldMount"));
        recruit.setShouldBlock(nbt.m_128471_("ShouldBlock"));
        recruit.setShouldProtect(nbt.m_128471_("ShouldProtect"));
        recruit.setFleeing(nbt.m_128471_("Fleeing"));
        if (nbt.m_128441_("Group")) {
            recruit.setGroupUUID(nbt.m_128342_("Group"));
        }
        recruit.setListen(nbt.m_128471_("Listen"));
        recruit.setIsFollowing(nbt.m_128471_("isFollowing"));
        recruit.setXp(nbt.m_128451_("Xp"));
        recruit.setKills(nbt.m_128451_("Kills"));
        recruit.setVariant(nbt.m_128451_("Variant"));
        recruit.setHunger(nbt.m_128457_("Hunger"));
        recruit.setMoral(nbt.m_128457_("Moral"));
        recruit.setIsOwned(nbt.m_128471_("isOwned"));
        recruit.setCost(nbt.m_128451_("Cost"));
        recruit.setMountTimer(nbt.m_128451_("mountTimer"));
        recruit.setUpkeepTimer(nbt.m_128451_("UpkeepTimer"));
        recruit.setColor(nbt.m_128445_("Color"));
        recruit.setBiome(nbt.m_128445_("Biome"));
        recruit.setHoldPos(Vec3.m_82512_((Vec3i)pos));
        if (nbt.m_128441_("MovePosX") && nbt.m_128441_("MovePosY") && nbt.m_128441_("MovePosZ")) {
            recruit.setShouldMovePos(nbt.m_128471_("ShouldMovePos"));
            recruit.setMovePos(new BlockPos(nbt.m_128451_("MovePosX"), nbt.m_128451_("MovePosY"), nbt.m_128451_("MovePosZ")));
        }
        if (nbt.m_128441_("OwnerUUID")) {
            uuid = Optional.of(nbt.m_128342_("OwnerUUID"));
            recruit.setOwnerUUID(uuid);
        }
        if (nbt.m_128441_("ProtectUUID")) {
            uuid = Optional.of(nbt.m_128342_("ProtectUUID"));
            recruit.setProtectUUID(uuid);
        }
        if (nbt.m_128441_("MountUUID")) {
            uuid = Optional.of(nbt.m_128342_("MountUUID"));
            recruit.setMountUUID(uuid);
        }
        if (nbt.m_128441_("UpkeepUUID")) {
            uuid = Optional.of(nbt.m_128342_("UpkeepUUID"));
            recruit.setUpkeepUUID(uuid);
        }
        if (nbt.m_128441_("UpkeepPosX") && nbt.m_128441_("UpkeepPosY") && nbt.m_128441_("UpkeepPosZ")) {
            recruit.setUpkeepPos(new BlockPos(nbt.m_128451_("UpkeepPosX"), nbt.m_128451_("UpkeepPosY"), nbt.m_128451_("UpkeepPosZ")));
        }
        ListTag listnbt = nbt.m_128437_("Items", 10);
        recruit.createInventory();
        recruit.m_21530_();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j >= recruit.inventory.m_6643_()) continue;
            recruit.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        ListTag armorItems = nbt.m_128437_("ArmorItems", 10);
        for (int i = 0; i < recruit.f_21351_.size(); ++i) {
            int index = recruit.getInventorySlotIndex(Mob.m_147233_((ItemStack)ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i))));
            recruit.m_8061_(recruit.getEquipmentSlotIndex(index), ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i)));
        }
        ListTag handItems = nbt.m_128437_("HandItems", 10);
        for (int i = 0; i < recruit.f_21350_.size(); ++i) {
            int index = i == 0 ? 5 : 4;
            recruit.m_8061_(recruit.getEquipmentSlotIndex(index), ItemStack.m_41712_((CompoundTag)handItems.m_128728_(i)));
        }
        recruit.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        if (recruit.getGroup() != null) {
            RecruitEvents.recruitsGroupsManager.addMember(recruit.getGroup(), recruit.m_20148_(), (ServerLevel)recruit.m_20193_());
        }
    }
}

