/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.inventory;

import com.mojang.datafixers.util.Pair;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.init.ModScreens;
import de.maxhenkel.recruits.corelib.inventory.ContainerBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecruitInventoryMenu
extends ContainerBase {
    private final Container recruitInventory;
    private final AbstractRecruitEntity recruit;
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    public static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND};

    public RecruitInventoryMenu(int id, AbstractRecruitEntity recruit, Inventory playerInventory) {
        super((MenuType)ModScreens.RECRUIT_CONTAINER_TYPE.get(), id, (Container)playerInventory, (Container)recruit.getInventory());
        this.recruit = recruit;
        this.recruitInventory = recruit.getInventory();
        this.addPlayerInventorySlots();
        this.addRecruitHandSlots();
        this.addRecruitEquipmentSlots();
        this.addRecruitInventorySlots();
    }

    public AbstractRecruitEntity getRecruit() {
        return this.recruit;
    }

    @Override
    public int getInvOffset() {
        return 56;
    }

    public void addRecruitHandSlots() {
        this.m_38897_(new Slot((Container)this.recruit.inventory, 4, 44, 90){

            public boolean m_5857_(ItemStack stack) {
                return !RecruitInventoryMenu.this.recruit.m_6117_() && stack.m_41720_() instanceof ShieldItem;
            }

            public boolean m_8010_(Player player) {
                return !RecruitInventoryMenu.this.recruit.m_6117_();
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                RecruitInventoryMenu.this.recruit.m_8061_(EquipmentSlot.OFFHAND, stack);
                RecruitInventoryMenu.this.recruit.onItemStackAdded(stack);
            }

            public void m_6654_() {
                super.m_6654_();
                RecruitInventoryMenu.this.recruit.onInventoryChanged();
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.m_38897_(new Slot((Container)this.recruit.inventory, 5, 26, 90){

            public boolean m_5857_(ItemStack itemStack) {
                return RecruitInventoryMenu.this.recruit.m_7252_(itemStack);
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                RecruitInventoryMenu.this.recruit.m_8061_(EquipmentSlot.MAINHAND, stack);
                RecruitInventoryMenu.this.recruit.onItemStackAdded(stack);
            }

            public void m_6654_() {
                super.m_6654_();
                RecruitInventoryMenu.this.recruit.onInventoryChanged();
            }
        });
    }

    public void addRecruitEquipmentSlots() {
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            final EquipmentSlot equipmentslottype = SLOT_IDS[slotIndex];
            this.m_38897_(new Slot((Container)this.recruit.inventory, slotIndex, 8, 18 + slotIndex * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack itemStack) {
                    return itemStack.canEquip(equipmentslottype, (Entity)RecruitInventoryMenu.this.recruit) || itemStack.m_41720_() instanceof BannerItem && equipmentslottype.equals((Object)EquipmentSlot.HEAD);
                }

                public void m_5852_(ItemStack stack) {
                    super.m_5852_(stack);
                    RecruitInventoryMenu.this.recruit.m_8061_(equipmentslottype, stack);
                    RecruitInventoryMenu.this.recruit.onItemStackAdded(stack);
                }

                public void m_6654_() {
                    super.m_6654_();
                    RecruitInventoryMenu.this.recruit.onInventoryChanged();
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslottype.m_20749_()]);
                }
            });
        }
    }

    public void addRecruitInventorySlots() {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                this.m_38897_(new Slot(this.recruitInventory, 6 + l + k * this.recruit.getInventoryColumns(), 118 + l * 18, 18 + k * 18){

                    public void m_5852_(ItemStack stack) {
                        super.m_5852_(stack);
                        RecruitInventoryMenu.this.recruit.onItemStackAdded(stack);
                    }

                    public void m_6654_() {
                        super.m_6654_();
                        RecruitInventoryMenu.this.recruit.onInventoryChanged();
                    }
                });
            }
        }
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index <= 35 ? (this.m_38853_(38).m_5857_(stack) && !this.m_38853_(38).m_6657_() ? !this.m_38903_(stack, 38, this.f_38839_.size(), false) : (this.m_38853_(39).m_5857_(stack) && !this.m_38853_(39).m_6657_() ? !this.m_38903_(stack, 39, this.f_38839_.size(), false) : (this.m_38853_(40).m_5857_(stack) && !this.m_38853_(40).m_6657_() ? !this.m_38903_(stack, 40, this.f_38839_.size(), false) : (this.m_38853_(41).m_5857_(stack) && !this.m_38853_(41).m_6657_() ? !this.m_38903_(stack, 41, this.f_38839_.size(), false) : (this.m_38853_(36).m_5857_(stack) && !this.m_38853_(36).m_6657_() ? !this.m_38903_(stack, 36, this.f_38839_.size(), false) : (this.m_38853_(37).m_5857_(stack) && !this.m_38853_(37).m_6657_() ? !this.m_38903_(stack, 37, this.f_38839_.size(), false) : !this.m_38903_(stack, 42, this.f_38839_.size(), false))))))) : !this.m_38903_(stack, 0, 35, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

