/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.ai.RecruitRangedBowAttackGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;

public class RecruitStrategicFire
extends Goal {
    private final Boolean consumeArrows;
    private BlockPos pos;
    private BowmanEntity bowman;
    private int attackIntervalMin;
    private int attackTime = -1;
    private final int attackIntervalMax;

    public RecruitStrategicFire(BowmanEntity bowman, int attackIntervalMin, int attackIntervalMax) {
        this.bowman = bowman;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.consumeArrows = (Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get();
    }

    public boolean m_8036_() {
        if (this.bowman.m_5448_() == null && this.hasArrows() && this.bowman.getShouldStrategicFire() && RecruitRangedBowAttackGoal.isHoldingBow((LivingEntity)this.bowman) && this.bowman.getFollowState() != 5 && !this.bowman.needsToGetFood() && !this.bowman.getShouldMount()) {
            return true;
        }
        this.pos = null;
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.attackTime = -1;
        this.bowman.m_5810_();
        this.bowman.clearArrowsPos();
    }

    public void m_8037_() {
        this.pos = this.bowman.StrategicFirePos();
        if (this.pos != null) {
            double d0 = this.bowman.m_20275_(this.pos.m_123341_(), this.bowman.m_20186_(), this.pos.m_123343_());
            this.bowman.m_21563_().m_24950_((double)this.pos.m_123341_(), (double)(this.pos.m_123342_() + 16), (double)this.pos.m_123343_(), 30.0f, 30.0f);
            if (this.bowman.m_6117_()) {
                int i = this.bowman.m_21252_();
                if (i >= 20) {
                    float angle = 0.0f;
                    float force = 0.0f;
                    if (0.0 < d0 && d0 < 500.0) {
                        angle = -7.0f;
                        force = -0.75f;
                    } else if (500.0 < d0 && d0 < 1000.0) {
                        angle = -5.0f;
                        force = -0.65f;
                    } else if (1000.0 < d0 && d0 < 2000.0) {
                        angle = -2.5f;
                        force = -0.35f;
                    } else if (2000.0 < d0 && d0 < 3000.0) {
                        angle = -2.5f;
                        force = -0.1f;
                    } else if (3000.0 < d0 && d0 < 4000.0) {
                        angle = -2.5f;
                        force = 0.0f;
                    } else if (4000.0 < d0 && d0 < 5000.0) {
                        angle = -2.5f;
                        force = 0.4f;
                    } else if (5000.0 < d0 && d0 < 6000.0) {
                        angle = 0.0f;
                        force = 0.4f;
                    } else if (6000.0 < d0 && d0 < 7000.0) {
                        angle = 0.1f;
                        force = 0.5f;
                    } else if (7000.0 < d0 && d0 < 8000.0) {
                        angle = 0.2f;
                        force = 0.6f;
                    } else if (8000.0 < d0 && d0 < 9000.0) {
                        angle = 0.3f;
                        force = 0.7f;
                    } else if (9000.0 < d0) {
                        angle = 0.4f;
                        force = 0.8f;
                    }
                    this.bowman.performRangedAttackXYZ(this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), BowItem.m_40661_((int)i), angle, force);
                    float f = Mth.m_14116_((float)((float)d0)) / 44.0f;
                    this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
                    this.bowman.m_5810_();
                }
            } else if (--this.attackTime <= 0) {
                this.bowman.m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.bowman, predicateBow -> this.isBow(predicateBow.m_7968_())));
            }
        }
    }

    public boolean isBow(ItemStack itemStack) {
        String name = this.bowman.m_21205_().m_41778_();
        return itemStack.m_150930_(Items.f_42411_) || itemStack.m_41720_() instanceof BowItem || itemStack.m_41720_() instanceof ProjectileWeaponItem || name.contains("bow");
    }

    private boolean hasArrows() {
        return this.consumeArrows == false || this.bowman.getInventory().m_216874_(item -> item.m_204117_(ItemTags.f_13161_));
    }
}

