/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecruitRangedBowAttackGoal<T extends BowmanEntity>
extends Goal {
    private final T recruit;
    private final double speedModifier;
    private final int attackIntervalMin;
    private LivingEntity target;
    private int attackTime = -1;
    private int seeTime;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final double stopRange;
    private boolean consumeArrows;

    public RecruitRangedBowAttackGoal(T mob, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, double stopRange) {
        this.recruit = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.stopRange = stopRange;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.consumeArrows = (Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get();
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.recruit.m_5448_();
        if (livingentity != null && livingentity.m_6084_() && RecruitRangedBowAttackGoal.isHoldingBow(this.recruit)) {
            this.target = livingentity;
            float distance = this.target.m_20270_(this.recruit);
            boolean canTackMovePos = this.canAttackMovePos();
            boolean shouldRanged = ((AbstractRecruitEntity)((Object)this.recruit)).getShouldRanged();
            boolean canAttack = ((AbstractRecruitEntity)((Object)this.recruit)).m_6779_(this.target);
            boolean notPassive = ((AbstractRecruitEntity)((Object)this.recruit)).getState() != 3;
            boolean notNeedsToGetFood = !((AbstractRecruitEntity)((Object)this.recruit)).needsToGetFood();
            boolean canSee = this.recruit.m_21574_().m_148306_((Entity)this.target);
            if (!canSee) {
                ((AbstractRecruitEntity)((Object)this.recruit)).m_6710_(null);
                return false;
            }
            return (double)distance >= this.stopRange && canTackMovePos && notNeedsToGetFood && canAttack && notPassive && shouldRanged;
        }
        return false;
    }

    public static boolean isHoldingBow(LivingEntity mob) {
        String name = mob.m_21205_().m_41778_();
        if (mob.m_21093_(bow -> bow.m_150930_(Items.f_42411_))) {
            return true;
        }
        if (mob.m_21093_(bow -> bow.m_41720_() instanceof BowItem)) {
            return true;
        }
        if (mob.m_21093_(bow -> bow.m_41720_() instanceof ProjectileWeaponItem)) {
            return true;
        }
        return name.contains("bow");
    }

    private boolean hasArrows() {
        return !this.consumeArrows || ((AbstractInventoryEntity)((Object)this.recruit)).getInventory().m_216874_(item -> item.m_204117_(ItemTags.f_13161_));
    }

    public boolean m_8045_() {
        return this.m_8036_() && RecruitRangedBowAttackGoal.isHoldingBow(this.recruit);
    }

    public void m_8056_() {
        super.m_8056_();
        this.recruit.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.recruit.m_21561_(false);
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.recruit.m_5810_();
    }

    public void m_8037_() {
        if (this.target != null && this.target.m_6084_()) {
            double distance = this.target.m_20280_(this.recruit);
            boolean isClose = distance <= 150.0;
            boolean isFar = distance >= 3500.0;
            boolean isTooFar = distance >= 4500.0;
            boolean inRange = !isFar;
            boolean canSee = this.recruit.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (isTooFar) {
                ((AbstractRecruitEntity)((Object)this.recruit)).m_6710_(null);
                this.m_8041_();
                return;
            }
            if (((AbstractRecruitEntity)((Object)this.recruit)).getShouldFollow() && ((AbstractRecruitEntity)((Object)this.recruit)).getOwner() != null) {
                this.handleFollow((LivingEntity)((AbstractRecruitEntity)((Object)this.recruit)).getOwner(), inRange, isFar, isClose);
            } else if (((AbstractRecruitEntity)((Object)this.recruit)).getShouldHoldPos() && ((AbstractRecruitEntity)((Object)this.recruit)).getHoldPos() != null) {
                this.handleHoldPos(((AbstractRecruitEntity)((Object)this.recruit)).getHoldPos(), inRange, isFar, isClose);
            } else {
                this.handleWander(inRange, isFar, isClose);
            }
            this.recruit.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (this.recruit.m_6117_()) {
                int i;
                if (!canSee && this.seeTime < -60) {
                    this.recruit.m_5810_();
                } else if (canSee && (i = this.recruit.m_21252_()) >= 20) {
                    this.recruit.m_5810_();
                    ((BowmanEntity)this.recruit).m_6504_(this.target, BowItem.m_40661_((int)i));
                    float f = Mth.m_14116_((float)((float)distance)) / this.attackRadius;
                    this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60 && this.hasArrows()) {
                this.recruit.m_6672_(InteractionHand.MAIN_HAND);
            }
        }
    }

    private boolean canAttackMovePos() {
        LivingEntity target = this.recruit.m_5448_();
        BlockPos pos = ((AbstractRecruitEntity)((Object)this.recruit)).getMovePos();
        if (target != null && pos != null && ((AbstractRecruitEntity)((Object)this.recruit)).getShouldMovePos()) {
            boolean posIsFar;
            boolean targetIsFar = target.m_20280_(this.recruit) >= 320.0;
            boolean posIsClose = pos.m_123331_((Vec3i)this.recruit.m_20097_()) <= 150.0;
            boolean bl = posIsFar = pos.m_123331_((Vec3i)this.recruit.m_20097_()) > 150.0;
            if (posIsFar) {
                return false;
            }
            if (posIsClose && targetIsFar) {
                return false;
            }
        }
        return true;
    }

    private void handleFollow(@NotNull LivingEntity owner, boolean inRange, boolean isFar, boolean isClose) {
        boolean ownerClose;
        boolean bl = ownerClose = owner.m_20280_(this.recruit) <= 100.0;
        if (ownerClose) {
            if (inRange) {
                ((AbstractRecruitEntity)((Object)this.recruit)).m_21573_().m_26573_();
            }
            if (isFar) {
                ((AbstractRecruitEntity)((Object)this.recruit)).m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            if (isClose) {
                ((BowmanEntity)this.recruit).fleeEntity(this.target);
            }
        }
    }

    private void handleHoldPos(@NotNull Vec3 pos, boolean inRange, boolean isFar, boolean isClose) {
        boolean posClose;
        boolean bl = posClose = pos.m_82557_(this.recruit.m_20182_()) <= 50.0;
        if (posClose && inRange) {
            ((AbstractRecruitEntity)((Object)this.recruit)).m_21573_().m_26573_();
        }
    }

    private void handleWander(boolean inRange, boolean isFar, boolean isClose) {
        if (inRange) {
            ((AbstractRecruitEntity)((Object)this.recruit)).m_21573_().m_26573_();
        }
        if (isFar) {
            ((AbstractRecruitEntity)((Object)this.recruit)).m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        if (isClose) {
            ((BowmanEntity)this.recruit).fleeEntity(this.target);
        }
    }
}

