/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class RecruitEatGoal
extends Goal {
    public AbstractRecruitEntity recruit;
    public ItemStack foodStack;
    public int slotID;
    private long lastCanUseCheckMorale;
    private long lastCanUseCheckHunger;

    public RecruitEatGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    public boolean m_8036_() {
        long i = this.recruit.m_20193_().m_46467_();
        if (i - this.lastCanUseCheckMorale >= 1200L) {
            this.lastCanUseCheckMorale = i;
            this.recruit.updateMorale();
        }
        if (i - this.lastCanUseCheckHunger >= 20L) {
            this.lastCanUseCheckHunger = i;
            this.recruit.updateHunger();
            return this.hasFoodInInv() && this.recruit.needsToEat() && !this.recruit.m_6117_();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.recruit.m_6117_();
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.slotID = 0;
        ItemStack beforeItem = this.recruit.m_21206_().m_41777_();
        this.foodStack = this.getAndRemoveFoodInInv().m_41777_();
        this.recruit.setBeforeItemSlot(this.slotID);
        this.recruit.getInventory().m_6836_(this.recruit.getBeforeItemSlot(), beforeItem);
        this.recruit.m_21008_(InteractionHand.OFF_HAND, this.foodStack);
        this.recruit.m_6672_(InteractionHand.OFF_HAND);
        this.recruit.m_5634_(Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.recruit)).m_38745_() * 1.0f);
        if (!this.recruit.isSaturated()) {
            float saturation = Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.recruit)).m_38745_();
            float nutrition = Objects.requireNonNull(this.foodStack.m_41720_().getFoodProperties(this.foodStack, (LivingEntity)this.recruit)).m_38744_() * 5;
            float currentHunger = this.recruit.getHunger();
            float newHunger = currentHunger + saturation + nutrition;
            if (newHunger > 100.0f) {
                newHunger = 100.0f;
            }
            this.recruit.setHunger(newHunger);
        }
    }

    public void m_8041_() {
        this.recruit.m_5810_();
        if (this.recruit.getMorale() < 100.0f) {
            this.recruit.setMoral(this.recruit.getMorale() + 2.5f);
        }
        this.recruit.resetItemInHand();
    }

    private boolean hasFoodInInv() {
        return this.recruit.getInventory().f_19147_.stream().anyMatch(item -> this.recruit.canEatItemStack((ItemStack)item));
    }

    private ItemStack getAndRemoveFoodInInv() {
        ItemStack itemStack = null;
        for (int i = 0; i < this.recruit.getInventorySize(); ++i) {
            ItemStack stackInSlot = this.recruit.inventory.m_8020_(i).m_41777_();
            if (!this.recruit.canEatItemStack(stackInSlot)) continue;
            itemStack = stackInSlot.m_41777_();
            this.slotID = i;
            this.recruit.inventory.m_8016_(i);
            break;
        }
        return itemStack;
    }
}

