/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.ai.UseShield;
import com.talhanation.recruits.util.FormationUtils;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class ScoutEntity
extends BowmanEntity
implements ICompanion {
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(ScoutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> TASK_STATE = SynchedEntityData.m_135353_(ScoutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());
    private State state = State.IDLE;
    private final int SEARCH_RADIUS = 200;
    public int timerScouting;
    List<ServerPlayer> potentialPlayerTargets;
    List<AbstractRecruitEntity> potentialRecruitTargets;

    public ScoutEntity(EntityType<? extends AbstractRecruitEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(TASK_STATE, (Object)0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new UseShield(this));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("taskState", this.state.getIndex());
        nbt.m_128405_("timerScouting", this.timerScouting);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setTaskState(State.fromIndex(nbt.m_128451_("taskState")));
        this.timerScouting = nbt.m_128451_("timerScouting");
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 128.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.setDropEquipment();
        this.m_21530_();
        if (this.getOwner() != null) {
            this.setOwnerName(this.getOwner().m_7755_().getString());
        }
        AbstractRecruitEntity.applySpawnValues(this);
        if (this.m_7755_().getString().isEmpty()) {
            this.m_6593_((Component)Component.m_237113_((String)"Scout"));
        }
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SwordItem && this.getMatchingItem(item -> item.m_41720_() instanceof SwordItem) == null || itemStack.m_41720_() instanceof BowItem && this.getMatchingItem(item -> item.m_41720_() instanceof BowItem) == null || itemStack.m_41720_() instanceof ShieldItem && this.getMatchingItem(item -> item.m_41720_() instanceof ShieldItem) == null) {
            return true;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CrossbowItem);
    }

    @Override
    public AbstractRecruitEntity get() {
        return this;
    }

    @Override
    public void openSpecialGUI(Player player) {
    }

    public byte getTaskState() {
        return (Byte)this.f_19804_.m_135370_(TASK_STATE);
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)name);
    }

    public void setTaskState(State state) {
        this.f_19804_.m_135381_(TASK_STATE, (Object)((byte)state.getIndex()));
        this.state = state;
    }

    @Override
    public boolean isAtMission() {
        return this.state != State.IDLE;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (--this.timerScouting <= 0) {
            this.timerScouting = 1200;
            this.startTask(State.fromIndex(this.getTaskState()));
        }
    }

    public void startTask(State taskState) {
        this.setTaskState(taskState);
        switch (taskState) {
            case SEARCHING_STRUCTURE: {
                break;
            }
            case SCOUTING: {
                this.findNonFriendlyEntities();
                this.timerScouting = 1200;
                break;
            }
            case SEARCHING_LOST_RECRUITS: {
                break;
            }
        }
    }

    private void sendMessageToOwner(Component message) {
        if (this.getOwner() != null) {
            MutableComponent prefix = Component.m_237113_((String)(this.m_7755_().getString() + ": ")).m_130940_(ChatFormatting.GOLD);
            this.getOwner().m_213846_((Component)prefix.m_7220_(message));
        }
    }

    public void findNonFriendlyEntities() {
        if (this.getOwner() == null) {
            return;
        }
        if (this.m_20193_().m_5776_()) {
            return;
        }
        this.potentialPlayerTargets = new ArrayList<ServerPlayer>();
        this.potentialRecruitTargets = new ArrayList<AbstractRecruitEntity>();
        if (!this.m_20193_().m_5776_()) {
            this.potentialPlayerTargets = this.m_20193_().m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(200.0), target -> this.shouldAttack((LivingEntity)target) && this.m_142582_((Entity)target));
            this.potentialRecruitTargets = this.m_20193_().m_6443_(AbstractRecruitEntity.class, this.m_20191_().m_82400_(200.0), target -> this.shouldAttack((LivingEntity)target) && this.m_142582_((Entity)target));
            if (!this.potentialPlayerTargets.isEmpty()) {
                for (ServerPlayer player : this.potentialPlayerTargets) {
                    String teamName = player.m_5647_() != null ? player.m_5647_().m_5758_() : "";
                    RecruitsPlayerInfo playerInfo = new RecruitsPlayerInfo(player.m_20148_(), player.m_7755_().getString(), FactionEvents.recruitsFactionManager.getTeamByStringID(teamName));
                    int recruitsCount = this.countRecruits(player.m_20148_());
                    int distance = (int)Math.sqrt(this.m_20183_().m_123331_((Vec3i)player.m_20183_()));
                    String direction = this.getHorizontalDirection(this.m_20183_(), player.m_20183_());
                    ScoutingResult result = new ScoutingResult(playerInfo, recruitsCount, distance, direction);
                    result.sendInfo(this);
                }
            }
            if (!this.potentialRecruitTargets.isEmpty()) {
                Map<String, List<LivingEntity>> teamedRecruitsMap = this.potentialRecruitTargets.stream().collect(Collectors.groupingBy(recruit -> recruit.m_5647_() != null ? recruit.m_5647_().m_5758_() : "No Team"));
                for (Map.Entry<String, List<LivingEntity>> entry : teamedRecruitsMap.entrySet()) {
                    String teamName = entry.getKey();
                    int recruitCount = entry.getValue().size();
                    Vec3 vec = FormationUtils.getCenterOfPositions(entry.getValue(), (ServerLevel)this.m_20193_());
                    int distance = (int)Math.sqrt(this.m_20183_().m_123331_((Vec3i)new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_)));
                    String direction = this.getHorizontalDirection(this.m_20183_(), new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_));
                    ScoutingResult result = new ScoutingResult(teamName, recruitCount, distance, direction);
                    result.sendInfo(this);
                }
            }
        }
    }

    private int countRecruits(UUID uuid) {
        Predicate<AbstractRecruitEntity> predicate = recruit -> recruit.isOwned() && recruit.getOwnerUUID().equals(uuid);
        int amount = (int)this.potentialRecruitTargets.stream().filter(predicate).count();
        this.potentialRecruitTargets.removeIf(predicate);
        return amount;
    }

    private String getHorizontalDirection(BlockPos from, BlockPos to) {
        double dx = to.m_123341_() - from.m_123341_();
        double dz = to.m_123343_() - from.m_123343_();
        double angle = Math.toDegrees(Math.atan2(dz, dx));
        if ((angle = (angle + 360.0) % 360.0) >= 337.5 || angle < 22.5) {
            return "East";
        }
        if (angle >= 22.5 && angle < 67.5) {
            return "South-East";
        }
        if (angle >= 67.5 && angle < 112.5) {
            return "South";
        }
        if (angle >= 112.5 && angle < 157.5) {
            return "South-West";
        }
        if (angle >= 157.5 && angle < 202.5) {
            return "West";
        }
        if (angle >= 202.5 && angle < 247.5) {
            return "North-West";
        }
        if (angle >= 247.5 && angle < 292.5) {
            return "North";
        }
        return "North-East";
    }

    public static enum State {
        IDLE(0),
        SCOUTING(1),
        SEARCHING_STRUCTURE(2),
        SEARCHING_LOST_RECRUITS(3);

        private final int index;

        private State(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static State fromIndex(int index) {
            for (State state : State.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid State index: " + index);
        }
    }

    private static class ScoutingResult {
        RecruitsPlayerInfo playerInfo;
        int recruitsCount;
        int distance;
        String direction;
        String team;

        ScoutingResult(RecruitsPlayerInfo playerInfo, int recruits, int distance, String direction) {
            this.playerInfo = playerInfo;
            this.recruitsCount = recruits;
            this.distance = distance;
            this.direction = direction;
        }

        ScoutingResult(String team, int recruits, int distance, String direction) {
            this((RecruitsPlayerInfo)null, recruits, distance, direction);
            this.team = team;
        }

        public void sendInfo(ScoutEntity scout) {
            MutableComponent recruitsText = Component.m_237113_((String)("" + this.recruitsCount)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            MutableComponent distanceText = Component.m_237113_((String)("" + this.distance)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            MutableComponent directionText = Component.m_237113_((String)this.direction).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            if (this.playerInfo != null) {
                MutableComponent playerName = Component.m_237113_((String)this.playerInfo.getName());
                if (this.playerInfo.getRecruitsTeam() != null) {
                    playerName = Component.m_237113_((String)this.playerInfo.getName()).m_130940_(ChatFormatting.m_126647_((int)this.playerInfo.getRecruitsTeam().getTeamColor()));
                    MutableComponent teamName = Component.m_237113_((String)this.playerInfo.getRecruitsTeam().getTeamDisplayName()).m_130940_(ChatFormatting.m_126647_((int)this.playerInfo.getRecruitsTeam().getTeamColor()));
                    scout.sendMessageToOwner((Component)Component.m_237113_((String)"").m_7220_((Component)playerName).m_130946_(" (").m_7220_((Component)teamName).m_130946_("), with ").m_7220_((Component)recruitsText).m_130946_(" units, ").m_7220_((Component)distanceText).m_130946_(" blocks, ").m_7220_((Component)directionText).m_130946_(" from me."));
                } else {
                    scout.sendMessageToOwner((Component)Component.m_237113_((String)"").m_7220_((Component)playerName).m_130946_(" with ").m_7220_((Component)recruitsText).m_130946_(" units, ").m_7220_((Component)distanceText).m_130946_(" blocks, ").m_7220_((Component)directionText).m_130946_(" from me."));
                }
            } else if (this.team != null) {
                MutableComponent teamText = Component.m_237113_((String)this.team);
                scout.sendMessageToOwner((Component)Component.m_237113_((String)"").m_7220_((Component)recruitsText).m_130946_(" units of ").m_7220_((Component)teamText).m_130946_(", ").m_7220_((Component)distanceText).m_130946_(" blocks, ").m_7220_((Component)directionText).m_130946_(" from me."));
            }
        }
    }
}

