/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.ai.NomadAttackAI;
import com.talhanation.recruits.pathfinding.AsyncGroundPathNavigation;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class NomadEntity
extends BowmanEntity {
    private static final EntityDataAccessor<Boolean> HAD_HORSE = SynchedEntityData.m_135353_(NomadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isPatrol = false;

    public NomadEntity(EntityType<? extends AbstractRecruitEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAD_HORSE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("hadHorse", this.getHadHorse());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setHadHorse(nbt.m_128471_("hadHorse"));
    }

    private void setHadHorse(boolean hadHorse) {
        this.f_19804_.m_135381_(HAD_HORSE, (Object)hadHorse);
    }

    private boolean getHadHorse() {
        return (Boolean)this.f_19804_.m_135370_(HAD_HORSE);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new NomadAttackAI(this));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 0.05).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 64.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        RandomSource randomsource = world.m_213780_();
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((AsyncGroundPathNavigation)this.m_21573_()).setCanOpenDoors(true);
        this.m_213946_(randomsource, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.m_6593_((Component)Component.m_237113_((String)"Nomad"));
        this.setCost((Integer)RecruitsServerConfig.NomadCost.get());
        this.setEquipment();
        this.setDropEquipment();
        this.setRandomSpawnBonus();
        this.m_21530_();
        AbstractRecruitEntity.applySpawnValues(this);
    }

    @Override
    public double arrowDamageModifier() {
        return 1.3;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.getHadHorse() && (((Boolean)RecruitsServerConfig.RecruitHorseUnitsHorse.get()).booleanValue() || this.isPatrol)) {
            boolean hasHorse;
            boolean bl = hasHorse = this.m_20202_() != null && this.m_20202_() instanceof AbstractHorse;
            if (!hasHorse) {
                Horse horse = new Horse(EntityType.f_20457_, this.m_20193_());
                horse.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                horse.m_30651_(true);
                horse.m_5853_(null);
                Variant variant = (Variant)Util.m_214670_((Object[])Variant.values(), (RandomSource)this.m_217043_());
                Markings markings = (Markings)Util.m_214670_((Object[])Markings.values(), (RandomSource)this.m_217043_());
                horse.m_30699_(variant, markings);
                this.m_20329_((Entity)horse);
                this.m_20193_().m_7967_((Entity)horse);
                this.setHadHorse(true);
                this.setMountUUID(Optional.of(horse.m_20148_()));
            }
        }
    }

    @Override
    public void m_8107_() {
        Entity entity;
        super.m_8107_();
        this.m_20193_().m_46473_().m_6180_("looting");
        if (!this.m_20193_().f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_20193_(), (Entity)this)) {
            this.m_20193_().m_6443_(ItemEntity.class, this.m_20191_().m_82377_(2.5, 2.5, 2.5), itemEntity -> !itemEntity.m_213877_() && !itemEntity.m_32055_().m_41619_() && !itemEntity.m_32063_() && this.m_7243_(itemEntity.m_32055_())).forEach(this::m_7581_);
        }
        if ((entity = this.m_20202_()) instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)entity;
            abstractHorse.m_20256_(abstractHorse.m_20184_().m_82549_(this.m_20184_().m_82490_(2.0)));
        }
    }

    @Override
    public List<List<String>> getEquipment() {
        return (List)RecruitsServerConfig.NomadStartEquipments.get();
    }

    public static enum State {
        SELECT_TARGET,
        CIRCLE_TARGET;

    }
}

