/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.group.EditOrAddGroupScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class ImageSelectionDropdownMatrix
extends AbstractWidget {
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)80, (int)80, (int)80);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    private final List<ResourceLocation> options;
    private final Consumer<ResourceLocation> onSelect;
    private final EditOrAddGroupScreen parent;
    private ResourceLocation selectedOption;
    private boolean isOpen;
    private final int cellSize = 22;
    private final int columns = 4;
    private final int rows = 5;

    public ImageSelectionDropdownMatrix(EditOrAddGroupScreen parent, int x, int y, int width, int height, List<ResourceLocation> options, Consumer<ResourceLocation> onSelect) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.options = options;
        this.onSelect = onSelect;
        this.selectedOption = parent.getSelectedImage();
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        gui.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, BG_FILL_SELECTED);
        if (this.selectedOption != null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.selectedOption);
            gui.m_280163_(this.selectedOption, this.m_252754_() + 3, this.m_252907_() + 3, 0.0f, 0.0f, this.f_93619_ - 6, this.f_93619_ - 6, this.f_93619_ - 6, this.f_93619_ - 6);
        }
        if (this.isOpen) {
            int startX = this.m_252754_() + this.f_93618_;
            int startY = this.m_252907_();
            for (int i = 0; i < this.options.size(); ++i) {
                int col = i % 4;
                int row = i / 4;
                int ox = startX + col * 22;
                int oy = startY + row * 22;
                ResourceLocation img = this.options.get(i);
                if (mouseX >= ox && mouseX <= ox + 22 && mouseY >= oy && mouseY <= oy + 22) {
                    gui.m_280509_(ox, oy, ox + 22, oy + 22, BG_FILL_HOVERED);
                } else {
                    gui.m_280509_(ox, oy, ox + 22, oy + 22, BG_FILL);
                }
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)img);
                gui.m_280163_(img, ox + 3, oy + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    public void onMouseClicked(double mouseX, double mouseY) {
        if (this.isOpen) {
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY;
                int col = i % 4;
                int row = i / 4;
                int optionX = this.m_252754_() + this.f_93618_ + col * 22;
                if (!this.isMouseOverOption((int)mouseX, (int)mouseY, optionX, optionY = this.m_252907_() + row * 22)) continue;
                this.selectOption(this.options.get(i));
                this.isOpen = false;
                return;
            }
        }
        this.isOpen = this.isMouseOverDisplay((int)mouseX, (int)mouseY) ? !this.isOpen : false;
    }

    public void onMouseMove(double mouseX, double mouseY) {
        if (this.isOpen) {
            boolean isOverDropdown = this.isMouseOverDropdown((int)mouseX, (int)mouseY);
            boolean isOverDisplay = this.isMouseOverDisplay((int)mouseX, (int)mouseY);
            if (!isOverDropdown && !isOverDisplay) {
                this.isOpen = false;
            }
        }
    }

    private boolean isMouseOverDisplay(int mouseX, int mouseY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_;
    }

    private boolean isMouseOverDropdown(int mouseX, int mouseY) {
        if (!this.isOpen) {
            return false;
        }
        int dropdownStartX = this.m_252754_() + this.f_93618_;
        int dropdownStartY = this.m_252907_();
        int dropdownEndX = dropdownStartX + 88;
        int dropdownEndY = dropdownStartY + 110;
        return mouseX >= dropdownStartX && mouseX <= dropdownEndX && mouseY >= dropdownStartY && mouseY <= dropdownEndY;
    }

    private boolean isMouseOverOption(int mouseX, int mouseY, int optionX, int optionY) {
        return mouseX >= optionX && mouseX <= optionX + 22 && mouseY >= optionY && mouseY <= optionY + 22;
    }

    private void selectOption(ResourceLocation option) {
        this.selectedOption = option;
        this.onSelect.accept(option);
        this.isOpen = false;
    }

    protected void m_168797_(NarrationElementOutput narration) {
    }
}

