/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class FactionClaimBannerOverlay {
    private static final long FULL_DISPLAY_DURATION = 5000L;
    private static final long ANIMATION_TIME = 1000L;
    private static long startTime = -1L;
    private static long stripStartTime = -1L;
    private static boolean active = false;
    private static RecruitsFaction currentTeam;
    private static String claimName;
    private static String playerName;
    private static BannerRenderer bannerRenderer;
    public static UUID claimUUID;

    public static void activate(RecruitsClaim claim) {
        claimUUID = claim.getUUID();
        currentTeam = claim.getOwnerFaction();
        claimName = claim.getName();
        playerName = claim.getPlayerInfo().getName();
        bannerRenderer = new BannerRenderer(claim.getOwnerFaction());
        startTime = System.currentTimeMillis();
        stripStartTime = -1L;
        active = true;
    }

    public static void deactivate() {
        active = false;
        stripStartTime = System.currentTimeMillis();
    }

    public static void renderOverlay(GuiGraphics guiGraphics, int screenWidth) {
        if (startTime <= 0L || currentTeam == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - startTime;
        if (elapsed < 6000L) {
            int yOffset;
            if (elapsed < 1000L) {
                float t = (float)elapsed / 1000.0f;
                yOffset = (int)(-50.0f + 50.0f * t);
            } else if (elapsed < 5000L) {
                yOffset = 0;
            } else {
                float t = (float)(elapsed - 5000L) / 1000.0f;
                yOffset = (int)(-50.0f * t);
                if (t >= 1.0f && stripStartTime < 0L) {
                    stripStartTime = System.currentTimeMillis();
                }
            }
            FactionClaimBannerOverlay.drawBanner(guiGraphics, screenWidth, yOffset);
            return;
        }
        if (stripStartTime < 0L) {
            stripStartTime = now;
        }
        long stripElapsed = now - stripStartTime;
        int yOffset = 0;
        if (active) {
            if (stripElapsed < 1000L) {
                float t = (float)stripElapsed / 1000.0f;
                yOffset = (int)(-20.0f + 20.0f * t);
            }
        } else if (stripElapsed < 1000L) {
            float t = (float)stripElapsed / 1000.0f;
            yOffset = (int)(-20.0f * t);
        } else {
            FactionClaimBannerOverlay.reset();
            return;
        }
        FactionClaimBannerOverlay.drawStrip(guiGraphics, screenWidth, yOffset);
    }

    private static void drawBanner(GuiGraphics guiGraphics, int screenWidth, int yOffset) {
        int width = 150;
        int height = 50;
        int x = (screenWidth - width) / 2;
        int y = 10 + yOffset;
        int alpha = 5;
        int rgb = TeamEditScreen.unitColors.get(currentTeam.getUnitColor()).getRGB();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int argb = alpha << 24 | r << 16 | g << 8 | b;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280509_(x - 5, y - 5, x + width + 5, y + height + 5, argb);
        RenderSystem.disableBlend();
        Font font = Minecraft.m_91087_().f_91062_;
        bannerRenderer.renderBanner(guiGraphics, x + 5, y + 17, width, height, 25);
        guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)claimName), x + 40, y + 5, 0xFFFFFF);
        guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)currentTeam.getTeamDisplayName()), x + 40, y + 20, 0xAAAAAA);
        guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)playerName), x + 40, y + 35, 0xAAAAAA);
    }

    private static void drawStrip(GuiGraphics guiGraphics, int screenWidth, int yOffset) {
        int width = 150;
        int height = 10;
        int x = (screenWidth - width) / 2;
        int y = 10 + yOffset;
        int alpha = 5;
        int rgb = TeamEditScreen.unitColors.get(currentTeam.getUnitColor()).getRGB();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int argb = alpha << 24 | r << 16 | g << 8 | b;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280509_(x - 5, y - 5, x + width + 5, y + height + 5, argb);
        RenderSystem.disableBlend();
        Font font = Minecraft.m_91087_().f_91062_;
        String text = claimName + " - " + currentTeam.getTeamDisplayName();
        guiGraphics.m_280137_(font, text, screenWidth / 2, y + 1, 0xFFFFFF);
    }

    private static void reset() {
        startTime = -1L;
        stripStartTime = -1L;
        currentTeam = null;
        claimName = null;
        playerName = null;
        bannerRenderer = null;
    }

    public static void update(RecruitsClaim claim) {
        claimUUID = claim.getUUID();
        claimName = claim.getName();
        playerName = claim.getPlayerInfo().getName();
        currentTeam = claim.getOwnerFaction();
    }
}

