/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.group.IGroupSelection;
import com.talhanation.recruits.client.gui.widgets.ListScreenEntryBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RecruitsGroupEntry
extends ListScreenEntryBase<RecruitsGroupEntry> {
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)80, (int)80, (int)80);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final IGroupSelection screen;
    @NotNull
    protected final RecruitsGroup group;
    protected ResourceLocation image;

    public RecruitsGroupEntry(IGroupSelection screen, @NotNull RecruitsGroup group) {
        this.screen = screen;
        this.group = group;
        this.image = RecruitsGroup.IMAGES.get(group.getImage());
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = top + (height - 9) / 2;
        guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        this.renderElement(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovered, delta, skinX, skinY, textX, textY);
    }

    public void renderElement(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        boolean selected;
        boolean bl = selected = this.screen.getSelected() != null && this.group.getUUID().equals(this.screen.getSelected().getUUID());
        if (selected) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        }
        if (this.image != null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.image);
            guiGraphics.m_280163_(this.image, left + 5, top + 5, 0.0f, 0.0f, 21, 21, 21, 21);
        }
        guiGraphics.drawString(this.minecraft.f_91062_, this.group.getName(), (float)textX, (float)textY, PLAYER_NAME_COLOR, false);
        guiGraphics.drawString(this.minecraft.f_91062_, "[" + this.group.getCount() + "/" + this.group.getSize() + "]", (float)textX + 130.0f, (float)textY, PLAYER_NAME_COLOR, false);
    }

    public RecruitsGroup getGroup() {
        return this.group;
    }

    @Override
    public ListScreenListBase<RecruitsGroupEntry> getList() {
        return this.screen.getGroupList();
    }
}

