/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.faction;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.faction.TeamInspectionScreen;
import com.talhanation.recruits.client.gui.faction.TeamMainScreen;
import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.player.SelectPlayerScreen;
import com.talhanation.recruits.client.gui.widgets.BlackShowingTextField;
import com.talhanation.recruits.client.gui.widgets.ColorChatFormattingSelectionDropdownMatrix;
import com.talhanation.recruits.client.gui.widgets.ColorSelectionDropdownMatrix;
import com.talhanation.recruits.client.gui.widgets.SelectedPlayerWidget;
import com.talhanation.recruits.inventory.TeamEditMenu;
import com.talhanation.recruits.network.MessageCreateTeam;
import com.talhanation.recruits.network.MessageSaveTeamSettings;
import com.talhanation.recruits.world.RecruitsFactionManager;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class TeamEditScreen
extends ScreenBase<TeamEditMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/team/team_create_gui.png");
    private static final Component EDIT = Component.m_237115_((String)"gui.recruits.team.edit");
    private static final Component BACK = Component.m_237115_((String)"gui.recruits.button.back");
    private static final Component SAVE = Component.m_237115_((String)"gui.recruits.button.save");
    private static final Component CREATE = Component.m_237115_((String)"gui.recruits.team_creation.create_team");
    private static final Component TEAM_NAME = Component.m_237115_((String)"gui.recruits.team.team_name");
    private static final Component LEADER = Component.m_237115_((String)"gui.recruits.team.leader");
    private static final Component TEAM_COLOR = Component.m_237115_((String)"gui.recruits.team.team_color");
    private static final Component UNITS_COLOR = Component.m_237115_((String)"gui.recruits.team.units_color");
    private static final Component MAX_RECRUITS = Component.m_237115_((String)"gui.recruits.team.max_recruits");
    private static final Component SELECT_LEADER_TOOLTIP = Component.m_237115_((String)"gui.recruits.team.select_leader_tooltip");
    public int maxRecruitsPerPlayer;
    private ColorChatFormattingSelectionDropdownMatrix teamColorDropdownMatrix;
    private ColorSelectionDropdownMatrix unitColorDropdownMatrix;
    private final Player player;
    private Screen parent;
    private ChatFormatting teamColor;
    private Color unitColor;
    private BannerRenderer bannerRenderer;
    private EditBox textFieldTeamName;
    private SelectedPlayerWidget leaderWidget;
    public static RecruitsPlayerInfo leaderInfo;
    private ItemStack banner;
    private Button saveButton;
    private int guiLeft;
    private int guiTop;
    private int totalCost;
    private boolean hasChanges;
    private String teamNameSavedValue;
    public static final ArrayList<ChatFormatting> teamColors;
    public static final ArrayList<Component> teamColorsNames;
    public static final ArrayList<Color> unitColors;
    public static final ArrayList<Component> unitColorsNames;
    public static boolean postInit;
    int x1 = 15;
    int y1 = 61;
    private static final Pattern VALID_FACTION_NAME;

    public TeamEditScreen(TeamEditMenu container, Inventory playerInventory, Component title) {
        super(TEXTURE, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97727_ = 240;
        this.f_97726_ = 222;
        this.player = playerInventory.f_35978_;
        ((TeamEditMenu)this.f_97732_).setScreen(this);
        this.teamNameSavedValue = "";
    }

    protected void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        this.guiTop = (this.f_96544_ - this.f_97727_) / 2;
        postInit = true;
        super.m_7856_();
    }

    public void postInit() {
        if (ClientManager.ownFaction != null) {
            this.teamColor = ChatFormatting.m_126647_((int)ClientManager.ownFaction.getTeamColor());
            this.unitColor = unitColors.get(ClientManager.ownFaction.getUnitColor());
            if (leaderInfo == null) {
                leaderInfo = new RecruitsPlayerInfo(ClientManager.ownFaction.getTeamLeaderUUID(), ClientManager.ownFaction.getTeamLeaderName(), ClientManager.ownFaction);
            }
            this.maxRecruitsPerPlayer = ClientManager.ownFaction.getMaxNPCsPerPlayer();
            if (this.maxRecruitsPerPlayer == -1) {
                this.maxRecruitsPerPlayer = ClientManager.factionMaxRecruitsPerPlayerConfigSetting;
            }
            this.parent = new TeamInspectionScreen(new TeamMainScreen(this.player), this.player);
            this.bannerRenderer = new BannerRenderer(ClientManager.ownFaction);
        } else {
            this.teamColor = teamColors.get(15);
            this.unitColor = unitColors.get(0);
            if (leaderInfo == null) {
                leaderInfo = new RecruitsPlayerInfo(this.player.m_20148_(), this.player.m_7755_().getString());
            }
            this.maxRecruitsPerPlayer = ClientManager.factionMaxRecruitsPerPlayerConfigSetting;
            this.parent = new TeamMainScreen(this.player);
            this.bannerRenderer = new BannerRenderer(null);
        }
        this.setWidgets();
    }

    public void setParent(Screen parent) {
        this.parent = parent;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.textFieldTeamName != null) {
            this.textFieldTeamName.m_94120_();
        }
        if (postInit) {
            this.postInit();
            postInit = false;
        }
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = ClientManager.ownFaction != null ? this.checkEditCondition() : this.checkCreationCondition();
        }
    }

    private void setWidgets() {
        this.m_169413_();
        String teamName = ClientManager.ownFaction != null ? ClientManager.ownFaction.getTeamDisplayName() : this.teamNameSavedValue;
        int textsX = 46;
        int gap = 3;
        int widgetsX = 107;
        int widgetsY = 225;
        this.banner = ((TeamEditMenu)this.f_97732_).getBanner();
        this.textFieldTeamName = new EditBox(this.f_96547_, this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 0, 110, 20, (Component)Component.m_237113_((String)teamName));
        this.textFieldTeamName.m_94202_(-1);
        this.textFieldTeamName.m_94205_(-1);
        this.textFieldTeamName.m_94182_(true);
        this.textFieldTeamName.m_94199_(32);
        this.textFieldTeamName.m_94144_(teamName);
        this.textFieldTeamName.m_94151_(this::onTextInput);
        this.m_7787_((GuiEventListener)this.textFieldTeamName);
        this.m_264313_((GuiEventListener)this.textFieldTeamName);
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 4, 110, 20, 45, 0, this.getMaxRecruitsPerPlayerString()));
        if (leaderInfo != null) {
            this.leaderWidget = new SelectedPlayerWidget(this.f_96547_, this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 1, 110, 20, (Component)Component.m_237113_((String)"x"), () -> {
                leaderInfo = null;
                this.leaderWidget.setPlayer(null, null);
                this.setWidgets();
            });
            this.leaderWidget.setPlayer(leaderInfo.getUUID(), leaderInfo.getName());
            this.leaderWidget.setButtonActive(ClientManager.ownFaction != null);
            this.leaderWidget.setButtonVisible(ClientManager.ownFaction != null);
            this.m_142416_((GuiEventListener)this.leaderWidget);
        } else {
            Button selectPlayerButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 1, 110, 20, SelectPlayerScreen.TITLE, button -> {
                RecruitsScreenBase parent = ClientManager.ownFaction == null ? new TeamMainScreen(this.player) : new TeamInspectionScreen(new TeamMainScreen(this.player), this.player);
                this.f_96541_.m_91152_((Screen)new SelectPlayerScreen(parent, this.player, SelectPlayerScreen.TITLE, SelectPlayerScreen.BUTTON_SELECT, SelectPlayerScreen.BUTTON_SELECT_TOOLTIP, false, PlayersList.FilterType.SAME_TEAM, playerInfo -> {
                    leaderInfo = playerInfo;
                    FactionEvents.openTeamEditScreen(this.player);
                    this.setWidgets();
                }));
            }));
            selectPlayerButton.m_257544_(Tooltip.m_257550_((Component)SELECT_LEADER_TOOLTIP));
        }
        this.teamColorDropdownMatrix = new ColorChatFormattingSelectionDropdownMatrix(this, this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 2, 110, 20, teamColors, this::setTeamColor);
        this.m_142416_((GuiEventListener)this.teamColorDropdownMatrix);
        this.unitColorDropdownMatrix = new ColorSelectionDropdownMatrix(this, this.guiLeft + widgetsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 3, 110, 20, unitColors, this::setUnitColor);
        this.m_142416_((GuiEventListener)this.unitColorDropdownMatrix);
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + widgetsX + 20, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 4, 20, 20, (Component)Component.m_237113_((String)"-"), button -> {
            this.maxRecruitsPerPlayer = TeamEditScreen.m_96638_() ? (this.maxRecruitsPerPlayer -= 5) : --this.maxRecruitsPerPlayer;
            if (this.maxRecruitsPerPlayer < 0) {
                this.maxRecruitsPerPlayer = 0;
            }
            this.setWidgets();
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + widgetsX + 90, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 4, 20, 20, (Component)Component.m_237113_((String)"+"), button -> {
            this.maxRecruitsPerPlayer = TeamEditScreen.m_96638_() ? (this.maxRecruitsPerPlayer += 5) : ++this.maxRecruitsPerPlayer;
            if (this.maxRecruitsPerPlayer > ClientManager.factionMaxRecruitsPerPlayerConfigSetting) {
                this.maxRecruitsPerPlayer = ClientManager.factionMaxRecruitsPerPlayerConfigSetting;
            }
            this.setWidgets();
        }));
        this.banner = ((TeamEditMenu)this.f_97732_).getBanner();
        if (ClientManager.ownFaction == null) {
            this.saveButton = new ExtendedButton(this.guiLeft + 30, this.guiTop + this.f_97727_ - 102, 162, 20, CREATE, btn -> {
                String text = this.textFieldTeamName.m_94155_().strip();
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCreateTeam(this.getCorrectFormatStringID(text), this.getCorrectFormatName(text), this.banner, this.teamColor, unitColors.indexOf(this.unitColor)));
                leaderInfo = null;
                this.f_96541_.m_91152_((Screen)new TeamInspectionScreen(new TeamMainScreen(this.player), this.player));
            });
            this.saveButton.f_93623_ = this.checkCreationCondition();
            this.m_142416_((GuiEventListener)this.saveButton);
        } else {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 117, this.guiTop + this.f_97727_ - 102, 75, 20, BACK, btn -> {
                leaderInfo = null;
                this.f_96541_.m_91152_(this.parent);
            }));
            this.saveButton = new ExtendedButton(this.guiLeft + 30, this.guiTop + this.f_97727_ - 102, 75, 20, SAVE, btn -> {
                ClientManager.ownFaction.setTeamLeaderID(leaderInfo.getUUID());
                ClientManager.ownFaction.setTeamLeaderName(leaderInfo.getName());
                ClientManager.ownFaction.setTeamDisplayName(this.textFieldTeamName.m_94155_());
                ClientManager.ownFaction.setTeamColor(this.teamColor.m_126656_());
                if (this.banner != null && !this.banner.m_41619_()) {
                    ClientManager.ownFaction.setBanner(this.banner.serializeNBT());
                }
                ClientManager.ownFaction.setUnitColor((byte)unitColors.indexOf(this.unitColor));
                ClientManager.ownFaction.setMaxNPCsPerPlayer(this.maxRecruitsPerPlayer);
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveTeamSettings(ClientManager.ownFaction, this.totalCost));
                this.f_96541_.m_91152_((Screen)new TeamInspectionScreen(new TeamMainScreen(this.player), this.player));
            });
            this.saveButton.f_93623_ = this.checkEditCondition();
            this.m_142416_((GuiEventListener)this.saveButton);
        }
        this.calculateCost();
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + textsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 0, 60, 20, TEAM_NAME));
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + textsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 1, 60, 20, LEADER));
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + textsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 2, 60, 20, TEAM_COLOR));
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + textsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 3, 60, 20, UNITS_COLOR));
        this.m_169394_((Renderable)new BlackShowingTextField(this.guiLeft + textsX, this.guiTop + this.f_97727_ - widgetsY + (20 + gap) * 4, 60, 20, MAX_RECRUITS));
        this.saveButton.m_257544_(this.getErrorMessage());
    }

    private void calculateCost() {
        if (ClientManager.ownFaction != null) {
            this.hasChanges = false;
            this.totalCost = 0;
            if (this.teamColor != null && ClientManager.ownFaction.getTeamColor() != this.teamColor.m_126656_()) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
            if (ClientManager.ownFaction.getUnitColor() != unitColors.indexOf(this.unitColor)) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
            if (leaderInfo != null && !ClientManager.ownFaction.getTeamLeaderUUID().equals(leaderInfo.getUUID())) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
            if (this.textFieldTeamName != null && !ClientManager.ownFaction.getTeamDisplayName().equals(this.textFieldTeamName.m_94155_())) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
            if (ClientManager.ownFaction.getMaxNPCsPerPlayer() != this.maxRecruitsPerPlayer) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
            if (this.banner != null && !this.banner.m_41619_() && !ClientManager.ownFaction.getBanner().equals((Object)this.banner.serializeNBT())) {
                this.totalCost += ClientManager.factionCreationPrice;
                this.hasChanges = true;
            }
        } else {
            this.totalCost = ClientManager.factionCreationPrice;
        }
        if (ClientManager.currency != null) {
            ClientManager.currency.m_41764_(this.totalCost);
        }
    }

    private void setUnitColor(Color color) {
        this.unitColor = color;
        this.setWidgets();
    }

    private void setTeamColor(ChatFormatting selected) {
        this.teamColor = selected;
        this.setWidgets();
    }

    public void m_94757_(double x, double y) {
        if (this.teamColorDropdownMatrix != null) {
            this.teamColorDropdownMatrix.onMouseMove(x, y);
        }
        if (this.unitColorDropdownMatrix != null) {
            this.unitColorDropdownMatrix.onMouseMove(x, y);
        }
        super.m_94757_(x, y);
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        if (this.teamColorDropdownMatrix != null) {
            this.teamColorDropdownMatrix.onMouseClicked(x, y);
        }
        if (this.unitColorDropdownMatrix != null) {
            this.unitColorDropdownMatrix.onMouseClicked(x, y);
        }
        return super.m_6375_(x, y, p_94697_);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (this.bannerRenderer != null) {
            this.bannerRenderer.renderBanner(guiGraphics, this.guiLeft + this.x1, this.guiTop + this.y1, this.f_96543_, this.f_96544_, 50);
        }
        this.renderForeground(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int crownX = this.f_96543_ / 2 - 23;
        int crownY = this.guiTop + 41;
        int currencyX = this.f_96543_ / 2 - 28;
        int currencyY = this.guiTop + 140;
        if (ClientManager.ownFaction == null) {
            currencyX = this.f_96543_ / 2 + 63;
        }
        guiGraphics.m_280430_(this.f_96547_, this.m_96636_(), this.guiLeft + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.m_96636_()) / 2, this.guiTop + 5, 0x404040);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TeamInspectionScreen.LEADER_CROWN);
        guiGraphics.m_280163_(TeamInspectionScreen.LEADER_CROWN, crownX, crownY, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.totalCost > 0 && ClientManager.currency != null) {
            guiGraphics.m_280203_(ClientManager.currency, currencyX, currencyY);
            guiGraphics.m_280370_(this.f_96547_, ClientManager.currency, currencyX, currencyY);
        }
        if (this.textFieldTeamName != null) {
            this.textFieldTeamName.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public Component getMaxRecruitsPerPlayerString() {
        return Component.m_237110_((String)"gui.recruits.two_values_with_slash", (Object[])new Object[]{this.maxRecruitsPerPlayer, ClientManager.factionMaxRecruitsPerPlayerConfigSetting});
    }

    public ChatFormatting getSelectedTeamColor() {
        return this.teamColor;
    }

    public Color getSelectedUnitColor() {
        return this.unitColor;
    }

    public int getSelectedUnitColorNameIndex() {
        return unitColors.indexOf(this.unitColor);
    }

    public int getSelectedTeamColorNameIndex() {
        return this.teamColor.m_126656_();
    }

    private String getCorrectFormatStringID(String input) {
        input = input.replaceAll(" ", "_");
        input = this.getCorrectFormatName(input);
        return input;
    }

    private String getCorrectFormatName(String input) {
        input = input.replaceAll("  ", " ");
        input = input.replaceAll("   ", " ");
        input = VALID_FACTION_NAME.matcher(input).replaceAll("");
        return input;
    }

    private boolean checkCreationCondition() {
        boolean nameLength = this.textFieldTeamName != null && this.textFieldTeamName.m_94155_().length() >= 3 && this.textFieldTeamName.m_94155_().length() <= 32;
        boolean sufficientEmeralds = this.player.m_7500_() || this.getPlayerCurrencyAmount() >= ClientManager.factionCreationPrice;
        boolean bannerNotEmpty = this.banner != null && !this.banner.m_41619_() && !RecruitsFactionManager.isBannerBlank(this.banner);
        boolean bannerNotInUse = this.banner != null && !RecruitsFactionManager.isBannerInUse(this.banner.serializeNBT(), ClientManager.factions);
        boolean factionNameOK = !RecruitsFactionManager.isNameInUse(this.textFieldTeamName.m_94155_(), ClientManager.factions);
        return bannerNotInUse && bannerNotEmpty && factionNameOK && nameLength && leaderInfo != null && sufficientEmeralds;
    }

    private boolean checkEditCondition() {
        boolean nameLength = this.textFieldTeamName != null && this.textFieldTeamName.m_94155_().length() >= 3 && this.textFieldTeamName.m_94155_().length() <= 32;
        boolean sufficientEmeralds = this.getPlayerCurrencyAmount() >= this.totalCost || this.player.m_7500_();
        boolean nameEquals = this.textFieldTeamName.m_94155_().equals(ClientManager.ownFaction.getTeamDisplayName());
        boolean displayNameOK = nameEquals || !RecruitsFactionManager.isDisplayNameInUse(this.textFieldTeamName.m_94155_(), ClientManager.factions) && !RecruitsFactionManager.isNameInUse(this.textFieldTeamName.m_94155_(), ClientManager.factions);
        boolean bannerNotEmpty = true;
        if (this.banner != null && !this.banner.m_41619_()) {
            if (RecruitsFactionManager.isBannerBlank(this.banner)) {
                bannerNotEmpty = false;
            } else if (!ItemStack.m_150942_((ItemStack)this.banner, (ItemStack)ItemStack.m_41712_((CompoundTag)ClientManager.ownFaction.getBanner())) && RecruitsFactionManager.isBannerInUse(this.banner.serializeNBT(), ClientManager.factions)) {
                bannerNotEmpty = false;
            }
        }
        boolean bannerNotInUse = this.banner != null && !RecruitsFactionManager.isBannerInUse(this.banner.serializeNBT(), ClientManager.factions);
        return bannerNotInUse && bannerNotEmpty && nameLength && leaderInfo != null && sufficientEmeralds && this.hasChanges && displayNameOK;
    }

    public Component m_96636_() {
        return this.f_96539_;
    }

    private int getPlayerCurrencyAmount() {
        int count = 0;
        for (ItemStack stack : this.player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_150930_(ClientManager.currency.m_41720_())) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public void onBannerPlaced() {
        if (((TeamEditMenu)this.f_97732_).getBanner() != null && this.bannerRenderer != null) {
            if (((TeamEditMenu)this.f_97732_).getBanner().m_41619_()) {
                if (ClientManager.ownFaction != null) {
                    this.bannerRenderer.setBannerItem(ItemStack.m_41712_((CompoundTag)ClientManager.ownFaction.getBanner()));
                }
                this.banner = null;
            } else {
                this.banner = ((TeamEditMenu)this.f_97732_).getBanner();
                this.bannerRenderer.setBannerItem(((TeamEditMenu)this.f_97732_).getBanner());
            }
        }
        this.calculateCost();
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = ClientManager.ownFaction != null ? this.checkEditCondition() : this.checkCreationCondition();
            this.saveButton.m_257544_(this.getErrorMessage());
        }
    }

    private void onTextInput(String string) {
        if (ClientManager.ownFaction == null) {
            this.saveButton.f_93623_ = this.checkCreationCondition();
        } else {
            this.calculateCost();
            this.saveButton.f_93623_ = this.checkEditCondition();
        }
        this.teamNameSavedValue = string;
        this.saveButton.m_257544_(this.getErrorMessage());
    }

    public void onPlayerInventoryChanged() {
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = ClientManager.ownFaction != null ? this.checkEditCondition() : this.checkCreationCondition();
        }
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 256) {
            this.m_7379_();
            return true;
        }
        if (this.textFieldTeamName == null) {
            super.m_7933_(key, a, b);
        }
        this.m_7522_((GuiEventListener)this.textFieldTeamName);
        return this.textFieldTeamName.m_7933_(key, a, b) || this.textFieldTeamName.m_94204_() || super.m_7933_(key, a, b);
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private List<FactionCreationError> getCreationErrors() {
        ArrayList<FactionCreationError> errors = new ArrayList<FactionCreationError>();
        if (this.textFieldTeamName == null || this.textFieldTeamName.m_94155_().length() < 3) {
            errors.add(FactionCreationError.NAME_TOO_SHORT);
        } else if (this.textFieldTeamName.m_94155_().length() > 32) {
            errors.add(FactionCreationError.NAME_TOO_LONG);
        } else if (RecruitsFactionManager.isNameInUse(this.textFieldTeamName.m_94155_(), ClientManager.factions)) {
            errors.add(FactionCreationError.NAME_ALREADY_IN_USE);
        }
        if (!this.player.m_7500_() && this.getPlayerCurrencyAmount() < ClientManager.factionCreationPrice) {
            errors.add(FactionCreationError.INSUFFICIENT_EMERALDS);
        }
        if (this.banner == null || this.banner.m_41619_() || RecruitsFactionManager.isBannerBlank(this.banner)) {
            errors.add(FactionCreationError.BANNER_EMPTY);
        } else if (RecruitsFactionManager.isBannerInUse(this.banner.serializeNBT(), ClientManager.factions)) {
            errors.add(FactionCreationError.BANNER_IN_USE);
        }
        if (leaderInfo == null) {
            errors.add(FactionCreationError.LEADER_MISSING);
        }
        return errors;
    }

    private List<FactionCreationError> getEditingErrors() {
        String newName;
        ArrayList<FactionCreationError> errors = new ArrayList<FactionCreationError>();
        String string = newName = this.textFieldTeamName != null ? this.textFieldTeamName.m_94155_() : "";
        if (newName.length() < 3) {
            errors.add(FactionCreationError.NAME_TOO_SHORT);
        } else if (newName.length() > 32) {
            errors.add(FactionCreationError.NAME_TOO_LONG);
        } else if (!newName.equals(ClientManager.ownFaction.getTeamDisplayName()) && RecruitsFactionManager.isDisplayNameInUse(newName, ClientManager.factions)) {
            errors.add(FactionCreationError.NAME_ALREADY_IN_USE);
        }
        if (!this.player.m_7500_() && this.getPlayerCurrencyAmount() < this.totalCost) {
            errors.add(FactionCreationError.INSUFFICIENT_EMERALDS);
        }
        if (this.banner != null && !this.banner.m_41619_()) {
            if (RecruitsFactionManager.isBannerBlank(this.banner)) {
                errors.add(FactionCreationError.BANNER_EMPTY);
            } else if (!ItemStack.m_150942_((ItemStack)this.banner, (ItemStack)ItemStack.m_41712_((CompoundTag)ClientManager.ownFaction.getBanner())) && RecruitsFactionManager.isBannerInUse(this.banner.serializeNBT(), ClientManager.factions)) {
                errors.add(FactionCreationError.BANNER_IN_USE);
            }
        }
        if (leaderInfo == null) {
            errors.add(FactionCreationError.LEADER_MISSING);
        }
        if (!this.hasChanges) {
            errors.add(FactionCreationError.NO_CHANGES);
        }
        return errors;
    }

    private Tooltip getErrorMessage() {
        List<FactionCreationError> errors;
        List<FactionCreationError> list = errors = ClientManager.ownFaction != null ? this.getEditingErrors() : this.getCreationErrors();
        if (errors.isEmpty()) {
            return Tooltip.m_257550_((Component)Component.m_237119_());
        }
        MutableComponent tooltip = Component.m_237113_((String)"");
        for (int i = 0; i < errors.size(); ++i) {
            tooltip.m_7220_((Component)Component.m_237113_((String)"- ").m_7220_(errors.get(i).getMessage()));
            if (i >= errors.size() - 1) continue;
            tooltip.m_7220_((Component)Component.m_237113_((String)"\n"));
        }
        return Tooltip.m_257550_((Component)tooltip);
    }

    static {
        teamColors = new ArrayList<ChatFormatting>(Arrays.asList(ChatFormatting.BLACK, ChatFormatting.DARK_BLUE, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_RED, ChatFormatting.DARK_PURPLE, ChatFormatting.GOLD, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLUE, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.LIGHT_PURPLE, ChatFormatting.YELLOW, ChatFormatting.WHITE));
        teamColorsNames = new ArrayList<MutableComponent>(Arrays.asList(Component.m_237115_((String)"gui.recruits.team_color.black"), Component.m_237115_((String)"gui.recruits.team_color.dark_blue"), Component.m_237115_((String)"gui.recruits.team_color.dark_green"), Component.m_237115_((String)"gui.recruits.team_color.dark_aqua"), Component.m_237115_((String)"gui.recruits.team_color.dark_red"), Component.m_237115_((String)"gui.recruits.team_color.dark_purple"), Component.m_237115_((String)"gui.recruits.team_color.gold"), Component.m_237115_((String)"gui.recruits.team_color.gray"), Component.m_237115_((String)"gui.recruits.team_color.dark_gray"), Component.m_237115_((String)"gui.recruits.team_color.blue"), Component.m_237115_((String)"gui.recruits.team_color.green"), Component.m_237115_((String)"gui.recruits.team_color.aqua"), Component.m_237115_((String)"gui.recruits.team_color.red"), Component.m_237115_((String)"gui.recruits.team_color.light_purple"), Component.m_237115_((String)"gui.recruits.team_color.yellow"), Component.m_237115_((String)"gui.recruits.team_color.white")));
        unitColors = new ArrayList<Color>(Arrays.asList(new Color(255, 255, 255), new Color(0, 0, 0), new Color(211, 211, 211), new Color(128, 128, 128), new Color(64, 64, 64), new Color(51, 123, 154), new Color(51, 92, 154), new Color(21, 37, 62), new Color(38, 156, 8), new Color(0, 128, 0), new Color(14, 57, 3), new Color(185, 21, 21), new Color(148, 16, 16), new Color(74, 8, 8), new Color(140, 76, 24), new Color(94, 59, 29), new Color(63, 39, 19), new Color(0, 150, 150), new Color(23, 68, 68), new Color(11, 34, 34), new Color(237, 202, 18), new Color(229, 106, 17), new Color(255, 0, 255), new Color(87, 2, 101), new Color(221, 154, 25)));
        unitColorsNames = new ArrayList<MutableComponent>(Arrays.asList(Component.m_237115_((String)"gui.recruits.team_color.white"), Component.m_237115_((String)"gui.recruits.team_color.black"), Component.m_237115_((String)"gui.recruits.team_color.light_gray"), Component.m_237115_((String)"gui.recruits.team_color.gray"), Component.m_237115_((String)"gui.recruits.team_color.dark_gray"), Component.m_237115_((String)"gui.recruits.team_color.light_blue"), Component.m_237115_((String)"gui.recruits.team_color.blue"), Component.m_237115_((String)"gui.recruits.team_color.dark_blue"), Component.m_237115_((String)"gui.recruits.team_color.light_green"), Component.m_237115_((String)"gui.recruits.team_color.green"), Component.m_237115_((String)"gui.recruits.team_color.dark_green"), Component.m_237115_((String)"gui.recruits.team_color.light_red"), Component.m_237115_((String)"gui.recruits.team_color.red"), Component.m_237115_((String)"gui.recruits.team_color.dark_red"), Component.m_237115_((String)"gui.recruits.team_color.light_brown"), Component.m_237115_((String)"gui.recruits.team_color.brown"), Component.m_237115_((String)"gui.recruits.team_color.dark_brown"), Component.m_237115_((String)"gui.recruits.team_color.light_cyan"), Component.m_237115_((String)"gui.recruits.team_color.cyan"), Component.m_237115_((String)"gui.recruits.team_color.dark_cyan"), Component.m_237115_((String)"gui.recruits.team_color.yellow"), Component.m_237115_((String)"gui.recruits.team_color.orange"), Component.m_237115_((String)"gui.recruits.team_color.magenta"), Component.m_237115_((String)"gui.recruits.team_color.purple"), Component.m_237115_((String)"gui.recruits.team_color.gold")));
        VALID_FACTION_NAME = Pattern.compile("[^\\p{L}\\p{N} ]+");
    }

    public static enum FactionCreationError {
        NAME_TOO_SHORT((Component)Component.m_237115_((String)"gui.recruits.error.name_too_short")),
        NAME_TOO_LONG((Component)Component.m_237115_((String)"gui.recruits.error.name_too_long")),
        NAME_ALREADY_IN_USE((Component)Component.m_237115_((String)"gui.recruits.error.name_in_use")),
        INSUFFICIENT_EMERALDS((Component)Component.m_237115_((String)"gui.recruits.error.not_enough_emeralds")),
        BANNER_EMPTY((Component)Component.m_237115_((String)"gui.recruits.error.banner_empty")),
        BANNER_IN_USE((Component)Component.m_237115_((String)"gui.recruits.error.banner_in_use")),
        NO_CHANGES((Component)Component.m_237115_((String)"gui.recruits.error.no_changes")),
        LEADER_MISSING((Component)Component.m_237115_((String)"gui.recruits.error.leader_missing"));

        private final Component message;

        private FactionCreationError(Component message) {
            this.message = message;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

