/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.diplomacy;

import com.google.common.collect.Lists;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyTeamEntry;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyTeamListScreen;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DiplomacyTeamList
extends ListScreenListBase<DiplomacyTeamEntry> {
    protected DiplomacyTeamListScreen screen;
    protected final List<DiplomacyTeamEntry> entries;
    protected String filter;
    public DiplomacyFilter diplomacyFilter;

    public DiplomacyTeamList(int width, int height, int x, int y, int size, DiplomacyTeamListScreen screen) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.diplomacyFilter = DiplomacyFilter.ALL;
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
    }

    public void tick() {
        if (ClientManager.factions != null && ClientManager.diplomacyMap != null) {
            this.updateEntryList();
        }
    }

    public void updateEntryList() {
        this.entries.clear();
        for (RecruitsFaction team : ClientManager.factions) {
            if (ClientManager.ownFaction == null || team.getStringID().equals(ClientManager.ownFaction.getStringID())) continue;
            RecruitsDiplomacyManager.DiplomacyStatus status = ClientManager.getRelation(ClientManager.ownFaction.getStringID(), team.getStringID());
            switch (this.diplomacyFilter) {
                case ALL: {
                    this.entries.add(new DiplomacyTeamEntry(this.screen, team, status));
                    break;
                }
                case ALLIES: {
                    if (status != RecruitsDiplomacyManager.DiplomacyStatus.ALLY) break;
                    this.entries.add(new DiplomacyTeamEntry(this.screen, team, status));
                    break;
                }
                case NEUTRALS: {
                    if (status != RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL) break;
                    this.entries.add(new DiplomacyTeamEntry(this.screen, team, status));
                    break;
                }
                case ENEMIES: {
                    if (status != RecruitsDiplomacyManager.DiplomacyStatus.ENEMY) break;
                    this.entries.add(new DiplomacyTeamEntry(this.screen, team, status));
                }
            }
        }
        this.updateFilter();
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<DiplomacyTeamEntry> filteredEntries = new ArrayList<DiplomacyTeamEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(teamEntry -> teamEntry.getTeamInfo() == null || !teamEntry.getTeamInfo().getTeamDisplayName().toLowerCase(Locale.ROOT).contains(this.filter));
        }
        filteredEntries.sort((e1, e2) -> {
            if (!((Object)e1).getClass().equals(((Object)e2).getClass())) {
                if (e1 instanceof DiplomacyTeamEntry) {
                    return 1;
                }
                return -1;
            }
            return this.volumeEntryToString((DiplomacyTeamEntry)((Object)e1)).compareToIgnoreCase(this.volumeEntryToString((DiplomacyTeamEntry)((Object)e2)));
        });
        this.m_5988_(filteredEntries);
    }

    private String volumeEntryToString(DiplomacyTeamEntry entry) {
        return entry.getTeamInfo() == null ? "" : entry.getTeamInfo().getStringID();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }

    public static enum DiplomacyFilter {
        ALL,
        ALLIES,
        NEUTRALS,
        ENEMIES;

    }
}

