/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.claim;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;

public class ChunkPreview {
    private final NativeImage image;
    private final DynamicTexture texture;
    private final ResourceLocation textureId;
    private final Minecraft mc = Minecraft.m_91087_();

    public ChunkPreview(ClientLevel level, ChunkPos pos) {
        this.image = this.generateVanillaStyleImage(level, pos);
        this.texture = new DynamicTexture(this.image);
        this.textureId = this.mc.m_91097_().m_118490_("chunk_map_" + pos.f_45578_ + "_" + pos.f_45579_, this.texture);
    }

    private ChunkPreview(NativeImage img, DynamicTexture tex, ResourceLocation id) {
        this.image = img;
        this.texture = tex;
        this.textureId = id;
    }

    private NativeImage generateVanillaStyleImage(ClientLevel level, ChunkPos pos) {
        NativeImage img = new NativeImage(NativeImage.Format.RGBA, 16, 16, false);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.m_45604_() + x;
                int worldZ = pos.m_45605_() + z;
                int worldY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, worldX, worldZ) - 1;
                BlockPos blockPos = new BlockPos(worldX, worldY, worldZ);
                int color = this.getVanillaReliefColor(level, blockPos);
                img.m_84988_(x, z, color);
            }
        }
        img.m_85123_();
        return img;
    }

    private int getVanillaReliefColor(ClientLevel level, BlockPos pos) {
        int heightWest;
        int heightSouth;
        boolean isWater;
        BlockState state = level.m_8055_(pos);
        MapColor mapColor = state.m_284242_((BlockGetter)level, pos);
        if (mapColor == null) {
            return -16777216;
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int y = pos.m_123342_();
        boolean bl = isWater = state.m_60734_() == Blocks.f_49990_;
        if (isWater) {
            int waterDepth = 0;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
            while (level.m_8055_((BlockPos)mutable).m_60734_() == Blocks.f_49990_ && mutable.m_123342_() > level.m_141937_()) {
                ++waterDepth;
                mutable.m_122173_(Direction.DOWN);
            }
            MapColor.Brightness brightness = waterDepth > 6 ? MapColor.Brightness.LOWEST : (waterDepth > 3 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL);
            return 0xFF000000 | mapColor.m_284280_(brightness);
        }
        int heightHere = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        int relHeight = heightHere - Math.max(heightSouth = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z + 1), heightWest = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x - 1, z));
        MapColor.Brightness brightness = relHeight > 2 ? MapColor.Brightness.HIGH : (relHeight > 0 ? MapColor.Brightness.NORMAL : (relHeight > -2 ? MapColor.Brightness.LOW : MapColor.Brightness.LOWEST));
        return 0xFF000000 | mapColor.m_284280_(brightness);
    }

    public void draw(GuiGraphics guiGraphics, int x, int y, int width, int height, boolean hovered) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        int drawWidth = width + 1;
        int drawHeight = height + 1;
        float uvFix = 0.001f;
        guiGraphics.m_280411_(this.textureId, x, y, drawWidth, drawHeight, uvFix, uvFix, (int)(16.0f - 2.0f * uvFix), (int)(16.0f - 2.0f * uvFix), 16, 16);
        if (hovered) {
            guiGraphics.m_280509_(x, y, x + width, y + height, 0x40FFFFFF);
        }
    }

    public NativeImage getNativeImage() {
        return this.image;
    }

    public void close() {
        try {
            if (this.image != null) {
                this.image.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.texture != null) {
                this.texture.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.textureId != null) {
            this.mc.m_91097_().m_118513_(this.textureId);
        }
    }

    public static ChunkPreview fromNativeImage(ClientLevel level, ChunkPos pos, NativeImage img) {
        Minecraft mc = Minecraft.m_91087_();
        DynamicTexture tex = new DynamicTexture(img);
        ResourceLocation id = mc.m_91097_().m_118490_("chunk_map_" + pos.f_45578_ + "_" + pos.f_45579_, tex);
        ChunkPreview cm = new ChunkPreview(img, tex, id);
        return cm;
    }

    public boolean imageIsMeaningful(double minNonBlackRatio) {
        if (this.image == null) {
            return false;
        }
        int w = this.image.m_84982_();
        int h = this.image.m_85084_();
        int total = w * h;
        int nonBlack = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int px = this.image.m_84985_(x, y);
                if ((px & 0xFFFFFF) != 0) {
                    ++nonBlack;
                    continue;
                }
                int alpha = px >>> 24 & 0xFF;
                if (alpha == 0 || (px & 0xFFFFFF) == 0) continue;
                ++nonBlack;
            }
        }
        double ratio = (double)nonBlack / (double)total;
        return ratio >= minNonBlackRatio;
    }
}

