/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.claim;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.claim.ChunkMapPersistence;
import com.talhanation.recruits.client.gui.claim.ChunkPreview;
import com.talhanation.recruits.client.gui.claim.ClaimMapScreen;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.faction.TeamEditScreen;
import com.talhanation.recruits.client.gui.widgets.ContextMenuEntry;
import com.talhanation.recruits.network.MessageDoPayment;
import com.talhanation.recruits.network.MessageUpdateClaim;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import org.joml.Matrix4f;

public class ChunkMapWidget
extends AbstractWidget {
    private static final ResourceLocation MAP_ICONS = new ResourceLocation("textures/map/map_icons.png");
    private static final Component EDIT_CLAIM = Component.m_237115_((String)"gui.recruits.claim.editClaim");
    private static final Component REMOVE_CHUNK = Component.m_237115_((String)"gui.recruits.claim.removeChunk");
    private static final Component FACTION_TEXT = Component.m_237115_((String)"gui.recruits.claim.faction");
    private static final Component DIPLOMACY_TEXT = Component.m_237115_((String)"gui.recruits.claim.diplomacy");
    private static final Component TRUE_TEXT = Component.m_237115_((String)"gui.recruits.claim.true");
    private static final Component FALSE_TEXT = Component.m_237115_((String)"gui.recruits.claim.false");
    private static final Component PLAYER_TEXT = Component.m_237115_((String)"gui.recruits.claim.player");
    private static final Component BLOCK_PLACING_TEXT = Component.m_237115_((String)"gui.recruits.claim.block_placing");
    private static final Component BLOCK_BREAKING_TEXT = Component.m_237115_((String)"gui.recruits.claim.block_breaking");
    private static final Component BLOCK_INTERACTION_TEXT = Component.m_237115_((String)"gui.recruits.claim.block_interaction");
    private final ClaimMapScreen screen;
    private int viewRadius;
    private final int cellSize;
    private ChunkPos center;
    @Nullable
    private ChunkPos selectedChunk = null;
    @Nullable
    private ChunkPos hoverChunk;
    private double offsetX;
    private double offsetZ;
    private boolean dragging = false;
    private final BannerRenderer bannerRenderer;
    private RecruitsClaim selectedClaim;
    private final List<ContextMenuEntry> contextMenuEntries = new ArrayList<ContextMenuEntry>();
    private int contextMenuX;
    private int contextMenuY;
    private boolean contextMenuVisible = false;
    public Player player;
    private ChunkPos lastPlayerChunk;
    private static double zoomLevel = 1.0;
    private double lastBaseX = 0.0;
    private double lastBaseY = 0.0;
    private double lastScaledCellSize = 16.0;
    public static final Map<ChunkPos, ChunkPreview> chunkImageCache = new HashMap<ChunkPos, ChunkPreview>();

    public ChunkMapWidget(ClaimMapScreen screen, Player player, int x, int y) {
        super(x, y, screen.f_96543_, screen.f_96544_, (Component)Component.m_237119_());
        this.screen = screen;
        this.cellSize = 16;
        this.bannerRenderer = new BannerRenderer(null);
        this.bannerRenderer.setRecruitsTeam(ClientManager.ownFaction);
        this.player = player;
        this.recalcViewRadius();
        this.center = player.m_146902_();
        this.centerOnPlayer();
    }

    private void recalcViewRadius() {
        int chunksX = (int)Math.ceil((double)this.f_93618_ / (double)this.cellSize);
        int chunksY = (int)Math.ceil((double)this.f_93619_ / (double)this.cellSize);
        this.viewRadius = Math.max(chunksX, chunksY) + 5;
    }

    public void tick() {
        ChunkPos currentChunk = this.player.m_146902_();
        if (this.lastPlayerChunk == null || !this.lastPlayerChunk.equals((Object)currentChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.center = currentChunk;
            this.centerOnPlayer();
        }
        if (this.player.f_19797_ % 20 != 0) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || this.center == null) {
            return;
        }
        ResourceLocation dim = level.m_46472_().m_135782_();
        int priorityRadius = 10;
        ArrayList<ChunkPos> priorityList = new ArrayList<ChunkPos>();
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dz = -10; dz <= 10; ++dz) {
                priorityList.add(new ChunkPos(this.center.f_45578_ + dx, this.center.f_45579_ + dz));
            }
        }
        priorityList.sort(Comparator.comparingInt(p -> {
            int ddx = p.f_45578_ - this.center.f_45578_;
            int ddz = p.f_45579_ - this.center.f_45579_;
            return ddx * ddx + ddz * ddz;
        }));
        double minMeaningfulRatio = 0.05;
        for (ChunkPos pos : priorityList) {
            try {
                ChunkPreview old = chunkImageCache.get(pos);
                if (old != null) {
                    try {
                        old.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ChunkPreview generated = new ChunkPreview(level, pos);
                NativeImage generatedImg = generated.getNativeImage();
                boolean meaningful = generated.imageIsMeaningful(0.05);
                boolean hasSaved = ChunkMapPersistence.chunkExists(dim, pos);
                if (meaningful) {
                    try {
                        ChunkMapPersistence.saveChunk(dim, pos, generatedImg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    chunkImageCache.put(pos, generated);
                    continue;
                }
                if (hasSaved) {
                    Optional<NativeImage> maybe = ChunkMapPersistence.loadChunkSync(dim, pos);
                    if (maybe.isPresent()) {
                        ChunkPreview fromDisk = ChunkPreview.fromNativeImage(level, pos, maybe.get());
                        try {
                            generated.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        chunkImageCache.put(pos, fromDisk);
                        continue;
                    }
                    chunkImageCache.put(pos, generated);
                    continue;
                }
                chunkImageCache.put(pos, generated);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Optional<NativeImage> maybe;
                    if (!ChunkMapPersistence.chunkExists(dim, pos) || !(maybe = ChunkMapPersistence.loadChunkSync(dim, pos)).isPresent()) continue;
                    ChunkPreview fromDisk = ChunkPreview.fromNativeImage(level, pos, maybe.get());
                    chunkImageCache.put(pos, fromDisk);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        int renderMargin = 1;
        for (int dx = -this.viewRadius - renderMargin; dx <= this.viewRadius + renderMargin; ++dx) {
            for (int dz = -this.viewRadius - renderMargin; dz <= this.viewRadius + renderMargin; ++dz) {
                ChunkPos pos = new ChunkPos(this.center.f_45578_ + dx, this.center.f_45579_ + dz);
                if (chunkImageCache.containsKey(pos)) continue;
                try {
                    Optional<NativeImage> maybe = ChunkMapPersistence.loadChunkSync(dim, pos);
                    if (maybe.isPresent()) {
                        ChunkPreview cm = ChunkPreview.fromNativeImage(level, pos, maybe.get());
                        chunkImageCache.put(pos, cm);
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ChunkPreview cm = new ChunkPreview(level, pos);
                    chunkImageCache.put(pos, cm);
                    NativeImage img = cm.getNativeImage();
                    if (img == null) continue;
                    ChunkMapPersistence.saveChunk(dim, pos, img);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void centerOnPlayer() {
        if (this.player == null || this.center == null) {
            return;
        }
        double scaledCellSize = (double)this.cellSize * zoomLevel;
        ChunkPos playerChunk = this.player.m_146902_();
        double localInChunkXBlocks = this.player.m_20185_() - (double)playerChunk.m_45604_();
        double localInChunkZBlocks = this.player.m_20189_() - (double)playerChunk.m_45605_();
        double pixelsPerBlock = scaledCellSize / 16.0;
        double localInChunkX = localInChunkXBlocks * pixelsPerBlock;
        double localInChunkZ = localInChunkZBlocks * pixelsPerBlock;
        double widgetCenterX = (double)this.m_5711_() / 2.0;
        double widgetCenterY = (double)this.m_93694_() / 2.0;
        this.offsetX = widgetCenterX - (double)this.viewRadius * scaledCellSize - localInChunkX;
        this.offsetZ = widgetCenterY - (double)this.viewRadius * scaledCellSize - localInChunkZ;
        this.center = playerChunk;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || this.center == null) {
            return;
        }
        double scaledCellSize = (double)this.cellSize * zoomLevel;
        double baseX = (double)this.m_252754_() + this.offsetX + (double)this.viewRadius * scaledCellSize;
        double baseY = (double)this.m_252907_() + this.offsetZ + (double)this.viewRadius * scaledCellSize;
        this.lastBaseX = baseX;
        this.lastBaseY = baseY;
        this.lastScaledCellSize = scaledCellSize;
        this.renderBackground(guiGraphics);
        this.renderChunksAndClaims(guiGraphics, level, baseX, baseY, mouseX, mouseY, scaledCellSize);
        this.renderSelectedChunkBorder(guiGraphics);
        this.renderContextMenu(guiGraphics, mc, mouseX, mouseY);
        this.renderSelectedClaimPanel(guiGraphics, mc);
        this.renderPlayerIconAt(guiGraphics, baseX, baseY, scaledCellSize);
    }

    private void renderBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.m_5711_() + 1, this.m_252907_() + this.m_93694_() + 1, -11184811);
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), -14540254);
    }

    private void renderChunksAndClaims(GuiGraphics guiGraphics, ClientLevel level, double baseX, double baseY, int mouseX, int mouseY, double cellSize) {
        int py;
        int px;
        ChunkPos pos;
        int chunkZ;
        int chunkX;
        int dz;
        int dx;
        int renderMargin = 1;
        this.hoverChunk = null;
        int intCellSize = Math.max(1, (int)Math.round(cellSize));
        for (dx = -this.viewRadius - renderMargin; dx <= this.viewRadius + renderMargin; ++dx) {
            for (dz = -this.viewRadius - renderMargin; dz <= this.viewRadius + renderMargin; ++dz) {
                ChunkPreview preview;
                boolean hovered;
                chunkX = this.center.f_45578_ + dx;
                chunkZ = this.center.f_45579_ + dz;
                pos = new ChunkPos(chunkX, chunkZ);
                px = (int)Math.round(baseX + (double)dx * cellSize);
                py = (int)Math.round(baseY + (double)dz * cellSize);
                boolean bl = hovered = mouseX >= px && mouseX < px + intCellSize && mouseY >= py && mouseY < py + intCellSize;
                if (hovered) {
                    this.hoverChunk = pos;
                }
                if ((preview = chunkImageCache.get(pos)) != null) {
                    RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
                    RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
                    preview.draw(guiGraphics, px, py, intCellSize, intCellSize, hovered);
                } else {
                    guiGraphics.m_280509_(px, py, px + intCellSize, py + intCellSize, -16777216);
                }
                this.renderClaimOverlay(guiGraphics, pos, px, py, cellSize);
            }
        }
        for (dx = -this.viewRadius - renderMargin; dx <= this.viewRadius + renderMargin; ++dx) {
            for (dz = -this.viewRadius - renderMargin; dz <= this.viewRadius + renderMargin; ++dz) {
                chunkX = this.center.f_45578_ + dx;
                chunkZ = this.center.f_45579_ + dz;
                pos = new ChunkPos(chunkX, chunkZ);
                px = (int)Math.round(baseX + (double)dx * cellSize);
                py = (int)Math.round(baseY + (double)dz * cellSize);
                this.renderClaimNames(guiGraphics, pos, px, py, cellSize);
            }
        }
    }

    private void renderPlayerIconAt(GuiGraphics guiGraphics, double baseX, double baseY, double cellSize) {
        ChunkPos pChunk = this.player.m_146902_();
        double localBlocksX = this.player.m_20185_() - (double)pChunk.m_45604_();
        double localBlocksZ = this.player.m_20189_() - (double)pChunk.m_45605_();
        double pixelsPerBlock = cellSize / 16.0;
        double localPixelX = localBlocksX * pixelsPerBlock;
        double localPixelZ = localBlocksZ * pixelsPerBlock;
        int chunkDx = pChunk.f_45578_ - this.center.f_45578_;
        int chunkDz = pChunk.f_45579_ - this.center.f_45579_;
        int playerScreenX = (int)Math.round(baseX + (double)chunkDx * cellSize + localPixelX);
        int playerScreenY = (int)Math.round(baseY + (double)chunkDz * cellSize + localPixelZ);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)playerScreenX, (float)playerScreenY, 0.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_(this.player.m_146908_()));
        pose.m_85841_(5.0f, 5.0f, 1.0f);
        int iconIndex = 0;
        float u0 = (float)(iconIndex % 16) / 16.0f;
        float v0 = (float)(iconIndex / 16) / 16.0f;
        float u1 = u0 + 0.0625f;
        float v1 = v0 + 0.0625f;
        VertexConsumer consumer = guiGraphics.m_280091_().m_6299_(RenderType.m_110497_((ResourceLocation)MAP_ICONS));
        Matrix4f matrix = pose.m_85850_().m_252922_();
        int light = 0xF000F0;
        int color = -1;
        consumer.m_252986_(matrix, -1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, -1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        pose.m_85849_();
    }

    private void renderClaimOverlay(GuiGraphics guiGraphics, ChunkPos pos, int px, int py, double cellSize) {
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (!claim.containsChunk(pos)) continue;
            int alpha = 190;
            int rgb = TeamEditScreen.unitColors.get(claim.getOwnerFaction().getUnitColor()).getRGB();
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int argb = alpha << 24 | r << 16 | g << 8 | b;
            double overlap = 0.5;
            double x1 = px;
            double y1 = py;
            double x2 = (double)px + cellSize + overlap;
            double y2 = (double)py + cellSize + overlap;
            guiGraphics.m_280509_((int)Math.floor(x1), (int)Math.floor(y1), (int)Math.ceil(x2), (int)Math.ceil(y2), argb);
            if (this.selectedClaim == null || !this.selectedClaim.containsChunk(pos)) break;
            this.renderSelectedClaimBorder(guiGraphics, pos, px, py, cellSize);
            break;
        }
    }

    private void renderClaimNames(GuiGraphics guiGraphics, ChunkPos pos, int px, int py, double cellSize) {
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (!claim.containsChunk(pos) || !claim.getCenter().equals((Object)pos)) continue;
            this.renderClaimName(guiGraphics, claim, px, py, cellSize);
        }
    }

    private void renderClaimName(GuiGraphics guiGraphics, RecruitsClaim claim, int px, int py, double cellSize) {
        Font font = Minecraft.m_91087_().f_91062_;
        String name = claim.getName();
        int textWidth = font.m_92895_(name);
        int textX = (int)((double)px + cellSize / 2.0 - (double)(textWidth / 2));
        int textY = (int)((double)py + cellSize / 2.0 - 4.0);
        guiGraphics.m_280056_(font, name, textX, textY, 0xFFFFFF, true);
    }

    private void renderSelectedClaimBorder(GuiGraphics guiGraphics, ChunkPos pos, int px, int py, double cellSize) {
        ChunkPos[] directions = new ChunkPos[]{new ChunkPos(pos.f_45578_, pos.f_45579_ - 1), new ChunkPos(pos.f_45578_, pos.f_45579_ + 1), new ChunkPos(pos.f_45578_ - 1, pos.f_45579_), new ChunkPos(pos.f_45578_ + 1, pos.f_45579_)};
        boolean top = !this.selectedClaim.containsChunk(directions[0]);
        boolean bottom = !this.selectedClaim.containsChunk(directions[1]);
        boolean left = !this.selectedClaim.containsChunk(directions[2]);
        boolean right = !this.selectedClaim.containsChunk(directions[3]);
        int borderColor = -1;
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        if (top) {
            guiGraphics.m_280509_(px, py, (int)((double)px + cellSize), py + 1, borderColor);
        }
        if (bottom) {
            guiGraphics.m_280509_(px, (int)((double)py + cellSize - 1.0), (int)((double)px + cellSize), (int)((double)py + cellSize), borderColor);
        }
        if (left) {
            guiGraphics.m_280509_(px, py, px + 1, (int)((double)py + cellSize), borderColor);
        }
        if (right) {
            guiGraphics.m_280509_((int)((double)px + cellSize - 1.0), py, (int)((double)px + cellSize), (int)((double)py + cellSize), borderColor);
        }
    }

    private void renderSelectedChunkBorder(GuiGraphics guiGraphics) {
        if (this.selectedChunk == null || this.center == null) {
            return;
        }
        int dx = this.selectedChunk.f_45578_ - this.center.f_45578_;
        int dz = this.selectedChunk.f_45579_ - this.center.f_45579_;
        int px = (int)Math.round(this.lastBaseX + (double)dx * this.lastScaledCellSize);
        int py = (int)Math.round(this.lastBaseY + (double)dz * this.lastScaledCellSize);
        int glowColor = -1;
        int cs = (int)Math.round(this.lastScaledCellSize);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        guiGraphics.m_280509_(px, py, px + cs, py + 1, glowColor);
        guiGraphics.m_280509_(px, py + cs - 1, px + cs, py + cs, glowColor);
        guiGraphics.m_280509_(px, py, px + 1, py + cs, glowColor);
        guiGraphics.m_280509_(px + cs - 1, py, px + cs, py + cs, glowColor);
    }

    private void renderContextMenu(GuiGraphics guiGraphics, Minecraft mc, int mouseX, int mouseY) {
        if (!this.contextMenuVisible || this.contextMenuEntries.isEmpty()) {
            return;
        }
        int entryHeight = 14;
        int width = 100;
        int height = this.contextMenuEntries.size() * entryHeight;
        guiGraphics.m_280509_(this.contextMenuX, this.contextMenuY, this.contextMenuX + width, this.contextMenuY + height, -16777216);
        for (int i = 0; i < this.contextMenuEntries.size(); ++i) {
            ContextMenuEntry entry = this.contextMenuEntries.get(i);
            int entryY = this.contextMenuY + i * entryHeight;
            boolean hoveringEntry = mouseX >= this.contextMenuX && mouseX < this.contextMenuX + width && mouseY >= entryY && mouseY < entryY + entryHeight;
            int baseColor = entry.enabled ? -1 : -8947849;
            int hoverColor = entry.enabled ? -5592406 : -11184811;
            int color = hoveringEntry ? hoverColor : baseColor;
            guiGraphics.m_280488_(mc.f_91062_, entry.label, this.contextMenuX + 5, entryY + 2, color);
        }
    }

    private void renderSelectedClaimPanel(GuiGraphics guiGraphics, Minecraft mc) {
        if (this.selectedClaim == null) {
            return;
        }
        Font font = mc.f_91062_;
        int panelWidth = 135;
        int panelHeight = 225;
        int panelX = this.f_93618_ - panelWidth - 2;
        int panelY = this.f_93619_ - panelHeight - 2;
        guiGraphics.m_280509_(panelX - 1, panelY - 1, panelX + panelWidth + 1, panelY + panelHeight + 1, -11184811);
        guiGraphics.m_280509_(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -14540254);
        guiGraphics.m_280488_(font, this.selectedClaim.getName(), panelX + 5, panelY + 5, 0xFFFFFF);
        this.bannerRenderer.renderBanner(guiGraphics, panelX + 60, panelY + 80, this.f_93618_, this.f_93619_, 60);
        guiGraphics.m_280488_(font, FACTION_TEXT.getString() + ": ", panelX + 5, panelY + 130, 0xFFFFFF);
        guiGraphics.m_280488_(font, this.selectedClaim.getOwnerFaction().getTeamDisplayName(), panelX + 90, panelY + 130, 0xFFFFFF);
        guiGraphics.m_280488_(font, PLAYER_TEXT.getString() + ": ", panelX + 5, panelY + 150, 0xFFFFFF);
        guiGraphics.m_280488_(font, this.selectedClaim.getPlayerInfo() != null ? this.selectedClaim.getPlayerInfo().getName() : this.selectedClaim.getOwnerFaction().getTeamLeaderName(), panelX + 90, panelY + 150, 0xFFFFFF);
        guiGraphics.m_280488_(font, BLOCK_PLACING_TEXT.getString() + ": ", panelX + 5, panelY + 170, 0xFFFFFF);
        guiGraphics.m_280488_(font, this.selectedClaim.isBlockPlacementAllowed() ? TRUE_TEXT.getString() : FALSE_TEXT.getString(), panelX + 90, panelY + 170, 0xFFFFFF);
        guiGraphics.m_280488_(font, BLOCK_BREAKING_TEXT.getString() + ": ", panelX + 5, panelY + 190, 0xFFFFFF);
        guiGraphics.m_280488_(font, this.selectedClaim.isBlockBreakingAllowed() ? TRUE_TEXT.getString() : FALSE_TEXT.getString(), panelX + 90, panelY + 190, 0xFFFFFF);
        guiGraphics.m_280488_(font, BLOCK_INTERACTION_TEXT.getString() + ": ", panelX + 5, panelY + 210, 0xFFFFFF);
        guiGraphics.m_280488_(font, this.selectedClaim.isBlockInteractionAllowed() ? TRUE_TEXT.getString() : FALSE_TEXT.getString(), panelX + 90, panelY + 210, 0xFFFFFF);
    }

    private void openContextMenu(ChunkPos chunk) {
        this.contextMenuEntries.clear();
        if (ClientManager.ownFaction == null) {
            return;
        }
        int dx = chunk.f_45578_ - this.center.f_45578_;
        int dz = chunk.f_45579_ - this.center.f_45579_;
        int px = (int)Math.round(this.lastBaseX + (double)dx * this.lastScaledCellSize);
        int py = (int)Math.round(this.lastBaseY + (double)dz * this.lastScaledCellSize);
        this.contextMenuX = px + (int)Math.round(this.lastScaledCellSize) + 5;
        this.contextMenuY = py;
        this.contextMenuEntries.add(new ContextMenuEntry(ClaimMapScreen.CLAIM_CHUNK.getString(), () -> this.claimChunk(chunk, ClientManager.ownFaction, ClientManager.recruitsClaims), this.screen.canPlayerClaim(ClientManager.configValueChunkCost, this.player) && this.canClaimChunk(chunk, ClientManager.ownFaction, ClientManager.recruitsClaims, true)));
        this.contextMenuEntries.add(new ContextMenuEntry(ClaimMapScreen.CLAIM_AREA.getString(), () -> this.claimArea(chunk, ClientManager.ownFaction, ClientManager.recruitsClaims), this.screen.canPlayerClaim(this.screen.getClaimCost(ClientManager.ownFaction), this.player) && this.canClaimChunks(this.getClaimArea(chunk), ClientManager.ownFaction, ClientManager.recruitsClaims)));
        this.contextMenuVisible = true;
    }

    private void openClaimContextMenu(RecruitsClaim claim, ChunkPos savedHoverChunk) {
        this.contextMenuEntries.clear();
        if (ClientManager.ownFaction == null) {
            return;
        }
        ChunkPos rightTop = claim.getClaimedChunks().stream().max(Comparator.comparingInt(pos -> pos.f_45578_).thenComparingInt(pos -> pos.f_45579_)).orElse(claim.getCenter());
        int dx = rightTop.f_45578_ - this.center.f_45578_;
        int dz = rightTop.f_45579_ - this.center.f_45579_;
        int px = (int)Math.round(this.lastBaseX + (double)dx * this.lastScaledCellSize);
        int py = (int)Math.round(this.lastBaseY + (double)dz * this.lastScaledCellSize);
        this.contextMenuX = px + (int)Math.round(this.lastScaledCellSize) + 5;
        this.contextMenuY = py;
        if (!claim.getOwnerFaction().getStringID().equals(ClientManager.ownFaction.getStringID())) {
            this.contextMenuEntries.add(new ContextMenuEntry(DIPLOMACY_TEXT.getString(), () -> this.screen.openDiplomacyOf(claim.getOwnerFaction()), true));
        } else if (this.player.m_20148_().equals(ClientManager.ownFaction.getTeamLeaderUUID()) || this.player.m_20148_().equals(claim.getPlayerInfo().getUUID())) {
            this.contextMenuEntries.add(new ContextMenuEntry(EDIT_CLAIM.getString(), () -> this.screen.openClaimEditScreen(claim), true));
            this.contextMenuEntries.add(new ContextMenuEntry(REMOVE_CHUNK.getString(), () -> {
                claim.removeChunk(savedHoverChunk);
                this.recalculateCenter(claim);
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(claim));
            }, this.canRemoveChunk(savedHoverChunk, claim)));
        }
        this.contextMenuVisible = true;
    }

    private List<ChunkPos> getClaimArea(ChunkPos center) {
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        int range = 2;
        for (int i = -range; i < range; ++i) {
            for (int k = -range; k < range; ++k) {
                ChunkPos newPos = new ChunkPos(center.f_45578_ + i, center.f_45579_ + k);
                list.add(newPos);
            }
        }
        return list;
    }

    protected void m_168797_(NarrationElementOutput p_169152_) {
    }

    public void zoom(double delta, double mouseX, double mouseY) {
        double oldZoom = zoomLevel;
        double newZoom = Mth.m_14008_((double)(zoomLevel + delta * 0.1), (double)0.5, (double)4.0);
        if (newZoom == oldZoom) {
            return;
        }
        double oldScaled = (double)this.cellSize * oldZoom;
        double newScaled = (double)this.cellSize * newZoom;
        double baseXOld = (double)this.m_252754_() + this.offsetX + (double)this.viewRadius * oldScaled;
        double baseYOld = (double)this.m_252907_() + this.offsetZ + (double)this.viewRadius * oldScaled;
        double worldPosX = (mouseX - baseXOld) / oldScaled;
        double worldPosY = (mouseY - baseYOld) / oldScaled;
        double offsetXNew = mouseX - (double)this.m_252754_() - ((double)this.viewRadius + worldPosX) * newScaled;
        double offsetZNew = mouseY - (double)this.m_252907_() - ((double)this.viewRadius + worldPosY) * newScaled;
        zoomLevel = newZoom;
        this.offsetX = offsetXNew;
        this.offsetZ = offsetZNew;
        this.recalcViewRadius();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.zoom(delta, mouseX, mouseY);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (button == 1 && this.hoverChunk != null) {
                for (RecruitsClaim claim : ClientManager.recruitsClaims) {
                    if (!claim.containsChunk(this.hoverChunk)) continue;
                    this.selectedClaim = claim;
                    this.bannerRenderer.setRecruitsTeam(this.selectedClaim.getOwnerFaction());
                    this.openClaimContextMenu(this.selectedClaim, this.hoverChunk);
                    return true;
                }
                this.selectedChunk = this.hoverChunk;
                this.selectedClaim = null;
                this.openContextMenu(this.hoverChunk);
                return true;
            }
            if (button == 0) {
                this.dragging = true;
                if (this.contextMenuVisible) {
                    int entryHeight = 14;
                    int width = 100;
                    int height = this.contextMenuEntries.size() * entryHeight;
                    if (mouseX >= (double)this.contextMenuX && mouseX < (double)(this.contextMenuX + width) && mouseY >= (double)this.contextMenuY && mouseY < (double)(this.contextMenuY + height)) {
                        int index = (int)((mouseY - (double)this.contextMenuY) / (double)entryHeight);
                        if (index >= 0 && index < this.contextMenuEntries.size()) {
                            ContextMenuEntry entry = this.contextMenuEntries.get(index);
                            if (entry.enabled) {
                                entry.action.run();
                            }
                        }
                        this.contextMenuVisible = false;
                        return true;
                    }
                    this.contextMenuVisible = false;
                    return true;
                }
                for (RecruitsClaim claim : ClientManager.recruitsClaims) {
                    if (!claim.containsChunk(this.hoverChunk)) continue;
                    this.selectedClaim = claim;
                    this.bannerRenderer.setRecruitsTeam(this.selectedClaim.getOwnerFaction());
                    this.selectedChunk = null;
                    return true;
                }
                this.selectedChunk = this.hoverChunk;
                this.selectedClaim = null;
            }
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.dragging && button == 0) {
            double dragFactor = 0.75;
            this.offsetX += dx * dragFactor;
            this.offsetZ += dy * dragFactor;
            return true;
        }
        return false;
    }

    public boolean canClaimChunk(ChunkPos chunk, RecruitsFaction team, List<RecruitsClaim> allClaims, boolean neighborSameFactionRequired) {
        for (RecruitsClaim claim : allClaims) {
            for (ChunkPos chunkPos : claim.getClaimedChunks()) {
                if (chunkPos.equals((Object)chunk)) {
                    return false;
                }
                int dx = Math.abs(chunkPos.f_45578_ - chunk.f_45578_);
                int dz = Math.abs(chunkPos.f_45579_ - chunk.f_45579_);
                if (dx > 5 || dz > 5 || claim.getOwnerFaction().getStringID().equals(team.getStringID())) continue;
                return false;
            }
        }
        if (neighborSameFactionRequired) {
            RecruitsClaim neighborClaim = this.getNeighborClaim(chunk, allClaims);
            return neighborClaim != null && neighborClaim.getOwnerFaction().getStringID().equals(team.getStringID());
        }
        return true;
    }

    @Nullable
    public RecruitsClaim getNeighborClaim(ChunkPos chunk, List<RecruitsClaim> allClaims) {
        ChunkPos[] neighbors;
        for (ChunkPos neighbor : neighbors = new ChunkPos[]{new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_ - 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1), new ChunkPos(chunk.f_45578_, chunk.f_45579_ - 1)}) {
            for (RecruitsClaim claim : allClaims) {
                if (!claim.containsChunk(neighbor)) continue;
                return claim;
            }
        }
        return null;
    }

    public boolean canClaimChunks(List<ChunkPos> chunksToClaim, RecruitsFaction team, List<RecruitsClaim> allClaims) {
        for (ChunkPos pos : chunksToClaim) {
            if (this.canClaimChunk(pos, team, allClaims, false)) continue;
            return false;
        }
        return true;
    }

    public void claimChunk(ChunkPos centerChunk, RecruitsFaction ownTeam, List<RecruitsClaim> allClaims) {
        String neighborID;
        RecruitsClaim neighborClaim = this.getNeighborClaim(centerChunk, allClaims);
        if (neighborClaim == null) {
            return;
        }
        String ownerID = ownTeam.getStringID();
        if (!Objects.equals(ownerID, neighborID = neighborClaim.getOwnerFaction().getStringID())) {
            return;
        }
        for (RecruitsClaim claim : allClaims) {
            if (!claim.equals(neighborClaim)) continue;
            neighborClaim.addChunk(centerChunk);
            this.recalculateCenter(neighborClaim);
            break;
        }
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(neighborClaim));
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDoPayment(this.player.m_20148_(), ClientManager.configValueChunkCost));
    }

    public void claimArea(ChunkPos centerChunk, RecruitsFaction team, List<RecruitsClaim> allClaims) {
        ArrayList<ChunkPos> area = new ArrayList<ChunkPos>();
        int range = 2;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                area.add(new ChunkPos(centerChunk.f_45578_ + dx, centerChunk.f_45579_ + dz));
            }
        }
        if (!this.canClaimChunks(area, team, allClaims)) {
            return;
        }
        RecruitsClaim newClaim = new RecruitsClaim(team.getTeamDisplayName(), team);
        for (ChunkPos pos : area) {
            newClaim.addChunk(pos);
        }
        newClaim.setCenter(centerChunk);
        newClaim.setPlayer(new RecruitsPlayerInfo(this.player.m_20148_(), this.player.m_7755_().getString(), ClientManager.ownFaction));
        ClientManager.recruitsClaims.add(newClaim);
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(newClaim));
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDoPayment(this.player.m_20148_(), this.screen.getClaimCost(ClientManager.ownFaction)));
    }

    public void recalculateCenter(RecruitsClaim claim) {
        List<ChunkPos> claimedChunks = claim.getClaimedChunks();
        if (claimedChunks.isEmpty()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ChunkPos pos : claimedChunks) {
            if (pos.f_45578_ < minX) {
                minX = pos.f_45578_;
            }
            if (pos.f_45578_ > maxX) {
                maxX = pos.f_45578_;
            }
            if (pos.f_45579_ < minZ) {
                minZ = pos.f_45579_;
            }
            if (pos.f_45579_ <= maxZ) continue;
            maxZ = pos.f_45579_;
        }
        int centerX = (minX + maxX) / 2;
        int centerZ = (minZ + maxZ) / 2;
        claim.setCenter(new ChunkPos(centerX, centerZ));
    }

    public boolean canRemoveChunk(ChunkPos chunk, RecruitsClaim claim) {
        ChunkPos[] neighbors;
        List<ChunkPos> claimedChunks = claim.getClaimedChunks();
        if (!claimedChunks.contains(chunk)) {
            return false;
        }
        int unclaimedNeighborCount = 0;
        for (ChunkPos neighbor : neighbors = new ChunkPos[]{new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_ - 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1), new ChunkPos(chunk.f_45578_, chunk.f_45579_ - 1)}) {
            if (claimedChunks.contains(neighbor)) continue;
            ++unclaimedNeighborCount;
        }
        return unclaimedNeighborCount >= 2;
    }
}

