/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.claim;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.fml.loading.FMLPaths;

public class ChunkMapPersistence {
    private static final int REGION_SIZE = 32;
    private static final int MAX_CACHED_REGIONS = 64;
    private static final long FLUSH_DEBOUNCE_MS = 800L;
    private static final ScheduledExecutorService WRITER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "recruits-chunkmap-writer");
        t.setDaemon(true);
        return t;
    });
    private static final ConcurrentLinkedQueue<RegionKey> flushQueue = new ConcurrentLinkedQueue();
    private static final LinkedHashMap<RegionKey, RegionEntry> regionCache = new LinkedHashMap<RegionKey, RegionEntry>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<RegionKey, RegionEntry> eldest) {
            if (this.size() > 64) {
                RegionEntry entry = eldest.getValue();
                if (entry != null && entry.isDirty()) {
                    ChunkMapPersistence.enqueueFlush(eldest.getKey());
                }
                return true;
            }
            return false;
        }
    };
    private static final Object CACHE_LOCK = new Object();

    private static Path baseDir() {
        return FMLPaths.GAMEDIR.get().resolve("recruits").resolve("chunkmaps");
    }

    private static String detectStorageId() {
        try {
            ServerData sd;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91092_() != null) {
                try {
                    String levelName = mc.m_91092_().m_129910_().m_5462_();
                    if (levelName != null && !levelName.isEmpty()) {
                        return ChunkMapPersistence.sanitize(levelName);
                    }
                }
                catch (Exception levelName) {
                    // empty catch block
                }
            }
            if ((sd = mc.m_91089_()) != null && sd.f_105363_ != null && !sd.f_105363_.isEmpty()) {
                return ChunkMapPersistence.sanitize(sd.f_105363_);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown";
    }

    private static String sanitize(String s) {
        return s.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
    }

    private static Path dimDir(ResourceLocation dimension) {
        String storageId = ChunkMapPersistence.detectStorageId();
        return ChunkMapPersistence.baseDir().resolve(storageId).resolve(dimension.m_135827_() + "_" + dimension.m_135815_());
    }

    public static void ensureDirs(ResourceLocation dimension) throws IOException {
        Path path = ChunkMapPersistence.dimDir(dimension);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private static File regionFile(ResourceLocation dimension, int regionX, int regionZ) {
        Path p = ChunkMapPersistence.dimDir(dimension).resolve("region_" + regionX + "_" + regionZ + ".nbt");
        return p.toFile();
    }

    private static int regionXForChunk(int chunkX) {
        return Math.floorDiv(chunkX, 32);
    }

    private static int regionZForChunk(int chunkZ) {
        return Math.floorDiv(chunkZ, 32);
    }

    private static void enqueueFlush(RegionKey key) {
        flushQueue.add(key);
        WRITER.schedule(ChunkMapPersistence::processFlushQueue, 800L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFlushQueue() {
        RegionKey k;
        HashSet<RegionKey> toFlush = new HashSet<RegionKey>();
        while ((k = flushQueue.poll()) != null) {
            toFlush.add(k);
        }
        if (toFlush.isEmpty()) {
            return;
        }
        for (RegionKey rk : toFlush) {
            RegionEntry entry;
            Object object = CACHE_LOCK;
            synchronized (object) {
                entry = regionCache.get(rk);
            }
            if (entry == null) continue;
            WRITER.submit(() -> {
                try {
                    entry.flushToDisk(rk);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChunkAsync(ResourceLocation dimension, ChunkPos pos, NativeImage image) {
        CompoundTag chunkTag = ChunkMapPersistence.pixelImageToChunkTag(pos, image);
        int rx = ChunkMapPersistence.regionXForChunk(pos.f_45578_);
        int rz = ChunkMapPersistence.regionZForChunk(pos.f_45579_);
        RegionKey rk = new RegionKey(dimension, rx, rz);
        Object object = CACHE_LOCK;
        synchronized (object) {
            RegionEntry regionEntry = regionCache.get(rk);
            if (regionEntry == null) {
                CompoundTag regionTag = ChunkMapPersistence.readRegionTagSafe(ChunkMapPersistence.regionFile(dimension, rx, rz));
                regionEntry = new RegionEntry(regionTag);
                regionCache.put(rk, regionEntry);
            }
            regionEntry.setChunkTag(pos, chunkTag);
        }
        ChunkMapPersistence.enqueueFlush(rk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<NativeImage> loadChunkSync(ResourceLocation dimension, ChunkPos pos) {
        RegionEntry regionEntry;
        int rx = ChunkMapPersistence.regionXForChunk(pos.f_45578_);
        int rz = ChunkMapPersistence.regionZForChunk(pos.f_45579_);
        RegionKey rk = new RegionKey(dimension, rx, rz);
        Object object = CACHE_LOCK;
        synchronized (object) {
            regionEntry = regionCache.get(rk);
            if (regionEntry == null) {
                CompoundTag regionTag = ChunkMapPersistence.readRegionTagSafe(ChunkMapPersistence.regionFile(dimension, rx, rz));
                if (regionTag == null || !regionTag.m_128425_("chunks", 10)) {
                    return Optional.empty();
                }
                regionEntry = new RegionEntry(regionTag);
                regionCache.put(rk, regionEntry);
            }
        }
        CompoundTag chunkTag = regionEntry.getChunkTag(pos);
        if (chunkTag == null) {
            return Optional.empty();
        }
        int[] pixels = chunkTag.m_128465_("pixels");
        if (pixels == null || pixels.length != 256) {
            return Optional.empty();
        }
        NativeImage image = new NativeImage(NativeImage.Format.RGBA, 16, 16, false);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                image.m_84988_(x, y, pixels[y * 16 + x]);
            }
        }
        image.m_85123_();
        return Optional.of(image);
    }

    public static void saveChunk(ResourceLocation dimension, ChunkPos pos, NativeImage image) {
        ChunkMapPersistence.saveChunkAsync(dimension, pos, image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean chunkExists(ResourceLocation dimension, ChunkPos pos) {
        int rx = ChunkMapPersistence.regionXForChunk(pos.f_45578_);
        int rz = ChunkMapPersistence.regionZForChunk(pos.f_45579_);
        RegionKey rk = new RegionKey(dimension, rx, rz);
        Object object = CACHE_LOCK;
        synchronized (object) {
            RegionEntry entry = regionCache.get(rk);
            if (entry != null && entry.hasChunk(pos)) {
                return true;
            }
        }
        File f = ChunkMapPersistence.regionFile(dimension, rx, rz);
        if (!f.exists()) {
            return false;
        }
        try {
            CompoundTag regionTag = ChunkMapPersistence.readRegionTagSafe(f);
            if (regionTag == null) {
                return false;
            }
            if (!regionTag.m_128425_("chunks", 10)) {
                return false;
            }
            CompoundTag chunks = regionTag.m_128469_("chunks");
            String key = ChunkMapPersistence.chunkKey(pos);
            return chunks.m_128425_(key, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        ArrayList<RegionKey> keys;
        Iterator iterator = CACHE_LOCK;
        synchronized (iterator) {
            keys = new ArrayList<RegionKey>(regionCache.keySet());
        }
        for (RegionKey k : keys) {
            RegionEntry e;
            Object object = CACHE_LOCK;
            synchronized (object) {
                e = regionCache.get(k);
            }
            if (e == null) continue;
            try {
                e.flushToDisk(k);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        WRITER.shutdown();
        try {
            if (!WRITER.awaitTermination(2L, TimeUnit.SECONDS)) {
                WRITER.shutdownNow();
            }
        }
        catch (InterruptedException ignored) {
            WRITER.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static String chunkKey(ChunkPos pos) {
        return pos.f_45578_ + "_" + pos.f_45579_;
    }

    private static CompoundTag pixelImageToChunkTag(ChunkPos pos, NativeImage image) {
        CompoundTag chunkTag = new CompoundTag();
        int[] pixels = new int[256];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                pixels[y * 16 + x] = image.m_84985_(x, y);
            }
        }
        chunkTag.m_128385_("pixels", pixels);
        chunkTag.m_128405_("x", pos.f_45578_);
        chunkTag.m_128405_("z", pos.f_45579_);
        chunkTag.m_128356_("ts", Instant.now().toEpochMilli());
        return chunkTag;
    }

    private static CompoundTag readRegionTagSafe(File file) {
        if (!file.exists()) {
            return new CompoundTag();
        }
        try {
            CompoundTag t = NbtIo.m_128937_((File)file);
            return t == null ? new CompoundTag() : t;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                Path source = file.toPath();
                Path corrupt = source.resolveSibling(source.getFileName().toString() + ".corrupt");
                Files.move(source, corrupt, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return new CompoundTag();
        }
    }

    private static void writeRegionTagAtomic(File file, CompoundTag regionTag) throws IOException {
        ChunkMapPersistence.ensureDirs(new ResourceLocation(regionTag.m_128461_("dimension") == null || regionTag.m_128461_("dimension").isEmpty() ? "minecraft:overworld" : regionTag.m_128461_("dimension")));
        Path target = file.toPath();
        Path tmp = Files.createTempFile(target.getParent(), target.getFileName().toString(), ".tmp", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(tmp, StandardOpenOption.TRUNCATE_EXISTING);){
            NbtIo.m_128947_((CompoundTag)regionTag, (OutputStream)os);
            os.flush();
        }
        try {
            Files.move(tmp, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException amne) {
            Files.move(tmp, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static class RegionKey {
        final ResourceLocation dim;
        final int rx;
        final int rz;

        RegionKey(ResourceLocation dim, int rx, int rz) {
            this.dim = dim;
            this.rx = rx;
            this.rz = rz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegionKey)) {
                return false;
            }
            RegionKey r = (RegionKey)o;
            return this.rx == r.rx && this.rz == r.rz && Objects.equals(this.dim, r.dim);
        }

        public int hashCode() {
            return Objects.hash(this.dim, this.rx, this.rz);
        }
    }

    private static class RegionEntry {
        private final CompoundTag regionTag;
        private volatile boolean dirty = false;

        RegionEntry(CompoundTag tag) {
            this.regionTag = tag != null ? tag : new CompoundTag();
        }

        boolean isDirty() {
            return this.dirty;
        }

        synchronized void setChunkTag(ChunkPos pos, CompoundTag chunkTag) {
            CompoundTag chunks = this.regionTag.m_128425_("chunks", 10) ? this.regionTag.m_128469_("chunks") : new CompoundTag();
            String key = ChunkMapPersistence.chunkKey(pos);
            chunks.m_128365_(key, (Tag)chunkTag);
            this.regionTag.m_128365_("chunks", (Tag)chunks);
            this.regionTag.m_128356_("lastModified", Instant.now().toEpochMilli());
            this.regionTag.m_128359_("dimension", this.regionTag.m_128441_("dimension") ? this.regionTag.m_128461_("dimension") : "unknown");
            this.dirty = true;
        }

        synchronized CompoundTag getChunkTag(ChunkPos pos) {
            String key;
            if (!this.regionTag.m_128425_("chunks", 10)) {
                return null;
            }
            CompoundTag chunks = this.regionTag.m_128469_("chunks");
            if (!chunks.m_128425_(key = ChunkMapPersistence.chunkKey(pos), 10)) {
                return null;
            }
            return chunks.m_128469_(key);
        }

        synchronized boolean hasChunk(ChunkPos pos) {
            if (!this.regionTag.m_128425_("chunks", 10)) {
                return false;
            }
            return this.regionTag.m_128469_("chunks").m_128425_(ChunkMapPersistence.chunkKey(pos), 10);
        }

        synchronized void flushToDisk(RegionKey rk) throws IOException {
            if (!this.dirty) {
                return;
            }
            this.regionTag.m_128359_("dimension", rk.dim.toString());
            this.regionTag.m_128405_("regionX", rk.rx);
            this.regionTag.m_128405_("regionZ", rk.rz);
            this.regionTag.m_128356_("lastModified", Instant.now().toEpochMilli());
            File f = ChunkMapPersistence.regionFile(rk.dim, rk.rx, rk.rz);
            ChunkMapPersistence.writeRegionTagAtomic(f, this.regionTag);
            this.dirty = false;
        }
    }
}

