/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.network.MessageDebugGui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class RenameRecruitScreen
extends Screen {
    private static final int fontColor = 0x404040;
    private EditBox editBox;
    private final Screen parent;
    private final AbstractRecruitEntity recruit;
    private int leftPos;
    private int topPos;
    private int imageWidth;
    private int imageHeight;
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/gui_small.png");
    private static final MutableComponent TEXT_CANCEL = Component.m_237115_((String)"gui.recruits.groups.cancel");
    private static final MutableComponent TEXT_SAVE = Component.m_237115_((String)"gui.recruits.groups.save");
    private static final MutableComponent TEXT_RENAME_RECRUIT = Component.m_237115_((String)"gui.recruits.inv.rename");

    public RenameRecruitScreen(Screen parent, AbstractRecruitEntity recruit) {
        super((Component)Component.m_237113_((String)""));
        this.recruit = recruit;
        this.parent = parent;
        this.imageWidth = 250;
        this.imageHeight = 83;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.editBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20, 220, 20, (Component)Component.m_237113_((String)""));
        if (this.recruit != null) {
            this.editBox.m_94144_(this.recruit.m_7755_().getString());
        }
        this.m_142416_((GuiEventListener)this.editBox);
        this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 10, this.topPos + 55, 60, 20, (Component)TEXT_SAVE, button -> {
            String newName = this.editBox.m_94155_();
            if (!newName.isEmpty()) {
                this.recruit.m_6593_((Component)Component.m_237113_((String)newName));
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDebugGui(99, this.recruit.m_20148_(), newName));
                this.f_96541_.m_91152_(this.parent);
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 170, this.topPos + 55, 60, 20, (Component)TEXT_CANCEL, button -> this.f_96541_.m_91152_(this.parent)));
    }

    public void m_86600_() {
        super.m_86600_();
        this.editBox.m_94120_();
    }

    private void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, (Component)TEXT_RENAME_RECRUIT, this.leftPos + 10, this.topPos + 5, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(RESOURCE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.renderForeground(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }
}

