/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.widgets.ScrollDropDownMenu;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.RecruitHireMenu;
import com.talhanation.recruits.network.MessageHire;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class RecruitHireScreen
extends ScreenBase<RecruitHireMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/hire_gui.png");
    private static final MutableComponent TEXT_HIRE = Component.m_237115_((String)"gui.recruits.hire_gui.text.hire");
    private static final int fontColor = 0x404040;
    private final AbstractRecruitEntity recruit;
    private final Player player;
    private ExtendedButton hireButton;
    public static ItemStack currency;
    public static boolean canHire;
    private ScrollDropDownMenu<RecruitsGroup> groupSelectionDropDownMenu;
    public RecruitsGroup group;

    public RecruitHireScreen(RecruitHireMenu recruitContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, recruitContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.recruit = recruitContainer.getRecruitEntity();
        this.player = playerInventory.f_35978_;
        this.f_97726_ = 176;
        this.f_97727_ = 223;
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.hireButton != null) {
            this.hireButton.f_93623_ = canHire;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.group = ClientManager.getSelectedGroup();
        this.groupSelectionDropDownMenu = new ScrollDropDownMenu<RecruitsGroup>(this.group, this.f_97735_ + 80 + 7 + 5, this.f_97736_ + 100, 80, 20, ClientManager.groups, RecruitsGroup::getName, selected -> {
            this.group = selected;
            ClientManager.groupSelection = ClientManager.groups.indexOf(this.group);
        });
        this.groupSelectionDropDownMenu.setBgFillSelected(FastColor.ARGB32.m_13660_((int)255, (int)139, (int)139, (int)139));
        this.m_142416_((GuiEventListener)this.groupSelectionDropDownMenu);
        if (currency != null) {
            currency.m_41764_(this.recruit.getCost());
        }
        this.hireButton = this.createHireButton();
        if (this.group == null || ClientManager.groups.isEmpty()) {
            this.hireButton.f_93623_ = false;
        }
    }

    private ExtendedButton createHireButton() {
        return (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 7, this.f_97736_ + 100, 80, 20, (Component)TEXT_HIRE, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHire(this.player.m_20148_(), this.recruit.m_20148_(), this.group.getUUID()));
            this.m_7379_();
        }));
    }

    public void m_94757_(double x, double y) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.onMouseMove(x, y);
        }
        super.m_94757_(x, y);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.groupSelectionDropDownMenu != null && this.groupSelectionDropDownMenu.m_5953_(mouseX, mouseY)) {
            this.groupSelectionDropDownMenu.onMouseClick(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double d) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_6050_(x, y, d);
        }
        return super.m_6050_(x, y, d);
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int health = Mth.m_14167_((float)this.recruit.m_21223_());
        int maxHealth = Mth.m_14167_((float)this.recruit.m_21233_());
        int moral = Mth.m_14167_((float)this.recruit.getMorale());
        double A_damage = Mth.m_14167_((float)this.recruit.getAttackDamage());
        double speed = this.recruit.m_21172_(Attributes.f_22279_) / 0.3;
        DecimalFormat decimalformat = new DecimalFormat("##.##");
        double armor = this.recruit.m_21230_();
        int k = 60;
        int l = 19;
        guiGraphics.m_280649_(this.f_96547_, this.recruit.m_5446_().m_7532_(), 8, 5, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.player.m_150109_().m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Hp:", k, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + health, k + 25, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Lvl:", k, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXpLevel(), k + 25, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Exp:", k, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXp(), k + 25, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Kills:", k, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getKills(), k + 25, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Morale:", k, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + moral, k + 37, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "MaxHp:", k + 55, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + maxHealth, k + 90, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Attack:", k + 55, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + A_damage, k + 90, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Speed:", k + 55, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, decimalformat.format(speed), k + 90, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Armor:", k + 55, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + armor, k + 90, l + 30, 0x404040, false);
        if (currency != null) {
            guiGraphics.m_280203_(currency, 70, this.f_97727_ - 122);
            guiGraphics.m_280370_(this.f_96547_, currency, 70, this.f_97727_ - 122);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(i + 30), (int)(j + 60), (int)15, (float)((float)(i + 50) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.recruit);
        Entity entity = this.recruit.m_20202_();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(i + 30), (int)(j + 72), (int)15, (float)((float)(i + 50) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)horse);
        }
    }
}

