/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.RecruitsScreenBase;
import com.talhanation.recruits.client.gui.component.RecruitsMultiLineEditBox;
import com.talhanation.recruits.client.gui.widgets.ScrollDropDownMenu;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.network.MessageHireFromNobleVillager;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsHireTrade;
import com.talhanation.recruits.world.RecruitsHireTradesRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class NobleTradeScreen
extends RecruitsScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/noble_villager.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.recruits.villager_noble");
    private static final Component HIRE_BUTTON = Component.m_237115_((String)"gui.recruits.villager_noble.hire");
    private static final Component TEXT_VILLAGERS = Component.m_237115_((String)"gui.recruits.villager_noble.villagers");
    private static final Component INVENTORY_BUTTON = Component.m_237115_((String)"gui.recruits.inv.openInventory");
    private static final Component ERROR_NOT_ENOUGH_VILLAGERS = Component.m_237115_((String)"gui.recruits.villager_noble.error_no_villagers");
    private static final Component ERROR_NO_USES = Component.m_237115_((String)"gui.recruits.villager_noble.error_no_uses");
    private static final Component ERROR_NOT_ENOUGH_CURRENCY = Component.m_237115_((String)"gui.recruits.villager_noble.error_not_enough_currency");
    private final Player player;
    private final VillagerNobleEntity villagerNoble;
    private TradeList tradeList;
    private RecruitsHireTrade selection;
    private Button hireButton;
    private List<Villager> villagerList;
    private RecruitsMultiLineEditBox descriptionBox;
    private Component description = Component.m_237119_();
    private Component tradeTitle = Component.m_237119_();
    private ScrollDropDownMenu<RecruitsGroup> groupSelectionDropDownMenu;
    public RecruitsGroup group;
    private static final int LIST_X = 5;
    private static final int LIST_Y = 18;
    private static final int LIST_W = 85;
    private static final int LIST_H = 170;
    private static final int TRADE_TITLE_X = 98;
    private static final int TRADE_TITLE_Y = 78;
    private static final int LEVEL_BAR_X = 98;
    private static final int LEVEL_BAR_Y = 18;
    private static final int BAR_W = 150;
    private static final int BAR_H = 8;
    int v = 0;
    int xOffset = 50;
    int yOffset = 15;

    public NobleTradeScreen(VillagerNobleEntity villagerNoble, Player player) {
        super(TITLE, 256, 200);
        this.player = player;
        this.villagerNoble = villagerNoble;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.tradeList != null) {
            this.m_169411_((GuiEventListener)this.tradeList);
        }
        int listLeft = this.guiLeft + 5;
        int listTop = this.guiTop + 18;
        int listBottom = listTop + 170;
        int listWidth = 85;
        int listHeight = 170;
        int itemHeight = 40;
        int itemWidth = 75;
        this.group = ClientManager.getSelectedGroup();
        this.tradeList = new TradeList(Minecraft.m_91087_(), listWidth, listHeight, listTop, listBottom, itemHeight, itemWidth);
        this.tradeList.m_93488_(false);
        this.tradeList.m_93496_(false);
        this.tradeList.m_93507_(listLeft);
        this.tradeList.m_93471_(false);
        this.m_142416_((GuiEventListener)this.tradeList);
        this.hireButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 97, this.guiTop + 53, 75, 20, HIRE_BUTTON, btn -> {
            if (ClientManager.configValueNobleNeedsVillagers) {
                if (this.selection != null && this.villagerList != null && !this.villagerList.isEmpty()) {
                    Villager villager = this.villagerList.get(0);
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHireFromNobleVillager(this.villagerNoble.m_20148_(), villager.m_20148_(), this.selection, this.group, true, false));
                    --this.selection.uses;
                }
            } else {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHireFromNobleVillager(this.villagerNoble.m_20148_(), UUID.randomUUID(), this.selection, this.group, false, false));
                --this.selection.uses;
            }
        }));
        this.descriptionBox = new RecruitsMultiLineEditBox(this.f_96547_, this.guiLeft + 98, this.guiTop + 91, 150, 97, (Component)Component.m_237119_(), (Component)Component.m_237119_());
        this.descriptionBox.m_240159_(this.description.getString());
        this.descriptionBox.setEnableEditing(false);
        this.descriptionBox.m_240206_(0.0);
        this.m_142416_((GuiEventListener)this.descriptionBox);
        this.group = ClientManager.getSelectedGroup();
        this.groupSelectionDropDownMenu = new ScrollDropDownMenu<RecruitsGroup>(this.group, this.guiLeft + 174, this.guiTop + 53, 75, 20, ClientManager.groups, RecruitsGroup::getName, selected -> {
            this.group = selected;
            ClientManager.groupSelection = ClientManager.groups.indexOf(this.group);
        });
        this.groupSelectionDropDownMenu.setBgFillSelected(FastColor.ARGB32.m_13660_((int)255, (int)139, (int)139, (int)139));
        this.m_142416_((GuiEventListener)this.groupSelectionDropDownMenu);
        if (this.isPlayerFactionLeader() || this.isPlayerClaimLeader() || this.player.m_20310_(2) && this.player.m_7500_()) {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 256, this.guiTop + 172, 75, 20, INVENTORY_BUTTON, btn -> {
                this.villagerNoble.openGUI(this.player);
                this.m_7379_();
            }));
        }
    }

    public boolean isPlayerFactionLeader() {
        if (this.villagerNoble.m_5647_() != null) {
            String teamID = this.villagerNoble.m_5647_().m_5758_();
            return ClientManager.ownFaction != null && ClientManager.ownFaction.getStringID().equals(teamID) && ClientManager.ownFaction.getTeamLeaderUUID().equals(this.player.m_20148_());
        }
        return false;
    }

    public boolean isPlayerClaimLeader() {
        if (this.villagerNoble.m_5647_() != null) {
            return ClientManager.currentClaim != null && ClientManager.currentClaim.getOwnerFaction().getStringID().equals(this.villagerNoble.m_5647_().m_5758_()) && ClientManager.currentClaim.getPlayerInfo().getUUID().equals(this.player.m_20148_());
        }
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.player.f_19797_ % 20 == 0) {
            this.findVillagers();
        }
        if (this.descriptionBox != null) {
            this.descriptionBox.m_239213_();
        }
        this.loadTrades();
        this.updateHireButtonState();
    }

    private void loadTrades() {
        if (this.tradeList == null) {
            return;
        }
        this.tradeList.m_93516_();
        List<RecruitsHireTrade> trades = this.copyTrades(this.villagerNoble.getTrades());
        for (RecruitsHireTrade serverSideTrade : trades) {
            RecruitsHireTrade clientSideTrade = RecruitsHireTradesRegistry.getByResourceLocation(serverSideTrade.resourceLocation);
            if (clientSideTrade == null) continue;
            serverSideTrade.title = clientSideTrade.title;
            serverSideTrade.description = clientSideTrade.description;
            TradeList tradeList = this.tradeList;
            Objects.requireNonNull(tradeList);
            this.tradeList.addEntry(tradeList.new TradeList.TradeEntry(serverSideTrade));
        }
    }

    private List<RecruitsHireTrade> copyTrades(List<RecruitsHireTrade> original) {
        if (original == null) {
            return new ArrayList<RecruitsHireTrade>();
        }
        ArrayList<RecruitsHireTrade> copy = new ArrayList<RecruitsHireTrade>();
        for (RecruitsHireTrade t : original) {
            RecruitsHireTrade clone = new RecruitsHireTrade(t.resourceLocation, t.cost, t.title, t.description);
            clone.uses = t.uses;
            clone.maxUses = t.maxUses;
            copy.add(clone);
        }
        return copy;
    }

    private void findVillagers() {
        this.villagerList = this.player.m_20193_().m_45976_(Villager.class, this.player.m_20191_().m_82400_(32.0)).stream().filter(v -> v.m_7141_().m_35571_().equals((Object)VillagerProfession.f_35585_) && !v.m_6162_()).sorted(Comparator.comparing(v -> Float.valueOf(v.m_20270_((Entity)this.player)))).collect(Collectors.toList());
    }

    public void m_94757_(double x, double y) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.onMouseMove(x, y);
        }
        super.m_94757_(x, y);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.groupSelectionDropDownMenu != null && this.groupSelectionDropDownMenu.m_5953_(mouseX, mouseY)) {
            this.groupSelectionDropDownMenu.onMouseClick(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double d) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_6050_(x, y, d);
        }
        return super.m_6050_(x, y, d);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, TITLE, this.guiLeft + 10, this.guiTop + 7, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("Lvl: " + this.villagerNoble.getTraderLevel())), this.guiLeft + 98, this.guiTop + 7, 0x404040, false);
        this.v = this.villagerList != null ? this.villagerList.size() : 0;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)(TEXT_VILLAGERS.getString() + ": " + this.v)), this.guiLeft + 98, this.guiTop + 30, 0x404040, false);
        if (this.selection != null) {
            int x = this.guiLeft + 98;
            int y = this.guiTop + 78;
            guiGraphics.m_280614_(this.f_96547_, this.tradeTitle, x, y, 0x404040, false);
        }
        int progress = (int)((double)this.villagerNoble.getTraderProgress() * 1.5);
        guiGraphics.m_280509_(this.guiLeft + 98, this.guiTop + 18, this.guiLeft + 98 + 150, this.guiTop + 18 + 8, -11184811);
        guiGraphics.m_280509_(this.guiLeft + 98, this.guiTop + 18, this.guiLeft + 98 + progress, this.guiTop + 18 + 8, -16711936);
    }

    public void m_7379_() {
        super.m_7379_();
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHireFromNobleVillager(this.villagerNoble.m_20148_(), UUID.randomUUID(), this.selection, this.group, false, true));
    }

    private void updateHireButtonState() {
        if (this.hireButton == null) {
            return;
        }
        this.hireButton.m_257544_(this.getErrorMessage());
        if (this.selection == null) {
            this.hireButton.f_93623_ = false;
            return;
        }
        int playerMoney = this.getPlayerCurrencyAmount();
        boolean hasMoney = playerMoney >= this.selection.cost || this.player.m_7500_();
        boolean hasVillager = true;
        if (ClientManager.configValueNobleNeedsVillagers) {
            hasVillager = this.villagerList != null && this.villagerList.size() > 2;
        }
        this.hireButton.f_93623_ = this.selection.uses > 0 && hasMoney && hasVillager;
    }

    private int getPlayerCurrencyAmount() {
        int count = 0;
        for (ItemStack stack : this.player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_150930_(ClientManager.currency.m_41720_())) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private void onSelected(TradeList.TradeEntry entry) {
        this.tradeTitle = entry.trade.title;
        Component desc = entry.trade.description;
        this.descriptionBox.m_240159_(desc.getString());
    }

    private Tooltip getErrorMessage() {
        List<HireError> errors = this.getErrors();
        if (errors.isEmpty()) {
            return Tooltip.m_257550_((Component)Component.m_237119_());
        }
        MutableComponent tooltip = Component.m_237113_((String)"");
        for (int i = 0; i < errors.size(); ++i) {
            tooltip.m_7220_((Component)Component.m_237113_((String)"- ").m_7220_(errors.get(i).getMessage()));
            if (i >= errors.size() - 1) continue;
            tooltip.m_7220_((Component)Component.m_237113_((String)"\n"));
        }
        return Tooltip.m_257550_((Component)tooltip);
    }

    private List<HireError> getErrors() {
        ArrayList<HireError> errorList = new ArrayList<HireError>();
        if (ClientManager.configValueNobleNeedsVillagers && (this.villagerList == null || this.villagerList.size() < 2)) {
            errorList.add(HireError.NOT_ENOUGH_VILLAGERS_NEARBY);
        } else if (this.selection != null) {
            int playerMoney = this.getPlayerCurrencyAmount();
            if (!this.player.m_7500_() && playerMoney < this.selection.cost) {
                errorList.add(HireError.NOT_ENOUGH_CURRENCY);
            }
            if (this.selection.uses <= 0) {
                errorList.add(HireError.NO_USES);
            }
        }
        return errorList;
    }

    private class TradeList
    extends ObjectSelectionList<TradeEntry> {
        public int itemWidth;

        public TradeList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight, int itemWidth) {
            super(mc, width, height, top, bottom, itemHeight);
            this.itemWidth = itemWidth;
        }

        protected int addEntry(TradeEntry p_93487_) {
            return super.m_7085_((AbstractSelectionList.Entry)p_93487_);
        }

        protected void m_93516_() {
            super.m_93516_();
        }

        protected int m_5756_() {
            return this.m_5747_() + this.m_5759_() + 5;
        }

        public int m_5747_() {
            return super.m_5747_() - 7;
        }

        public int m_5759_() {
            return 73;
        }

        public void setSelected(@Nullable TradeEntry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (entry == null) {
                return;
            }
            NobleTradeScreen.this.onSelected(entry);
        }

        public class TradeEntry
        extends ObjectSelectionList.Entry<TradeEntry> {
            private final RecruitsHireTrade trade;

            public TradeEntry(RecruitsHireTrade trade) {
                this.trade = trade;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                int rowLeft = TradeList.this.m_5747_();
                int rowWidth = TradeList.this.itemWidth;
                int x = rowLeft + 4;
                int y = top + 3;
                boolean selected = TradeList.this.m_93511_() == this;
                boolean out = this.trade.uses <= 0;
                int textureY = this.getButtonTextureY(hovered, selected, out);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                guiGraphics.m_280027_(AbstractButton.f_93617_, rowLeft, top, rowWidth, entryHeight, 20, 4, 200, 20, 0, textureY);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                guiGraphics.m_280614_(NobleTradeScreen.this.f_96547_, this.trade.title, x, y, -2039584, false);
                guiGraphics.m_280614_(NobleTradeScreen.this.f_96547_, (Component)Component.m_237113_((String)("" + this.trade.uses)), x, y + NobleTradeScreen.this.yOffset + 5, -2039584, false);
                if (ClientManager.currency != null) {
                    ClientManager.currency.m_41764_(this.trade.cost);
                    guiGraphics.m_280203_(ClientManager.currency, x + NobleTradeScreen.this.xOffset, y + NobleTradeScreen.this.yOffset);
                    guiGraphics.m_280370_(NobleTradeScreen.this.f_96547_, ClientManager.currency, x + NobleTradeScreen.this.xOffset, y + NobleTradeScreen.this.yOffset);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                TradeList.this.setSelected(this);
                NobleTradeScreen.this.selection = this.trade;
                NobleTradeScreen.this.updateHireButtonState();
                return true;
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }

            private int getButtonTextureY(boolean hovered, boolean selected, boolean out) {
                int BUTTON_Y_OUT = 46;
                int BUTTON_Y_NORMAL = 66;
                int BUTTON_Y_HOVER = 86;
                int BUTTON_Y_PRESSED = 86;
                if (out) {
                    return 46;
                }
                if (selected) {
                    return 86;
                }
                if (hovered) {
                    return 86;
                }
                return 66;
            }
        }
    }

    public static enum HireError {
        NOT_ENOUGH_CURRENCY(ERROR_NOT_ENOUGH_CURRENCY),
        NOT_ENOUGH_VILLAGERS_NEARBY(ERROR_NOT_ENOUGH_VILLAGERS),
        NO_USES(ERROR_NO_USES);

        private final Component message;

        private HireError(Component message) {
            this.message = message;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

