/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.events;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.overlay.FactionClaimBannerOverlay;
import com.talhanation.recruits.client.gui.overlay.FactionClaimSiegeOverlay;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsClaimManager;
import com.talhanation.recruits.world.RecruitsFaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientPlayerEvents {
    private State state;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        RecruitsClaim claim;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || event.phase != TickEvent.Phase.END) {
            return;
        }
        ChunkPos currentChunk = player.m_146902_();
        ClientManager.currentClaim = claim = RecruitsClaimManager.getClaimAt(currentChunk, ClientManager.recruitsClaims);
        if (this.state == null) {
            this.state = State.NO_CLAIM;
            FactionClaimBannerOverlay.deactivate();
            FactionClaimSiegeOverlay.deactivate();
        }
        switch (this.state) {
            case NO_CLAIM: {
                if (claim == null) break;
                if (!claim.isUnderSiege) {
                    FactionClaimBannerOverlay.activate(claim);
                }
                this.state = State.IN_CLAIM;
                break;
            }
            case IN_CLAIM: {
                if (FactionClaimBannerOverlay.claimUUID != null) {
                    if (claim != null && FactionClaimBannerOverlay.claimUUID.equals(claim.getUUID())) {
                        if (player.f_19797_ % 20 == 0) {
                            FactionClaimBannerOverlay.update(claim);
                        }
                        if (!claim.isUnderSiege) break;
                        RecruitsFaction defender = claim.getOwnerFaction();
                        RecruitsFaction attacker = claim.attackingParties != null && !claim.attackingParties.isEmpty() ? claim.attackingParties.get(0) : null;
                        FactionClaimBannerOverlay.deactivate();
                        FactionClaimSiegeOverlay.activate(claim.getName(), defender, attacker, claim.getHealth(), claim.getMaxHealth());
                        this.state = State.SIEGE;
                        break;
                    }
                    FactionClaimBannerOverlay.deactivate();
                    this.state = State.NO_CLAIM;
                    break;
                }
                FactionClaimBannerOverlay.deactivate();
                this.state = State.NO_CLAIM;
                break;
            }
            case SIEGE: {
                if (claim == null) {
                    FactionClaimSiegeOverlay.deactivate();
                    this.state = State.NO_CLAIM;
                    break;
                }
                if (!claim.isUnderSiege) {
                    FactionClaimBannerOverlay.activate(claim);
                    FactionClaimSiegeOverlay.deactivate();
                    this.state = State.IN_CLAIM;
                    break;
                }
                FactionClaimSiegeOverlay.update(claim);
            }
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGuiOverlayEvent event) {
        FactionClaimBannerOverlay.renderOverlay(event.getGuiGraphics(), event.getWindow().m_85445_());
        FactionClaimSiegeOverlay.renderOverlay(event.getGuiGraphics(), event.getWindow().m_85445_());
    }

    static enum State {
        NO_CLAIM,
        IN_CLAIM,
        SIEGE;

    }
}

