/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientManager {
    public static List<RecruitsClaim> recruitsClaims = new ArrayList<RecruitsClaim>();
    public static List<RecruitsFaction> factions = new ArrayList<RecruitsFaction>();
    public static List<RecruitsGroup> groups = new ArrayList<RecruitsGroup>();
    public static RecruitsFaction ownFaction;
    public static Map<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>> diplomacyMap;
    public static int configValueClaimCost;
    public static int configValueChunkCost;
    public static boolean configValueCascadeClaimCost;
    public static ItemStack currencyItemStack;
    public static boolean isFactionEditingAllowed;
    public static boolean isFactionManagingAllowed;
    public static List<RecruitsPlayerInfo> onlinePlayers;
    public static ItemStack currency;
    public static int factionCreationPrice;
    public static int factionMaxRecruitsPerPlayerConfigSetting;
    public static boolean configValueNobleNeedsVillagers;
    public static int availableRecruitsToHire;
    public static int formationSelection;
    public static int groupSelection;
    @Nullable
    public static RecruitsClaim currentClaim;

    @OnlyIn(value=Dist.CLIENT)
    public static RecruitsDiplomacyManager.DiplomacyStatus getRelation(String team, String otherTeam) {
        return ((Map)diplomacyMap.getOrDefault(team, new HashMap())).getOrDefault(otherTeam, RecruitsDiplomacyManager.DiplomacyStatus.NEUTRAL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RecruitsPlayerInfo getPlayerInfo() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return new RecruitsPlayerInfo(player.m_20148_(), player.m_7755_().getString(), ownFaction);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RecruitsGroup getGroup(UUID groupUUID) {
        for (RecruitsGroup group : groups) {
            if (!group.getUUID().equals(groupUUID)) continue;
            return group;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RecruitsGroup getSelectedGroup() {
        if (groups != null && !groups.isEmpty()) {
            try {
                return groups.get(groupSelection);
            }
            catch (Exception exception) {
                groupSelection = 0;
                return groups.get(0);
            }
        }
        return null;
    }

    public static void updateGroups() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || groups == null || groups.isEmpty()) {
            return;
        }
        List recruits = player.m_9236_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0));
        recruits.removeIf(arg_0 -> ClientManager.lambda$updateGroups$0((Player)player, arg_0));
        HashMap<UUID, Integer> groupCounts = new HashMap<UUID, Integer>();
        for (AbstractRecruitEntity recruit : recruits) {
            UUID groupId = recruit.getGroup();
            if (groupId == null) continue;
            groupCounts.put(groupId, groupCounts.getOrDefault(groupId, 0) + 1);
        }
        for (RecruitsGroup group : groups) {
            int count = groupCounts.getOrDefault(group.getUUID(), 0);
            group.setCount(count);
        }
        groups.sort((a, b) -> Integer.compare(b.getCount(), a.getCount()));
    }

    private static /* synthetic */ boolean lambda$updateGroups$0(Player player, AbstractRecruitEntity r) {
        return !r.isEffectedByCommand(player.m_20148_());
    }

    static {
        diplomacyMap = new HashMap<String, Map<String, RecruitsDiplomacyManager.DiplomacyStatus>>();
        onlinePlayers = new ArrayList<RecruitsPlayerInfo>();
    }
}

