/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.util.ClaimUtil;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsClaimManager;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClaimEvents {
    public static MinecraftServer server;
    public static RecruitsClaimManager recruitsClaimManager;
    public static int counter;

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        ServerLevel level = server.m_129783_();
        recruitsClaimManager = new RecruitsClaimManager();
        recruitsClaimManager.load(level);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        recruitsClaimManager.save(server.m_129783_());
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        recruitsClaimManager.save(server.m_129783_());
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            recruitsClaimManager.broadcastClaimsToAll(server.m_129783_());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.getServer().m_129783_().m_5776_()) {
            return;
        }
        if (counter++ < 100) {
            return;
        }
        counter = 0;
        for (RecruitsClaim claim : recruitsClaimManager.getAllClaims()) {
            RecruitsFaction recruitsFaction;
            ServerLevel level = server.m_129783_();
            this.takeOverVillager(level, claim);
            if (claim == null) {
                return;
            }
            if (claim.isAdmin) {
                return;
            }
            List<LivingEntity> attackers = ClaimUtil.getLivingEntitiesInClaim((Level)level, claim, livingEntity -> livingEntity.m_6084_() && livingEntity.m_5647_() != null && FactionEvents.recruitsDiplomacyManager.getRelation(livingEntity.m_5647_().m_5758_(), claim.getOwnerFactionStringID()) == RecruitsDiplomacyManager.DiplomacyStatus.ENEMY);
            List<LivingEntity> defenders = ClaimUtil.getLivingEntitiesInClaim((Level)level, claim, livingEntity -> livingEntity.m_6084_() && livingEntity.m_5647_() != null && (livingEntity.m_5647_().m_5758_().equals(claim.getOwnerFactionStringID()) || FactionEvents.recruitsDiplomacyManager.getRelation(livingEntity.m_5647_().m_5758_(), claim.getOwnerFactionStringID()) == RecruitsDiplomacyManager.DiplomacyStatus.ALLY));
            int attackerSize = attackers.size();
            int defendersSize = defenders.size();
            for (LivingEntity livingEntity2 : defenders) {
                if (livingEntity2.m_5647_() == null || claim.defendingParties.contains(recruitsFaction = FactionEvents.recruitsFactionManager.getTeamByStringID(livingEntity2.m_5647_().m_5758_())) || claim.getOwnerFaction() == recruitsFaction) continue;
                claim.defendingParties.add(recruitsFaction);
            }
            for (LivingEntity livingEntity2 : attackers) {
                if (livingEntity2.m_5647_() == null || claim.attackingParties.contains(recruitsFaction = FactionEvents.recruitsFactionManager.getTeamByStringID(livingEntity2.m_5647_().m_5758_()))) continue;
                claim.attackingParties.add(recruitsFaction);
            }
            if (claim.isUnderSiege) {
                if (attackerSize < (Integer)RecruitsServerConfig.SiegeClaimsRecruitsAmount.get()) {
                    claim.setUnderSiege(false, level);
                    claim.resetHealth();
                    claim.attackingParties.clear();
                    claim.defendingParties.clear();
                    recruitsClaimManager.broadcastClaimsToAll(level);
                    return;
                }
                claim.setHealth(claim.getHealth() - 3);
                if (claim.getHealth() <= 0) {
                    claim.setSiegeSuccess(level);
                    recruitsClaimManager.broadcastClaimsToAll(level);
                    return;
                }
                List<ServerPlayer> players = attackers.stream().filter(livingEntity -> livingEntity instanceof ServerPlayer).map(e -> (ServerPlayer)e).toList();
                recruitsClaimManager.broadcastClaimUpdateTo(claim, players);
                players = defenders.stream().filter(livingEntity -> livingEntity instanceof ServerPlayer).map(e -> (ServerPlayer)e).toList();
                recruitsClaimManager.broadcastClaimUpdateTo(claim, players);
                continue;
            }
            if (attackerSize < (Integer)RecruitsServerConfig.SiegeClaimsRecruitsAmount.get()) continue;
            claim.setUnderSiege(true, level);
            recruitsClaimManager.broadcastClaimsToAll(level);
        }
    }

    private void takeOverVillager(ServerLevel level, RecruitsClaim claim) {
        List<LivingEntity> list = ClaimUtil.getLivingEntitiesInClaim((Level)level, claim, livingEntity -> (livingEntity instanceof Villager || livingEntity instanceof VillagerNobleEntity) && livingEntity.m_6084_());
        if (list.isEmpty()) {
            return;
        }
        String teamName = claim.getOwnerFaction().getStringID();
        PlayerTeam team = level.m_6188_().m_83489_(teamName);
        if (team == null) {
            return;
        }
        for (LivingEntity living : list) {
            if (living.m_5647_() != null && living.m_5647_().m_5758_().equals(team.m_5758_())) continue;
            level.m_6188_().m_6546_(living.m_20149_(), team);
        }
    }

    public static List<AbstractRecruitEntity> getRecruitsOfTeamInRange(Level level, Player attackingPlayer, double radius, String teamId) {
        return level.m_45976_(AbstractRecruitEntity.class, attackingPlayer.m_20191_().m_82400_(radius)).stream().filter(recruit -> recruit.m_6084_() && recruit.m_5647_() != null && teamId.equals(recruit.m_5647_().m_5758_())).toList();
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ChunkAccess access = server.m_129783_().m_46865_(event.getPos());
        RecruitsClaim claim = recruitsClaimManager.getClaim(access.m_7697_());
        Player player = event.getPlayer();
        if (player.m_7500_() && player.m_20310_(2)) {
            return;
        }
        if (claim == null) {
            if (((Boolean)RecruitsServerConfig.BlockPlacingBreakingOnlyWhenClaimed.get()).booleanValue()) {
                event.setCanceled(true);
            }
            return;
        }
        if (!claim.isBlockBreakingAllowed()) {
            boolean isInTeam;
            boolean bl = isInTeam = player.m_5647_() != null && player.m_5647_().m_5758_().equals(claim.getOwnerFactionStringID());
            if (!isInTeam) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Player player;
        if (event.getLevel().m_5776_()) {
            return;
        }
        ChunkAccess access = server.m_129783_().m_46865_(event.getPos());
        RecruitsClaim claim = recruitsClaimManager.getClaim(access.m_7697_());
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_20310_(2)) {
            return;
        }
        if (claim == null) {
            if (((Boolean)RecruitsServerConfig.BlockPlacingBreakingOnlyWhenClaimed.get()).booleanValue()) {
                event.setCanceled(true);
            }
            return;
        }
        if (!claim.isBlockPlacementAllowed()) {
            LivingEntity livingEntity;
            boolean isInTeam;
            boolean bl = isInTeam = entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_5647_() != null && livingEntity.m_5647_().m_5758_().equals(claim.getOwnerFactionStringID());
            if (!isInTeam) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent event) {
        Player player;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Vec3 vec = event.getExplosion().getPosition();
        BlockPos pos = new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_);
        ChunkAccess access = server.m_129783_().m_46865_(pos);
        RecruitsClaim claim = recruitsClaimManager.getClaim(access.m_7697_());
        Entity entity = event.getExplosion().m_253049_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_() && player.m_20310_(2)) {
            return;
        }
        if (claim != null && ((Boolean)RecruitsServerConfig.ExplosionProtectionInClaims.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ChunkAccess access = server.m_129783_().m_46865_(event.getPos());
        RecruitsClaim claim = recruitsClaimManager.getClaim(access.m_7697_());
        if (claim == null) {
            return;
        }
        BlockPos pos = event.getHitVec().m_82425_();
        Player player = event.getEntity();
        if (player.m_7500_() && player.m_20310_(2)) {
            return;
        }
        BlockState selectedBlock = player.m_20193_().m_8055_(pos);
        BlockEntity blockEntity = player.m_20193_().m_7702_(pos);
        if ((selectedBlock.m_204336_(BlockTags.f_13093_) || selectedBlock.m_204336_(BlockTags.f_13103_) || selectedBlock.m_204336_(BlockTags.f_13102_) || selectedBlock.m_204336_(BlockTags.f_13092_) || selectedBlock.m_204336_(BlockTags.f_13095_) || selectedBlock.m_204336_(BlockTags.f_13083_) || selectedBlock.m_204336_(BlockTags.f_13055_) || selectedBlock.m_204336_(BlockTags.f_13033_) || selectedBlock.m_60734_() instanceof LeverBlock || selectedBlock.m_60734_() instanceof DiodeBlock || selectedBlock.m_60734_() instanceof DaylightDetectorBlock || blockEntity instanceof Container) && !claim.isBlockInteractionAllowed()) {
            boolean isInTeam;
            boolean bl = isInTeam = player.m_5647_() != null && player.m_5647_().m_5758_().equals(claim.getOwnerFactionStringID());
            if (!isInTeam) {
                event.setCanceled(true);
            }
        }
    }
}

