/*
 * Decompiled with CFR 0.152.
 */
package net.mrbusdriver.rationcraft.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="rationcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RationcraftModLootModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"rationcraft");
    public static final RegistryObject<Codec<RationcraftModLootTableModifier>> LOOT_MODIFIER = LOOT_MODIFIERS.register("rationcraft_loot_modifier", RationcraftModLootTableModifier.CODEC);

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        event.enqueueWork(() -> LOOT_MODIFIERS.register(bus));
    }

    public static class RationcraftModLootTableModifier
    extends LootModifier {
        public static final Supplier<Codec<RationcraftModLootTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> RationcraftModLootTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.f_135803_.fieldOf("lootTable").forGetter(m -> m.lootTable)).apply((Applicative)instance, RationcraftModLootTableModifier::new)));
        private final ResourceLocation lootTable;

        public RationcraftModLootTableModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
            super(conditions);
            this.lootTable = lootTable;
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            context.m_278643_().m_278676_(this.lootTable).m_79131_(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

