/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.EnumConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.api.QuestFile;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import questsadditions.events.EventTypes;
import questsadditions.tasks.BreakTask;
import questsadditions.tasks.DayTask;
import questsadditions.tasks.InteractionTask;
import questsadditions.tasks.KillNbtTask;
import questsadditions.tasks.PlaceTask;
import questsadditions.tasks.PlayerNbtTask;
import questsadditions.tasks.StructureTask;
import questsadditions.tasks.TimeTask;
import questsadditions.tasks.UseTask;

public class TasksRegistry {
    private List<BreakTask> breakTasks = null;
    private List<UseTask> useTasks = null;
    private List<PlaceTask> placeTasks = null;
    private List<StructureTask> structureTasks = null;
    private List<InteractionTask> interactionTasks = null;
    public static final TaskType BREAK = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "break"), BreakTask::new, () -> Icon.getIcon((String)"minecraft:block/stone").combineWith(Icon.getIcon((String)"minecraft:item/diamond_pickaxe")));
    public static final TaskType PLACE = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "place"), PlaceTask::new, () -> Icon.getIcon((String)"minecraft:block/stone"));
    public static final TaskType USE = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "use"), UseTask::new, () -> Icon.getIcon((String)"minecraft:item/flint_and_steel"));
    public static final TaskType KILLNBT = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "killnbt"), KillNbtTask::new, () -> Icon.getIcon((String)"minecraft:item/diamond_sword"));
    public static final TaskType INTERACTION = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "interaction"), InteractionTask::new, () -> Icon.getIcon((String)"minecraft:item/emerald"));
    public static final TaskType PLAYERNBT = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "playernbt"), PlayerNbtTask::new, () -> Icons.FRIENDS);
    public static final TaskType STRUCTURE = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "structure"), StructureTask::new, () -> Icons.ART);
    public static final TaskType TIME = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "time"), TimeTask::new, () -> Icons.TIME);
    public static final TaskType DAYS = TaskTypes.register((ResourceLocation)new ResourceLocation("questsadditions", "days"), DayTask::new, () -> Icon.getIcon((String)"minecraft:item/clock_00"));
    private static TasksRegistry INSTANCE = null;
    public static final Event<EventTypes.Place> REPLACE = EventFactory.createEventResult((Object[])new EventTypes.Place[0]);
    public static final Event<EventTypes.Use> USE_EVENT = EventFactory.createEventResult((Object[])new EventTypes.Use[0]);

    private TasksRegistry() {
    }

    public void init() {
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        BlockEvent.BREAK.register(this::breakBlock);
        REPLACE.register(this::placeBlock);
        USE_EVENT.register(this::useBlock);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
    }

    public static TasksRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TasksRegistry();
        }
        return INSTANCE;
    }

    public List<StructureTask> getStructureTasks() {
        if (this.structureTasks == null) {
            this.structureTasks = ServerQuestFile.INSTANCE.collect(StructureTask.class);
        }
        return this.structureTasks;
    }

    private void fileCacheClear(QuestFile file) {
        if (file.isServerSide()) {
            this.breakTasks = null;
            this.useTasks = null;
            this.placeTasks = null;
            this.structureTasks = null;
        }
    }

    private EventResult interactEntity(Player player, Entity entity, InteractionHand hand) {
        if (!this.isTrueServerPlayer(entity)) {
            return EventResult.pass();
        }
        if (this.interactionTasks == null) {
            this.interactionTasks = ServerQuestFile.INSTANCE.collect(InteractionTask.class);
        }
        if (this.interactionTasks.isEmpty()) {
            return EventResult.pass();
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        for (InteractionTask task : this.interactionTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.Interact(data, entity, player.m_21205_());
        }
        return EventResult.pass();
    }

    private EventResult breakBlock(Level world, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (!this.isTrueServerPlayer((Entity)player)) {
            return EventResult.pass();
        }
        if (this.breakTasks == null) {
            this.breakTasks = ServerQuestFile.INSTANCE.collect(BreakTask.class);
        }
        if (this.breakTasks.isEmpty()) {
            return EventResult.pass();
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        for (BreakTask task : this.breakTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.Break(data, state.m_60734_(), player.m_21205_());
        }
        return EventResult.pass();
    }

    private InteractionResult useBlock(ServerPlayer player, Level world, ItemStack stack, BlockState state, boolean useItem) {
        if (!this.isTrueServerPlayer((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (this.useTasks == null) {
            this.useTasks = ServerQuestFile.INSTANCE.collect(UseTask.class);
        }
        if (this.useTasks.isEmpty()) {
            return InteractionResult.PASS;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        for (UseTask task : this.useTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.Use(data, state.m_60734_(), useItem, stack);
        }
        return InteractionResult.PASS;
    }

    private EventResult placeBlock(Level world, BlockPos pos, BlockState Old, BlockState New, @Nullable Entity entity) {
        if (!this.isTrueServerPlayer(entity)) {
            return EventResult.pass();
        }
        if (this.placeTasks == null) {
            this.placeTasks = ServerQuestFile.INSTANCE.collect(PlaceTask.class);
        }
        if (this.placeTasks.isEmpty()) {
            return EventResult.pass();
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData(entity);
        for (PlaceTask task : this.placeTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.Place(data, Old.m_60734_(), New.m_60734_());
        }
        return EventResult.pass();
    }

    public static <E> EnumConfig<E> addEnum(ConfigGroup group, String id, E value, Consumer<E> setter, NameMap<E> nameMap, E def) {
        return (EnumConfig)group.add(id, (ConfigValue)new EnumConfig<E>(nameMap){

            public void addInfo(TooltipList list) {
                list.add(1.info((String)"Default", (Object)this.getStringForGUI(this.defaultValue)));
            }
        }, value, setter, def);
    }

    private boolean isTrueServerPlayer(Entity player) {
        return player instanceof ServerPlayer && !PlayerHooks.isFake((Player)((Player)player));
    }
}

