/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.Stripper;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class StripperContainer
extends AbstractContainer {
    public final StripperBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public StripperContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, StripperContainer.getTileEntity(playerInventory, data));
    }

    public StripperContainer(int windowId, Inventory playerInventory, StripperBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.STRIPPER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, StripperBlockEntity.SLOT_IN, 44, 25));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, StripperBlockEntity.SLOT_AXE, 44, 44));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, StripperBlockEntity.SLOT_OUT, 116, 25));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, StripperBlockEntity.SLOT_BARK, 116, 44));
        });
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static StripperBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof StripperBlockEntity) {
            return (StripperBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof Stripper && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

