/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivelib.datagen.recipe.SingleConditionalRecipe;
import cy.jdkdigital.productivetrees.datagen.ItemTagProvider;
import cy.jdkdigital.productivetrees.datagen.recipe.BotanyPotCropRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.SawmillRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.ThermalExtractorRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.ThermalInsulatorRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.ThermalSawmilRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.TreePollinationRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.TreetapRecipeBuilder;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.woodcutter.registry.ModRecipeSerializers;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    String[] RESIN_TREES = new String[]{"bull_pine", "douglas_fir", "cedar", "loblolly_pine", "sweetgum"};

    public RecipeProvider(PackOutput gen) {
        super(gen);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42516_, (int)2).m_126132_("has_sawdust", (CriterionTriggerInstance)RecipeProvider.m_206406_(ModTags.SAWDUST)).m_126130_("###").m_126130_("#W#").m_126130_("###").m_126124_(Character.valueOf('#'), Ingredient.m_204132_(ModTags.SAWDUST)).m_126124_(Character.valueOf('W'), (Ingredient)StrictNBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))).m_126140_(consumer, new ResourceLocation("productivetrees", "sawdust_to_paper_water_bottle"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42516_, (int)2).m_126132_("has_sawdust", (CriterionTriggerInstance)RecipeProvider.m_206406_(ModTags.SAWDUST)).m_126130_("###").m_126130_("#W#").m_126130_("###").m_126124_(Character.valueOf('#'), Ingredient.m_204132_(ModTags.SAWDUST)).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawdust_to_paper"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42501_, (int)3).m_126132_("has_maple_syrup", (CriterionTriggerInstance)RecipeProvider.m_206406_(ModTags.MAPLE_SYRUP)).m_206419_(ModTags.MAPLE_SYRUP).m_126140_(consumer, new ResourceLocation("productivetrees", "sugar_from_maple_syrup"));
        Block THERMAL_SAWMILL = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thermal:sawmill"));
        Block THERMAL_INSOLATOR = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thermal:insolator"));
        Block THERMAL_EXTRACTOR = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thermal:tree_extractor"));
        TreeFinder.trees.forEach((id, treeObject) -> {
            Block planks = TreeUtil.getBlock(treeObject.getId(), "_planks");
            RecipeProvider.planksFromLogs(consumer, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks"), (TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("productivetrees", id.m_135815_() + "_logs")));
            RecipeProvider.m_126002_(consumer, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_wood"), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_log"));
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.STAIRS, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_stairs"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.SLAB, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_slab"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.PRESSURE_PLATE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_pressure_plate"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.BUTTON, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_button"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.FENCE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.FENCE_GATE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence_gate"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.DOOR, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_door"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.TRAPDOOR, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_trapdoor"), (ItemLike)planks);
            RecipeProvider.shapedVariant(consumer, BlockFamily.Variant.SIGN, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_sign"), (ItemLike)planks);
            RecipeProvider.m_246977_(consumer, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_hanging_sign"), (ItemLike)planks);
            this.buildSawmillRecipe((WoodObject)treeObject, consumer);
            this.buildCorailWoodcutterRecipes((WoodObject)treeObject, consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_bookshelf")).m_126127_(Character.valueOf('#'), (ItemLike)planks).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42517_).m_126130_("###").m_126130_("XXX").m_126130_("###").m_126132_("has_book", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)planks)).m_126140_(consumer, treeObject.getId().m_247266_(p -> "bookshelves/" + p + "_bookshelf"));
            if (THERMAL_SAWMILL != null) {
                SingleConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("thermal")).setRecipe(arg_0 -> ((RecipeBuilder)ThermalSawmilRecipeBuilder.tree(TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood"), TreeUtil.getBlock(treeObject.getId(), "_planks")).m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_log"))).m_126132_("has_sawmill", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)THERMAL_SAWMILL))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "thermal/sawmill/" + id.m_135815_()));
            }
            if (THERMAL_INSOLATOR != null) {
                SingleConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("thermal")).setRecipe(arg_0 -> ((RecipeBuilder)ThermalInsulatorRecipeBuilder.tree(TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_sapling"), treeObject.getFruit().getItem().m_41777_(), treeObject.getFruit().growthSpeed()).m_126132_("has_sapling", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks"))).m_126132_("has_insolator", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)THERMAL_INSOLATOR))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "thermal/insolator/" + id.m_135815_()));
            }
            if (THERMAL_EXTRACTOR != null) {
                String fluidName = "thermal:sap";
                if (Arrays.stream(this.RESIN_TREES).anyMatch(s -> s.equals(id.m_135815_()))) {
                    fluidName = "thermal:resin";
                }
                if (id.m_135815_().equals("rubber_tree")) {
                    fluidName = "thermal:latex";
                }
                if (id.m_135815_().equals("sugar_maple")) {
                    fluidName = "productivetrees:maple_sap";
                }
                FluidStack fluid = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName)), 50);
                SingleConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("thermal")).setRecipe(arg_0 -> ((RecipeBuilder)ThermalExtractorRecipeBuilder.direct(TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_leaves"), fluid).m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_log"))).m_126132_("has_tree_extractor", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)THERMAL_EXTRACTOR))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "thermal/tree_extractor/" + id.m_135815_()));
            }
            if (treeObject.getStyle().hiveStyle() != null) {
                this.buildHiveRecipe("productivetrees", (WoodObject)treeObject, consumer);
                this.buildBoxRecipe("productivetrees", (WoodObject)treeObject, consumer);
            }
            this.buildBotanyPotsRecipe((TreeObject)treeObject, consumer);
        });
        this.buildCrateRecipes(consumer);
        this.buildTreeBreedingRecipes(consumer);
        this.buildVanillaSawmillRecipes(consumer);
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("treetap")).setRecipe(arg_0 -> ((TreetapRecipeBuilder)TreetapRecipeBuilder.direct((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", "socotra_dragon_log")), new ItemStack((ItemLike)TreeRegistrator.DRACAENA_SAP.get()), new ItemStack((ItemLike)Items.f_42590_), "#9d0300", 1200)).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "treetap/dracaena_sap"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("treetap")).setRecipe(arg_0 -> ((TreetapRecipeBuilder)TreetapRecipeBuilder.direct((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", "sandalwood_log")), new ItemStack((ItemLike)TreeRegistrator.SANDALWOOD_OIL.get()), new ItemStack((ItemLike)Items.f_42590_), "#f1eda6", 2400)).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "treetap/sandalwood_oil"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("treetap")).setRecipe(arg_0 -> ((TreetapRecipeBuilder)TreetapRecipeBuilder.direct((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", "sugar_maple_log")), new ItemStack((ItemLike)TreeRegistrator.MAPLE_SAP_BUCKET.get()), new FluidStack((Fluid)TreeRegistrator.MAPLE_SAP.get(), 1000), 2400)).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "treetap/maple_sap"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("treetap")).setRecipe(arg_0 -> ((TreetapRecipeBuilder)TreetapRecipeBuilder.direct((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", "date_palm_log")), new ItemStack((ItemLike)TreeRegistrator.DATE_PALM_JUICE.get()), new ItemStack((ItemLike)Items.f_42590_), "#cd7408", 2400)).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "treetap/date_palm_juice"));
        TreeRegistrator.ROASTED_NUTS.forEach(cropConfig -> {
            Item roastedNut = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name()));
            Item rawNut = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name().replace("roasted_", "")));
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawNut}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNut, (float)0.1f, (int)120).m_126132_(RecipeProvider.m_176602_((ItemLike)rawNut), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)rawNut)).m_126140_(consumer, new ResourceLocation("productivetrees", "roasting/" + cropConfig.name() + "_smelting"));
            SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawNut}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNut, (float)0.1f, (int)20).m_126132_(RecipeProvider.m_176602_((ItemLike)rawNut), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)rawNut)).m_126140_(consumer, new ResourceLocation("productivetrees", "roasting/" + cropConfig.name() + "_smoking"));
            Item roastedNutCrate = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name() + "_crate"));
            Item rawNutCrate = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name().replace("roasted_", "") + "_crate"));
            if (rawNutCrate != null) {
                SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawNutCrate}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNutCrate, (float)0.9f, (int)1080).m_126132_(RecipeProvider.m_176602_((ItemLike)rawNutCrate), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)rawNutCrate)).m_126140_(consumer, new ResourceLocation("productivetrees", "roasting/" + cropConfig.name() + "_crate_smelting"));
                SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawNutCrate}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNutCrate, (float)0.9f, (int)180).m_126132_(RecipeProvider.m_176602_((ItemLike)rawNutCrate), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)rawNutCrate)).m_126140_(consumer, new ResourceLocation("productivetrees", "roasting/" + cropConfig.name() + "_crate_smoking"));
            }
        });
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TreeRegistrator.RUBBER.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TreeRegistrator.CURED_RUBBER.get()), (float)0.1f, (int)120).m_126132_(RecipeProvider.m_176602_((ItemLike)((ItemLike)TreeRegistrator.RUBBER.get())), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)((ItemLike)TreeRegistrator.RUBBER.get()))).m_126140_(consumer, new ResourceLocation("productivetrees", "cured_rubber"));
    }

    private static void planksFromLogs(Consumer<FinishedRecipe> consumer, ItemLike result, TagKey<Item> pLogs) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).m_126184_(Ingredient.m_204132_(pLogs)).m_126145_("planks").m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_206406_(pLogs)).m_126140_(consumer, RecipeProvider.prefixedRecipeId(result, "planks/"));
    }

    protected static void m_126002_(Consumer<FinishedRecipe> consumer, ItemLike pWood, ItemLike pLog) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pWood, (int)3).m_126127_(Character.valueOf('#'), pLog).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)pLog)).m_126140_(consumer, RecipeProvider.prefixedRecipeId(pWood, "wood/"));
    }

    private static void shapedVariant(Consumer<FinishedRecipe> consumer, BlockFamily.Variant variant, ItemLike result, ItemLike plank) {
        RecipeBuilder builder = (RecipeBuilder)((BiFunction)f_244077_.get(variant)).apply(result, plank);
        builder.m_126145_(variant.m_176020_());
        builder.m_126132_(RecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)plank));
        builder.m_126140_(consumer, RecipeProvider.prefixedRecipeId(result, variant.m_176020_() + "/"));
    }

    protected static void m_246977_(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike plank) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)6).m_126145_("hanging_sign").m_126127_(Character.valueOf('#'), plank).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42026_).m_126130_("X X").m_126130_("###").m_126130_("###").m_126132_("has_stripped_logs", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)plank)).m_126140_(consumer, RecipeProvider.prefixedRecipeId(result, "hanging_sign/"));
    }

    private static ResourceLocation prefixedRecipeId(ItemLike item, String prefix) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_247266_(path -> prefix + path);
    }

    private void buildSawmillRecipe(WoodObject treeObject, Consumer<FinishedRecipe> consumer) {
        String name = treeObject.getId().m_135815_();
        SawmillRecipeBuilder.tree(treeObject, (TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("productivetrees", treeObject.getId().m_135815_() + "_logs")), TreeUtil.getBlock(treeObject.getId(), "_planks")).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/" + name + "_planks_from_log"));
    }

    private void buildVanillaSawmillRecipes(Consumer<FinishedRecipe> consumer) {
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13184_), new ItemStack((ItemLike)Items.f_42647_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/oak_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13188_), new ItemStack((ItemLike)Items.f_42700_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/spruce_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13186_), new ItemStack((ItemLike)Items.f_42795_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/acacia_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13185_), new ItemStack((ItemLike)Items.f_42753_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/birch_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13187_), new ItemStack((ItemLike)Items.f_42794_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/jungle_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_271202_), new ItemStack((ItemLike)Items.f_271154_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/cherry_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_215869_), new ItemStack((ItemLike)Items.f_220174_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/mangrove_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13183_), new ItemStack((ItemLike)Items.f_42796_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/dark_oak_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13189_), new ItemStack((ItemLike)Items.f_42797_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/crimson_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.m_204132_((TagKey)ItemTags.f_13190_), new ItemStack((ItemLike)Items.f_42798_, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.f_41583_).m_126140_(consumer, new ResourceLocation("productivetrees", "sawmill/warped_planks_from_log"));
    }

    private void buildCrateRecipes(Consumer<FinishedRecipe> consumer) {
        TreeRegistrator.CRATED_CROPS.forEach(crate -> {
            String cropName = crate.m_135815_().replace("_crate", "");
            Item crateItem = (Item)ForgeRegistries.ITEMS.getValue(crate);
            Item cropItem = (Item)ForgeRegistries.ITEMS.getValue(crate.m_247266_(p -> cropName));
            TagKey cropTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "fruits/" + ItemTagProvider.tagName(cropName)));
            if (TreeRegistrator.BERRIES.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0) {
                cropTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "berries/" + ItemTagProvider.tagName(cropName)));
            } else if (TreeRegistrator.NUTS.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0 || TreeRegistrator.ROASTED_NUTS.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0) {
                cropTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuts/" + ItemTagProvider.tagName(cropName)));
            }
            if (cropName.equals("red_delicious_apple")) {
                cropItem = Items.f_42410_;
                cropTag = null;
            }
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)cropItem, (int)9).m_126132_(RecipeProvider.m_176602_((ItemLike)cropItem), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)cropItem)).m_126209_((ItemLike)crateItem).m_126140_(consumer, new ResourceLocation("productivetrees", "crates/" + crate.m_135815_() + "_unpack"));
            ShapedRecipeBuilder rBuilder = ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)crateItem).m_126132_(RecipeProvider.m_176602_((ItemLike)cropItem), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)cropItem)).m_126130_("###").m_126130_("#R#").m_126130_("###").m_126127_(Character.valueOf('R'), (ItemLike)cropItem);
            if (cropTag != null) {
                rBuilder.m_206416_(Character.valueOf('#'), cropTag);
            } else {
                rBuilder.m_126127_(Character.valueOf('#'), (ItemLike)cropItem);
            }
            rBuilder.m_126140_(consumer, new ResourceLocation("productivetrees", "crates/" + crate.m_135815_()));
        });
    }

    private void buildCorailWoodcutterRecipes(WoodObject treeObject, Consumer<FinishedRecipe> consumer) {
        String name = treeObject.getId().m_135815_();
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks"), 4).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_planks_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_button"), 4).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_button_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence"), 4).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_fence_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence_gate"), 1).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_fence_gate_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_pressure_plate"), 4).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_pressure_plate_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_slab"), 8).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_slab_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_stairs"), 4).m_126132_("has_logs", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_log"), TreeUtil.getBlock(treeObject.getId(), "_wood"), TreeUtil.getBlock(treeObject.getId(), "_stripped_log"), TreeUtil.getBlock(treeObject.getId(), "_stripped_wood")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_stairs_from_logs"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_button"), 1).m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_button_from_planks"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence"), 1).m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_fence_from_planks"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_pressure_plate"), 1).m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_pressure_plate_from_planks"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_slab"), 2).m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_slab_from_planks"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).setRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_stairs"), 1).m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")}).m_45077_()}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "corail/woodcutter/" + name + "_stairs_from_planks"));
    }

    private static SingleItemRecipeBuilder woodcutter(Ingredient ingredient, ItemLike output, int count) {
        return new SingleItemRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, ModRecipeSerializers.WOODCUTTING, ingredient, output, count);
    }

    private void buildBotanyPotsRecipe(final TreeObject treeObject, Consumer<FinishedRecipe> consumer) {
        ItemStack fruit;
        String name = treeObject.getId().m_135815_();
        ArrayList<HarvestEntry> drops = new ArrayList<HarvestEntry>(){
            {
                this.add(new HarvestEntry(1.0f, new ItemStack((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_log")), 2, 4));
                this.add(new HarvestEntry(0.1f, new ItemStack((ItemLike)Items.f_42398_), 1, 2));
                this.add(new HarvestEntry(0.15f, new ItemStack((ItemLike)TreeUtil.getBlock(treeObject.getId(), "_sapling")), 1, 1));
            }
        };
        if (treeObject.hasFruit() && !(fruit = treeObject.getFruit().getItem()).m_41619_()) {
            drops.add(new HarvestEntry(treeObject.getFruit().growthSpeed(), new ItemStack((ItemLike)fruit.m_41720_()), 1, fruit.m_41613_()));
        }
        SingleConditionalRecipe.builder().addCondition(this.modLoaded("botanytrees")).setRecipe(arg_0 -> ((BotanyPotCropRecipeBuilder)BotanyPotCropRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_sapling")}), Set.of("dirt"), 2400, (List<HarvestEntry>)drops, TreeUtil.getBlock(treeObject.getId(), "_sapling").m_49966_(), 0)).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "botanytrees/" + name));
    }

    private void buildTreeBreedingRecipes(Consumer<FinishedRecipe> consumer) {
        RecipeProvider.treeBreeding(consumer, "silver_lime", Blocks.f_50050_, Blocks.f_50052_, 15);
        RecipeProvider.treeBreeding(consumer, "cacao", Blocks.f_50053_, Blocks.f_271115_, 15);
        RecipeProvider.treeBreeding(consumer, "walnut", "silver_lime", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 10);
        RecipeProvider.treeBreeding(consumer, "sweet_chestnut", "walnut", RecipeProvider.getLeafIngredient("wild_cherry", "silver_lime"), 10);
        RecipeProvider.treeBreeding(consumer, "european_larch", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50051_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50052_}), 10);
        RecipeProvider.treeBreeding(consumer, "sugar_maple", "european_larch", "red_maple", 5);
        RecipeProvider.treeBreeding(consumer, "citron", "silver_lime", "sour_cherry", 5);
        RecipeProvider.treeBreeding(consumer, "plum", "citron", "wild_cherry", 5);
        RecipeProvider.treeBreeding(consumer, "bull_pine", "european_larch", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50051_}), 10);
        RecipeProvider.treeBreeding(consumer, "sequoia", "european_larch", "bull_pine", 5);
        RecipeProvider.treeBreeding(consumer, "teak", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50055_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50053_}), 10);
        RecipeProvider.treeBreeding(consumer, "ipe", "teak", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50055_}), 10);
        RecipeProvider.treeBreeding(consumer, "aquilaria", "teak", "ipe", 10);
        RecipeProvider.treeBreeding(consumer, "kapok", "teak", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50053_}), 10);
        RecipeProvider.treeBreeding(consumer, "ceylon_ebony", "kapok", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50055_}), 10);
        RecipeProvider.treeBreeding(consumer, "purple_crepe_myrtle", "ceylon_ebony", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 5);
        RecipeProvider.treeBreeding(consumer, "zebrano", "white_poplar", "ceylon_ebony", 5);
        RecipeProvider.treeBreeding(consumer, "yellow_meranti", "ceylon_ebony", "kapok", 10);
        RecipeProvider.treeBreeding(consumer, "mahogany", "yellow_meranti", "kapok", 10);
        RecipeProvider.treeBreeding(consumer, "padauk", "red_maple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50053_}), 5);
        RecipeProvider.treeBreeding(consumer, "dogwood", "silver_lime", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 5);
        RecipeProvider.treeBreeding(consumer, "balsa", "teak", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50054_}), 10);
        RecipeProvider.treeBreeding(consumer, "cocobolo", "balsa", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50055_}), 10);
        RecipeProvider.treeBreeding(consumer, "wenge", "balsa", "cocobolo", 10);
        RecipeProvider.treeBreeding(consumer, "socotra_dragon", "wenge", "cocobolo", 10);
        RecipeProvider.treeBreeding(consumer, "grandidiers_baobab", "balsa", "wenge", 10);
        RecipeProvider.treeBreeding(consumer, "blue_mahoe", "teak", "balsa", 5);
        RecipeProvider.treeBreeding(consumer, "white_willow", "silver_lime", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50050_, Blocks.f_50052_}), 5);
        RecipeProvider.treeBreeding(consumer, "greenheart", "mahogany", "kapok", 10);
        RecipeProvider.treeBreeding(consumer, "papaya", "wild_cherry", "cacao", 5);
        RecipeProvider.treeBreeding(consumer, "date_palm", "papaya", "cacao", 5);
        RecipeProvider.treeBreeding(consumer, "asai_palm", "date_palm", "black_cherry", 5);
        RecipeProvider.treeBreeding(consumer, "persimmon", "ceylon_ebony", Ingredient.m_43929_((ItemLike[])new ItemLike[]{RecipeProvider.getLeafIngredient("purple_crepe_myrtle", "moonlight_magic_crepe_myrtle", "red_crepe_myrtle", "tuscarora_crepe_myrtle").m_43908_()[0].m_41720_()}), 5);
        RecipeProvider.treeBreeding(consumer, "myrtle_ebony", "ceylon_ebony", "persimmon", 5);
        RecipeProvider.treeBreeding(consumer, "pomegranate", "holly", Ingredient.m_43929_((ItemLike[])new ItemLike[]{RecipeProvider.getLeafIngredient("purple_crepe_myrtle", "moonlight_magic_crepe_myrtle", "red_crepe_myrtle", "tuscarora_crepe_myrtle").m_43908_()[0].m_41720_()}), 5);
        RecipeProvider.treeBreeding(consumer, "white_poplar", "white_willow", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50050_, Blocks.f_50052_, RecipeProvider.getLeafIngredient("silver_lime").m_43908_()[0].m_41720_()}), 5);
        RecipeProvider.treeBreeding(consumer, "red_delicious_apple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50050_, Blocks.f_50055_}), 10);
        RecipeProvider.treeBreeding(consumer, "granny_smith_apple", "red_delicious_apple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 10);
        RecipeProvider.treeBreeding(consumer, "golden_delicious_apple", "red_delicious_apple", "granny_smith_apple", 10);
        RecipeProvider.treeBreeding(consumer, "beliy_naliv_apple", "golden_delicious_apple", "granny_smith_apple", 10);
        RecipeProvider.treeBreeding(consumer, "sweet_crabapple", "red_delicious_apple", "sugar_maple", 10);
        RecipeProvider.treeBreeding(consumer, "flowering_crabapple", "sweet_crabapple", Blocks.f_152471_, 10);
        RecipeProvider.treeBreeding(consumer, "prairie_crabapple", "red_delicious_apple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50052_}), 10);
        RecipeProvider.treeBreeding(consumer, "blackthorn", "plum", "red_delicious_apple", 10);
        RecipeProvider.treeBreeding(consumer, "cherry_plum", "plum", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 10);
        RecipeProvider.treeBreeding(consumer, "peach", "plum", "sweet_chestnut", 10);
        RecipeProvider.treeBreeding(consumer, "nectarine", "plum", "peach", 10);
        RecipeProvider.treeBreeding(consumer, "apricot", "plum", "peach", 10);
        RecipeProvider.treeBreeding(consumer, "almond", "plum", "walnut", 10);
        RecipeProvider.treeBreeding(consumer, "wild_cherry", "silver_lime", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 10);
        RecipeProvider.treeBreeding(consumer, "sour_cherry", "white_willow", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_271115_}), 10);
        RecipeProvider.treeBreeding(consumer, "black_cherry", "ceylon_ebony", "sour_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "orange", "mandarin", "pomelo", 10);
        RecipeProvider.treeBreeding(consumer, "mandarin", "pomelo", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "tangerine", "mandarin", "kumquat", 10);
        RecipeProvider.treeBreeding(consumer, "satsuma", "mandarin", "kumquat", 10);
        RecipeProvider.treeBreeding(consumer, "lime", "pomelo", "key_lime", 10);
        RecipeProvider.treeBreeding(consumer, "key_lime", "citron", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "finger_lime", "citron", "key_lime", 10);
        RecipeProvider.treeBreeding(consumer, "pomelo", "citron", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "grapefruit", "pomelo", "orange", 10);
        RecipeProvider.treeBreeding(consumer, "kumquat", "mandarin", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "lemon", "pomelo", "citron", 10);
        RecipeProvider.treeBreeding(consumer, "buddhas_hand", "mandarin", "citron", 10);
        RecipeProvider.treeBreeding(consumer, "banana", "balsa", "cacao", 10);
        RecipeProvider.treeBreeding(consumer, "red_banana", "banana", "kapok", 10);
        RecipeProvider.treeBreeding(consumer, "plantain", "banana", "teak", 10);
        RecipeProvider.treeBreeding(consumer, "butternut", "walnut", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "rowan", "aspen", "alder", 10);
        RecipeProvider.treeBreeding(consumer, "western_hemlock", "bull_pine", "silver_fir", 3);
        RecipeProvider.treeBreeding(consumer, "ash", "silver_lime", Blocks.f_50051_, 10);
        RecipeProvider.treeBreeding(consumer, "alder", "beech", Blocks.f_50052_, 10);
        RecipeProvider.treeBreeding(consumer, "beech", Blocks.f_50050_, Blocks.f_50052_, 10);
        RecipeProvider.treeBreeding(consumer, "aspen", "beech", "alder", 10);
        RecipeProvider.treeBreeding(consumer, "yew", "european_larch", Blocks.f_50051_, 10);
        RecipeProvider.treeBreeding(consumer, "lawson_cypress", "bull_pine", Blocks.f_50051_, 10);
        RecipeProvider.treeBreeding(consumer, "cork_oak", "lawson_cypress", Blocks.f_50050_, 10);
        RecipeProvider.treeBreeding(consumer, "douglas_fir", "silver_fir", Blocks.f_50051_, 10);
        RecipeProvider.treeBreeding(consumer, "hazel", "aspen", "beech", 10);
        RecipeProvider.treeBreeding(consumer, "sycamore_fig", "ash", "sugar_maple", 10);
        RecipeProvider.treeBreeding(consumer, "breadfruit", "sycamore_fig", "sugar_maple", 10);
        RecipeProvider.treeBreeding(consumer, "cempedak", "sycamore_fig", "breadfruit", 10);
        RecipeProvider.treeBreeding(consumer, "jackfruit", "cempedak", "breadfruit", 10);
        RecipeProvider.treeBreeding(consumer, "whitebeam", "ash", Blocks.f_50052_, 10);
        RecipeProvider.treeBreeding(consumer, "hawthorn", "rowan", "beech", 10);
        RecipeProvider.treeBreeding(consumer, "pecan", "beech", Blocks.f_50052_, 10);
        RecipeProvider.treeBreeding(consumer, "sugar_apple", "pecan", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "soursop", "sugar_apple", "banana", 10);
        RecipeProvider.treeBreeding(consumer, "elm", "ash", "silver_lime", 10);
        RecipeProvider.treeBreeding(consumer, "elderberry", "aspen", "alder", 10);
        RecipeProvider.treeBreeding(consumer, "holly", "alder", "rowan", 10);
        RecipeProvider.treeBreeding(consumer, "hornbeam", "ash", "whitebeam", 10);
        RecipeProvider.treeBreeding(consumer, "great_sallow", "white_willow", "aspen", 10);
        RecipeProvider.treeBreeding(consumer, "silver_fir", "balsam_fir", "bull_pine", 10);
        RecipeProvider.treeBreeding(consumer, "cedar", "silver_fir", "european_larch", 10);
        RecipeProvider.treeBreeding(consumer, "olive", "alder", "wild_cherry", 10);
        RecipeProvider.treeBreeding(consumer, "red_maple", "silver_lime", "european_larch", 10);
        RecipeProvider.treeBreeding(consumer, "balsam_fir", "alder", "european_larch", 10);
        RecipeProvider.treeBreeding(consumer, "loblolly_pine", "bull_pine", Blocks.f_50051_, 10);
        RecipeProvider.treeBreeding(consumer, "sweetgum", "european_larch", "sugar_maple", 10);
        RecipeProvider.treeBreeding(consumer, "rubber_tree", "sweetgum", "loblolly_pine", 10);
        RecipeProvider.treeBreeding(consumer, "black_locust", "balsa", "silver_lime", 10);
        RecipeProvider.treeBreeding(consumer, "sand_pear", "red_delicious_apple", Blocks.f_152471_, 10);
        RecipeProvider.treeBreeding(consumer, "cultivated_pear", "red_delicious_apple", "sand_pear", 10);
        RecipeProvider.treeBreeding(consumer, "osange_orange", "kapok", "old_fustic", 10);
        RecipeProvider.treeBreeding(consumer, "old_fustic", "red_maple", "mahogany", 10);
        RecipeProvider.treeBreeding(consumer, "brazilwood", "teak", "mahogany", 10);
        RecipeProvider.treeBreeding(consumer, "sandalwood", "brazilwood", "mahogany", 10);
        RecipeProvider.treeBreeding(consumer, "logwood", "kapok", "rosewood", 10);
        RecipeProvider.treeBreeding(consumer, "rosewood", "mahogany", "teak", 10);
        RecipeProvider.treeBreeding(consumer, "purpleheart", "brazilwood", "kapok", 10);
        RecipeProvider.treeBreeding(consumer, "iroko", "balsa", "teak", 10);
        RecipeProvider.treeBreeding(consumer, "ginkgo", "wenge", "silver_lime", 10);
        RecipeProvider.treeBreeding(consumer, "brazil_nut", "beech", "cacao", 10);
        RecipeProvider.treeBreeding(consumer, "rose_gum", "balsa", Blocks.f_152471_, 10);
        RecipeProvider.treeBreeding(consumer, "swamp_gum", "yellow_meranti", "rose_gum", 10);
        RecipeProvider.treeBreeding(consumer, "boxwood", "holly", "alder", 10);
        RecipeProvider.treeBreeding(consumer, "coffea", "black_cherry", "cacao", 10);
        RecipeProvider.treeBreeding(consumer, "clove", "coffea", "teak", 10);
        RecipeProvider.treeBreeding(consumer, "monkey_puzzle", "western_hemlock", Blocks.f_50053_, 10);
        RecipeProvider.treeBreeding(consumer, "rainbow_gum", "balsa", "rose_gum", 10);
        RecipeProvider.treeBreeding(consumer, "pink_ivory", "brazilwood", "rose_gum", 10);
        RecipeProvider.treeBreeding(consumer, "juniper", "elderberry", "silver_fir", 10);
        RecipeProvider.treeBreeding(consumer, "cinnamon", "rosewood", "teak", 10);
        RecipeProvider.treeBreeding(consumer, "coconut", "brazil_nut", "balsa", 10);
        RecipeProvider.treeBreeding(consumer, "cashew", "teak", Blocks.f_220838_, 10);
        RecipeProvider.treeBreeding(consumer, "pistachio", "almond", "cashew", 10);
        RecipeProvider.treeBreeding(consumer, "avocado", "wenge", Blocks.f_50050_, 10);
        RecipeProvider.treeBreeding(consumer, "nutmeg", "teak", "clove", 10);
        RecipeProvider.treeBreeding(consumer, "allspice", "teak", "clove", 10);
        RecipeProvider.treeBreeding(consumer, "star_anise", "clove", "allspice", 10);
        RecipeProvider.treeBreeding(consumer, "mango", "orange", Blocks.f_220838_, 10);
        RecipeProvider.treeBreeding(consumer, "star_fruit", "mango", "star_anise", 10);
        RecipeProvider.treeBreeding(consumer, "candlenut", "ginkgo", "hazel", 10);
        RecipeProvider.treeBreeding(consumer, "copoazu", "cacao", "candlenut", 10);
        RecipeProvider.treeBreeding(consumer, "carob", "sweet_chestnut", "copoazu", 10);
        RecipeProvider.treeBreeding(consumer, "pandanus", "walnut", "coconut", 10);
        RecipeProvider.treeBreeding(consumer, "salak", "pandanus", "coconut", 10);
        RecipeProvider.treeBreeding(consumer, "purple_spiral", "blue_yonder", "firecracker", 5);
        RecipeProvider.treeBreeding(consumer, "cave_dweller", "black_ember", "soul_tree", 5);
        RecipeProvider.treeBreeding(consumer, "foggy_blast", "cave_dweller", "soul_tree", 5);
        RecipeProvider.treeBreeding(consumer, "night_fuchsia", "purple_spiral", "sparkle_cherry", 5);
        RecipeProvider.treeBreeding(consumer, "time_traveller", "blue_yonder", "rippling_willow", 5);
        RecipeProvider.treeBreeding(consumer, "sparkle_cherry", "firecracker", "soul_tree", 5);
        RecipeProvider.treeBreeding(consumer, "slimy_delight", "rippling_willow", "soul_tree", 5);
        RecipeProvider.treeBreeding(consumer, "thunder_bolt", "firecracker", "flickering_sun", 5);
        RecipeProvider.treeBreeding(consumer, "rippling_willow", "blue_yonder", "flickering_sun", 5);
        RecipeProvider.treeBreeding(consumer, "water_wonder", "blue_yonder", "soul_tree", 5);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, String leafA, String leafB, int chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", leafB + "_leaves")), chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, String leafA, Block leafB, int chance) {
        RecipeProvider.treeBreeding(consumer, name, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", leafA + "_leaves")), leafB, chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, String leafA, Ingredient leafB, int chance) {
        RecipeProvider.treeBreeding(consumer, name, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", leafA + "_leaves"))}), leafB, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", name + "_sapling"))}), chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, Ingredient leafA, Ingredient leafB, int chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", name + "_sapling"))}), chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, Block leafA, Block leafB, int chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, name, chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, Block leafA, Block leafB, String saplingName, int chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", saplingName + "_sapling")), chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, Block leafA, Block leafB, Block result, int chance) {
        RecipeProvider.treeBreeding(consumer, name, Ingredient.m_43929_((ItemLike[])new ItemLike[]{leafA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{leafB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{result}), chance);
    }

    public static void treeBreeding(Consumer<FinishedRecipe> consumer, String name, Ingredient leafA, Ingredient leafB, Ingredient result, int chance) {
        if (leafA.m_43947_()) {
            throw new RuntimeException("Empty leafA for tree " + name);
        }
        if (leafB.m_43947_()) {
            throw new RuntimeException("Empty leafB for tree " + name);
        }
        if (result.m_43947_()) {
            throw new RuntimeException("Empty result for tree " + name);
        }
        TreePollinationRecipeBuilder.direct(leafA, leafB, result, chance).m_126140_(consumer, new ResourceLocation("productivetrees", "pollination/" + name));
    }

    private static Ingredient getLeafIngredient(String ... treeNames) {
        Stream<ItemStack> leaves = Arrays.stream(treeNames).map(s -> new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", s + "_leaves"))));
        return Ingredient.m_43921_(leaves);
    }

    public void buildHiveRecipe(String modid, WoodObject treeObject, Consumer<FinishedRecipe> consumer) {
        Block hive = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "advanced_" + p + "_beehive"));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded(modid)).setRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126130_("WWW").m_126130_("CHC").m_126130_("FWS").m_126124_(Character.valueOf('W'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_planks")})).m_126124_(Character.valueOf('H'), Ingredient.m_204132_((TagKey)ModTags.Forge.HIVES)).m_126124_(Character.valueOf('C'), Ingredient.m_204132_((TagKey)ModTags.Forge.HONEYCOMBS)).m_126124_(Character.valueOf('F'), Ingredient.m_204132_((TagKey)ModTags.Forge.CAMPFIRES)).m_126124_(Character.valueOf('S'), Ingredient.m_204132_((TagKey)Tags.Items.SHEARS)).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "hives/" + ForgeRegistries.BLOCKS.getKey((Object)hive).m_135815_().replace("advanced_", "")));
        this.buildHiveResetRecipes(modid, hive, new ResourceLocation("productivetrees", "hives/" + ForgeRegistries.BLOCKS.getKey((Object)hive).m_135815_().replace("advanced_", "") + "_clear"), consumer);
    }

    public void buildBoxRecipe(String modid, WoodObject treeObject, Consumer<FinishedRecipe> consumer) {
        Block box = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "expansion_box_" + p));
        SingleConditionalRecipe.builder().addCondition(this.modLoaded(modid)).setRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).m_126145_("expansion_boxes").m_126130_("WWW").m_126130_("WCW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks")).m_126124_(Character.valueOf('C'), Ingredient.m_204132_((TagKey)ModTags.Forge.HONEYCOMBS)).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivetrees", "expansion_boxes/" + ForgeRegistries.BLOCKS.getKey((Object)box).m_135815_()));
    }

    private void buildHiveResetRecipes(String modid, Block hive, ResourceLocation location, Consumer<FinishedRecipe> consumer) {
        SingleConditionalRecipe.builder().addCondition(this.modLoaded(modid)).setRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126209_((ItemLike)hive)).m_176498_(arg_0)).build(consumer, location);
    }
}

