/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.ExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;

public class ExpansionBox
extends Block
implements EntityBlock {
    public static final BooleanProperty HAS_HONEY = BooleanProperty.m_61465_((String)"has_honey");
    private final Supplier<BlockEntityType<ExpansionBoxBlockEntity>> blockEntitySupplier;

    public ExpansionBox(BlockBehaviour.Properties properties, Supplier<BlockEntityType<ExpansionBoxBlockEntity>> blockEntitySupplier) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.NORTH)).m_61124_(AdvancedBeehive.EXPANDED, (Comparable)((Object)VerticalHive.NONE))).m_61124_((Property)HAS_HONEY, (Comparable)Boolean.valueOf(false)));
        this.blockEntitySupplier = blockEntitySupplier;
    }

    public Supplier<BlockEntityType<ExpansionBoxBlockEntity>> getBlockEntitySupplier() {
        return this.blockEntitySupplier;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BeehiveBlock.f_49563_, AdvancedBeehive.EXPANDED, HAS_HONEY});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ExpansionBoxBlockEntity(this, pos, state);
    }

    public void updateState(Level level, BlockPos pos, BlockState state, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        Pair<Pair<BlockPos, Direction>, BlockState> pair2 = pair = ((VerticalHive)((Object)state.m_61143_(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) ? ExpansionBox.getAdjacentHive(level, pos) : ExpansionBox.getAttachedHive(state, level, pos);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos hivePos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(level, hivePos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(level, pos, state, directionProperty, (Direction)((BlockState)pair.getRight()).m_61143_((Property)BeehiveBlock.f_49563_));
            }
            ((AdvancedBeehive)((BlockState)pair.getRight()).m_60734_()).updateStateWithDirection(level, hivePos, (BlockState)pair.getRight(), directionProperty);
        } else if (!isRemoved) {
            this.updateStateWithDirection(level, pos, state, VerticalHive.NONE, (Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        Pair posAndDirection;
        BlockPos hivePos;
        BlockEntity hiveTileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        ItemStack heldItem = player.m_21205_();
        if (level instanceof ServerLevel && heldItem.m_41720_().equals(Items.f_42398_) && !((VerticalHive)((Object)state.m_61143_(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (pair = ExpansionBox.getAttachedHive(state, level, pos)) != null && (hiveTileEntity = level.m_7702_(hivePos = (BlockPos)(posAndDirection = (Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveBlockEntityAbstract) {
            ((AdvancedBeehiveBlockEntityAbstract)hiveTileEntity).m_58748_(player, state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
        }
        super.m_6256_(state, level, pos, player);
    }

    public void updateStateWithDirection(Level level, BlockPos pos, BlockState state, VerticalHive directionProperty, Direction facing) {
        level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_(AdvancedBeehive.EXPANDED, (Comparable)((Object)directionProperty))).m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)facing));
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentHive(Level level, BlockPos pos) {
        for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
            BlockPos newPos = pos.m_121945_(direction);
            BlockState blockStateAtPos = level.m_8055_(newPos);
            Block blockAtPos = blockStateAtPos.m_60734_();
            if (!(blockAtPos instanceof AdvancedBeehive) || blockAtPos instanceof DragonEggHive) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAttachedHive(BlockState boxState, Level level, BlockPos pos) {
        VerticalHive expandDirection;
        Direction hiveDirection;
        BlockState blockStateAtPos;
        if (boxState.m_204336_(ModTags.BOXES_BLOCK) && (blockStateAtPos = level.m_8055_(pos.m_121945_(hiveDirection = (expandDirection = (VerticalHive)((Object)boxState.m_61143_(AdvancedBeehive.EXPANDED))).getExpandedCardinalDirection((Direction)boxState.m_61143_((Property)BeehiveBlock.f_49563_)).m_122424_()))).m_60734_() instanceof AdvancedBeehive && !(blockStateAtPos.m_60734_() instanceof DragonEggHive)) {
            return Pair.of((Object)Pair.of((Object)pos.m_121945_(hiveDirection), (Object)hiveDirection), (Object)blockStateAtPos);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.m_5776_()) {
            this.updateState(world, pos, state, false);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.m_5776_()) {
            this.updateState(world, pos, state, true);
        }
        return removed;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction dir;
        BlockEntity blockEntity;
        if (!level.f_46443_ && !((VerticalHive)((Object)state.m_61143_(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (blockEntity = level.m_7702_(pos.m_121945_(dir = ((VerticalHive)((Object)state.m_61143_(AdvancedBeehive.EXPANDED))).getExpandedCardinalDirection((Direction)state.m_61143_((Property)BeehiveBlock.f_49563_)).m_122424_()))) instanceof AdvancedBeehiveBlockEntity) {
            AdvancedBeehiveBlockEntity hiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity;
            ((AdvancedBeehive)level.m_8055_(pos.m_121945_(dir)).m_60734_()).openGui((ServerPlayer)player, hiveBlockEntity);
        }
        return InteractionResult.SUCCESS;
    }
}

