/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials.special.recipe.component;

import com.probejs.docs.formatter.SpecialTypes;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.typings.desc.ArrayDescJS;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.FixedArrayDescJS;
import dev.latvian.mods.kubejs.typings.desc.GenericDescJS;
import dev.latvian.mods.kubejs.typings.desc.ObjectDescJS;
import dev.latvian.mods.kubejs.typings.desc.OrDescJS;
import dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.tuple.Pair;

public class ComponentConverter {
    public static DescriptionContext PROBEJS_CONTEXT = new DescriptionContext(){

        public String typeName(Class<?> type) {
            return "$probejs$%s".formatted(type.getName());
        }
    };

    public static PropertyType<?> fromDescription(TypeDescJS description) {
        if (description instanceof ArrayDescJS) {
            ArrayDescJS array = (ArrayDescJS)description;
            return new PropertyType.Array(ComponentConverter.fromDescription(array.type()));
        }
        if (description instanceof FixedArrayDescJS) {
            FixedArrayDescJS fixedArray = (FixedArrayDescJS)description;
            return new PropertyType.JSArray(Arrays.stream(fixedArray.types()).map(ComponentConverter::fromDescription).collect(Collectors.toList()));
        }
        if (description instanceof GenericDescJS) {
            PrimitiveDescJS primitive;
            GenericDescJS parameterized = (GenericDescJS)description;
            Object object = parameterized.type();
            if (object instanceof PrimitiveDescJS && (primitive = (PrimitiveDescJS)object).type().equals("Map") && (object = ComponentConverter.fromDescription(parameterized.types()[0])) instanceof PropertyType.Native) {
                PropertyType.Native keyType = (PropertyType.Native)object;
                if (parameterized.types().length == 2) {
                    return new PropertyType.JSObject().add(new PropertyType.JSObjectKey().withType(keyType), ComponentConverter.fromDescription(parameterized.types()[1]));
                }
            }
            if ((object = parameterized.type()) instanceof PrimitiveDescJS && (primitive = (PrimitiveDescJS)object).type().equals("$probejs$" + TagKey.class.getName()) && (object = parameterized.types()[0]) instanceof PrimitiveDescJS) {
                PrimitiveDescJS registryType = (PrimitiveDescJS)object;
                try {
                    String special = SpecialTypes.getRegistryTagName(Class.forName(registryType.type().substring(9)));
                    if (special != null) {
                        return new PropertyType.Native(special);
                    }
                }
                catch (Exception special) {
                    // empty catch block
                }
            }
            return new PropertyType.Parameterized(ComponentConverter.fromDescription(parameterized.type()), Arrays.stream(parameterized.types()).map(ComponentConverter::fromDescription).collect(Collectors.toList()));
        }
        if (description instanceof ObjectDescJS) {
            ObjectDescJS object = (ObjectDescJS)description;
            return new PropertyType.JSObject(object.types().stream().map(pair -> Pair.of((Object)new PropertyType.JSObjectKey().withName(Util.getSafeName(pair.key())).optional(pair.optional()), ComponentConverter.fromDescription(pair.value()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        }
        if (description instanceof OrDescJS) {
            OrDescJS or = (OrDescJS)description;
            return new PropertyType.Union(Arrays.stream(or.types()).map(ComponentConverter::fromDescription).collect(Collectors.toList()));
        }
        if (description instanceof PrimitiveDescJS) {
            PrimitiveDescJS primitive = (PrimitiveDescJS)description;
            String name = primitive.type();
            if (name.equals("null")) {
                return new PropertyType.Clazz(Object.class);
            }
            if (name.startsWith("$probejs$")) {
                String clazzName = name.substring(9);
                try {
                    Class<?> clazz = Class.forName(clazzName);
                    int variables = clazz.getTypeParameters().length;
                    if (variables > 0) {
                        return new PropertyType.Parameterized(new PropertyType.Clazz(clazzName), Collections.nCopies(variables, new PropertyType.Clazz(Object.class)));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return new PropertyType.Clazz(clazzName);
            }
            return new PropertyType.Native(name);
        }
        return new PropertyType.Clazz(Object.class);
    }
}

