/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.features.rich.fluid;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.features.rich.ImageHelper;
import com.probejs.features.rich.fluid.FluidAttribute;
import com.probejs.util.json.JArray;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class RichFluidCompiler {
    public static void compile() throws IOException {
        JArray fluidArray = JArray.create().addAll(RegistryInfo.FLUID.entrySet().stream().map(Map.Entry::getValue).map(FluidAttribute::new).map(FluidAttribute::serialize));
        Path richFile = ProbePaths.WORKSPACE_SETTINGS.resolve("fluid-attributes.json");
        BufferedWriter writer = Files.newBufferedWriter(richFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)fluidArray.serialize()));
        writer.close();
    }

    public static void render(List<Pair<Fluid, Path>> fluids) throws IOException {
        RenderTarget frameBuffer = ImageHelper.init();
        for (Pair<Fluid, Path> pair : fluids) {
            NativeImage image = ImageHelper.getFromFluid((Fluid)pair.getFirst(), frameBuffer);
            image.m_85066_((Path)pair.getSecond());
            image.close();
            frameBuffer.m_83954_(false);
        }
        frameBuffer.m_83930_();
    }

    public static List<Pair<Fluid, Path>> resolve() {
        ArrayList<Pair<Fluid, Path>> fluids = new ArrayList<Pair<Fluid, Path>>();
        Registry registry = RegistryInfo.FLUID.getVanillaRegistry();
        for (Fluid fluid : registry) {
            String name;
            ResourceLocation id = registry.m_7981_((Object)fluid);
            if (id == null) continue;
            Path path = ProbePaths.RICH_FLUID.resolve(id.m_135827_());
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (path.resolve((name = id.m_135815_().replace("/", "_")) + ".png").toFile().exists()) continue;
            fluids.add((Pair<Fluid, Path>)Pair.of((Object)fluid, (Object)path.resolve(name + ".png")));
        }
        return fluids;
    }
}

