/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.probejs.ProbeCommands;
import com.probejs.ProbeConfig;
import com.probejs.features.repl.EvalManager;
import com.probejs.features.server.Server;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ProbeJSEvents {
    public static Server SERVER;
    public static MinecraftServer CURRENT_SERVER;

    private static void computeKubeJSObjectHash(MessageDigest digest) {
        RegistryInfo.MAP.values().stream().flatMap(info -> info.objects.keySet().stream().map(ResourceLocation::toString).map(s -> info.key.m_135782_() + "/" + s)).sorted().forEach(key -> digest.update(key.getBytes()));
    }

    private static void computeModHash(Mod mod, MessageDigest digest) {
        String idVersion = mod.getModId() + mod.getVersion();
        digest.update(idVersion.getBytes());
    }

    private static String byte2Hex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void worldCleanup(MinecraftServer server) {
        if (SERVER != null) {
            try {
                SERVER.stop();
                EvalManager.SERVER_SCRIPTS.reset();
                SERVER = null;
                CURRENT_SERVER = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void playerJoined(ServerPlayer player) {
        if (player.f_8924_.m_129792_() && player.m_20310_(2)) {
            if (ProbeConfig.INSTANCE.enabled && ProbeConfig.INSTANCE.interactive == 1) {
                try {
                    SERVER = new Server(ProbeConfig.INSTANCE.interactivePort);
                    SERVER.start();
                    player.m_213846_((Component)Component.m_237113_((String)"ProbeJS Websocket Server started."));
                }
                catch (Exception e) {
                    player.m_213846_((Component)Component.m_237113_((String)"Failed to start WebSocket server, probably the port is in use."));
                }
                CURRENT_SERVER = player.f_8924_;
            }
            if (!ProbeConfig.INSTANCE.shouldProbingAggressive()) {
                return;
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                for (Mod mod : Platform.getMods().stream().sorted(Comparator.comparing(Mod::getModId)).toList()) {
                    ProbeJSEvents.computeModHash(mod, digest);
                }
                ProbeJSEvents.computeKubeJSObjectHash(digest);
                String hash = ProbeJSEvents.byte2Hex(digest.digest());
                if (!hash.equals(ProbeConfig.getModHash())) {
                    ProbeConfig.writeModHash(hash);
                    ProbeConfig.INSTANCE.modChanged = true;
                    player.m_213846_((Component)Component.m_237113_((String)"Mod list has changed, dumping new docs..."));
                    ProbeCommands.triggerDump(player);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (ProbeConfig.INSTANCE.firstLoad) {
                player.m_213846_((Component)Component.m_237113_((String)"This is the first time you are running ProbeJS. An automatic dump will be triggered."));
                player.m_213846_((Component)Component.m_237113_((String)"ProbeJS now supports downloading of recipe schema scripts. These scripts are for adding recipe support for mods that don't have recipe support yet."));
                player.m_213846_((Component)Component.m_237113_((String)"To configure ProbeJS, open ").m_7220_((Component)Component.m_237113_((String)"this file").kjs$underlined().kjs$aqua().kjs$clickOpenFile(KubeJSPaths.CONFIG.resolve("probejs.json").toString())).m_7220_((Component)Component.m_237113_((String)".")));
                ProbeConfig.INSTANCE.noAggressiveProbing = true;
                ProbeConfig.INSTANCE.firstLoad = false;
                if (Platform.getMods().size() > 350) {
                    player.m_213846_((Component)Component.m_237113_((String)"There are more than 350 mods installed. Disabling some features to prevent lag..."));
                    ProbeConfig.INSTANCE.disableRecipeJsonDump = true;
                    player.m_213846_((Component)Component.m_237113_((String)"Recipe JSON dumps are disabled."));
                }
                ProbeConfig.INSTANCE.save();
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Aggressive probing is on. Remember to disable it in release!").kjs$red().kjs$underlined());
                player.m_213846_((Component)Component.m_237113_((String)"Use ").m_7220_((Component)Component.m_237113_((String)"/probejs configure toggle_aggressive").kjs$underlined().kjs$green().kjs$clickSuggestCommand("/probejs configure toggle_aggressive")).m_7220_((Component)Component.m_237113_((String)" to disable.").kjs$white()));
            }
        }
    }
}

