/*
 * Decompiled with CFR 0.152.
 */
package com.aidant.pizzadelight.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PizzaBlock
extends Block {
    private static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)3);
    private static final VoxelShape PIZZA_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    private final Supplier<Item> sliceItem;

    public PizzaBlock(BlockBehaviour.Properties properties, Supplier<Item> sliceItem) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
        this.sliceItem = sliceItem;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return PIZZA_SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, Level level, BlockPos pos) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        return (4 - bites) * 15 / 4;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!level.f_46443_) {
            ItemStack heldItem = player.m_21120_(hand);
            int bites = (Integer)state.m_61143_((Property)BITES);
            if (heldItem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/knives")))) {
                ItemStack dropStack = new ItemStack((ItemLike)this.sliceItem.get(), 2);
                PizzaBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
                heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                if (bites < 3) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    level.m_7471_(pos, false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return !level.m_46859_(belowPos);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.m_5776_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean isMoving) {
        if (!level.m_5776_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }
}

