/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class NumberFunctionConfigurator
extends ValueConfigurator<NumberFunction> {
    private NumberFunctionConfig config;
    private WidgetGroup group;

    public NumberFunctionConfigurator(String name, Supplier<NumberFunction> supplier, Consumer<NumberFunction> onUpdate, boolean forceUpdate, NumberFunctionConfig config) {
        super(name, supplier, onUpdate, (Object)NumberFunction.constant(Float.valueOf(config.defaultValue())), forceUpdate);
        this.config = config;
        if (this.value == null) {
            this.value = this.defaultValue;
        }
    }

    protected void onValueUpdate(NumberFunction newValue) {
        if (newValue == null) {
            newValue = (NumberFunction)this.defaultValue;
        }
        if (newValue == this.value || newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate((Object)newValue);
    }

    public void init(int width) {
        super.init(width);
        int w = width - this.leftWidth - 6 - this.rightWidth - 9;
        this.group = new WidgetGroup(this.leftWidth, 0, w, 15);
        this.addWidget((Widget)this.group);
        this.addWidget(new ButtonWidget(width - (this.tips.length > 0 ? 24 : 12), 2, 9, 9, (IGuiTexture)Icons.DOWN, cd -> {
            if (Editor.INSTANCE != null) {
                TreeBuilder.Menu menu = TreeBuilder.Menu.start();
                for (Class<? extends NumberFunction> type : this.config.types()) {
                    menu.leaf((IGuiTexture)(type == ((NumberFunction)this.value).getClass() ? Icons.CHECK : IGuiTexture.EMPTY), type.getSimpleName(), () -> {
                        if (type == ((NumberFunction)this.value).getClass()) {
                            return;
                        }
                        try {
                            NumberFunction newValue = (NumberFunction)type.getConstructor(NumberFunctionConfig.class).newInstance(this.config);
                            this.updateValue(newValue);
                            this.group.clearAllWidgets();
                            this.group.setSize(new Size(w, 15));
                            ((NumberFunction)this.value).createConfigurator(this.group, this);
                            this.computeLayout();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                Editor.INSTANCE.openMenu((double)(this.group.getPosition().x + width), (double)this.group.getPosition().y, menu);
            }
        }).setHoverTooltips(new String[]{"ldlib.gui.editor.tips.other"}));
        assert (this.value != null);
        ((NumberFunction)this.value).createConfigurator(this.group, this);
    }

    public void computeHeight() {
        super.computeHeight();
        this.setSize(new Size(this.getSize().width, this.group.getSize().height));
    }

    public void updateValue(NumberFunction value) {
        this.onValueUpdate(value);
        super.updateValue();
    }

    public NumberFunctionConfig getConfig() {
        return this.config;
    }
}

