/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunction3Configurator;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ConfigAccessor
public class NumberFunction3Accessor
extends TypesAccessor<NumberFunction3> {
    public NumberFunction3Accessor() {
        super(new Class[]{NumberFunction3.class});
    }

    public NumberFunction3 defaultValue(Field field, Class<?> type) {
        return new NumberFunction3(NumberFunction.constant(0), NumberFunction.constant(0), NumberFunction.constant(0));
    }

    public Configurator create(String name, Supplier<NumberFunction3> supplier, Consumer<NumberFunction3> consumer, boolean forceUpdate, Field field) {
        NumberFunction3Config config = field.getAnnotation(NumberFunction3Config.class);
        NumberFunction3 value = supplier.get();
        Consumer<NumberFunction> singleConsumer = number -> {
            NumberFunction3 previous = (NumberFunction3)supplier.get();
            consumer.accept(new NumberFunction3(config.affectX() ? (previous.x == number ? number : NumberFunction.copy(number)) : previous.x, config.affectY() ? (previous.y == number ? number : NumberFunction.copy(number)) : previous.y, config.affectZ() ? (previous.z == number ? number : NumberFunction.copy(number)) : previous.z));
        };
        Supplier<NumberFunction> singleSupplier = () -> {
            if (config.affectX()) {
                return ((NumberFunction3)supplier.get()).x;
            }
            if (config.affectY()) {
                return ((NumberFunction3)supplier.get()).y;
            }
            return ((NumberFunction3)supplier.get()).z;
        };
        if (config.allowSeperated()) {
            AtomicBoolean isSeperated = new AtomicBoolean(config.isSeperatedDefault());
            if (!NumberFunction.isEqual(value.x, value.y) || !NumberFunction.isEqual(value.y, value.z)) {
                isSeperated.set(true);
            }
            return new ConfiguratorSelectorConfigurator(name, false, isSeperated::get, isSeperated::set, (Object)isSeperated.get(), true, List.of(Boolean.valueOf(true), Boolean.valueOf(false)), v -> v != false ? "Separate Axes" : "All in one", (v, father) -> {
                if (v.booleanValue()) {
                    father.addConfigurators(new Configurator[]{new NumberFunction3Configurator("", supplier, consumer, forceUpdate, config)});
                } else {
                    singleConsumer.accept((NumberFunction)singleSupplier.get());
                    father.addConfigurators(new Configurator[]{new NumberFunctionConfigurator("", singleSupplier, singleConsumer, forceUpdate, config.common())});
                }
            });
        }
        if (config.isSeperatedDefault()) {
            return new NumberFunction3Configurator(name, supplier, consumer, forceUpdate, config);
        }
        return new NumberFunctionConfigurator(name, singleSupplier, singleConsumer, forceUpdate, config.common());
    }
}

