/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.core.mixins.accessor.MinecraftAccessor;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.FXObjectsList;
import com.lowdragmc.photon.gui.editor.ParticleScenePanel;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.joml.Vector3f;

public class ParticleInfoView
extends FloatViewWidget {
    public final ParticleScenePanel panel;

    public ParticleInfoView(ParticleScenePanel panel) {
        super(100, 100, 200, 135, false);
        this.panel = panel;
    }

    public String name() {
        return "particle_info";
    }

    public String group() {
        return "editor.fx";
    }

    public IGuiTexture getIcon() {
        return Icons.INFORMATION.copy();
    }

    public FXEditor getEditor() {
        return (FXEditor)this.editor;
    }

    public void initWidget() {
        super.initWidget();
        this.content.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_BLACK.rectTexture().setBottomRadius(5.0f), ColorPattern.GRAY.borderTexture(-1).setBottomRadius(5.0f)})});
        this.addButton("photon.gui.editor.fx_info.restart", this.panel::restartEmitters);
        this.addInformation("photon.gui.editor.fx_info.particles", () -> {
            IFXObject selected;
            FXObjectsList list = this.panel.getFxObjectsList();
            if (list != null && (selected = list.getSelected()) instanceof IParticleEmitter) {
                IParticleEmitter emitter = (IParticleEmitter)selected;
                return String.valueOf(emitter.getParticleAmount());
            }
            return "0";
        });
        this.addInformation("photon.gui.editor.fx_info.time", () -> {
            IFXObject selected;
            FXObjectsList list = this.panel.getFxObjectsList();
            if (list != null && (selected = list.getSelected()) instanceof IParticleEmitter) {
                IParticleEmitter emitter = (IParticleEmitter)selected;
                return "%.2f (s)".formatted(Float.valueOf((float)emitter.getAge() / 20.0f));
            }
            return "0 / 0";
        });
        this.content.addWidget((Widget)new ProgressWidget(() -> {
            IFXObject selected;
            FXObjectsList list = this.panel.getFxObjectsList();
            if (list != null && (selected = list.getSelected()) instanceof IParticleEmitter) {
                IParticleEmitter emitter = (IParticleEmitter)selected;
                return emitter.getT(Minecraft.m_91087_().m_91296_());
            }
            return 0.0;
        }, 3, this.content.widgets.size() * 15 + 3, 194, 10, new ProgressTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(5.0f).setRadius(5.0f), (IGuiTexture)ColorPattern.GREEN.rectTexture().setRadius(5.0f).setRadius(5.0f))));
        this.addInformation("photon.gui.editor.fx_info.cpu_time", () -> "%d us".formatted(this.panel.scene.getParticleManager().getCPUTime()));
        this.addInformation("photon.gui.editor.fx_info.frame_time", () -> "%d us".formatted(this.panel.scene.getParticleManager().getFrameTime()));
        this.addInformation("FPS", () -> MinecraftAccessor.getFps() + " fps");
        WidgetGroup group = this.addToggle("photon.gui.editor.fx_info.draggable", this.panel.project::isDraggable, this.panel.project::setDraggable);
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format((String)"photon.gui.editor.fx_info.draggable", (Object[])new Object[0])) + 6;
        group.addWidget((Widget)new ButtonWidget(textWidth + (194 - textWidth - 70) / 2, 0, 70, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f).setRadius(5.0f), new TextTexture("photon.gui.editor.fx_info.reset_pos").setWidth(194)}), cd -> this.panel.runtime.getRoot().updatePos(new Vector3f(0.5f, 2.0f, 0.5f))));
        this.addToggle("photon.gui.editor.fx_info.cull_box", this.panel.project::isRenderCullBox, this.panel.project::setRenderCullBox);
    }

    protected void addButton(String title, Runnable onClick) {
        int offsetY = this.content.widgets.size() * 15;
        this.content.addWidget((Widget)new ButtonWidget(3, offsetY + 3, 194, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f).setRadius(5.0f), new TextTexture(title).setWidth(194)}), cd -> onClick.run()));
    }

    protected WidgetGroup addToggle(String title, BooleanSupplier supplier, BooleanConsumer onClick) {
        int offsetY = this.content.widgets.size() * 15;
        WidgetGroup infoGroup = new WidgetGroup(3, offsetY + 3, 194, 10);
        infoGroup.addWidget((Widget)new LabelWidget(0, 0, title));
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format((String)title, (Object[])new Object[0])) + 6;
        infoGroup.addWidget((Widget)new SwitchWidget(textWidth, -1, 10, 10, (cd, pressed) -> onClick.accept(pressed.booleanValue())).setSupplier(supplier::getAsBoolean).setPressed(supplier.getAsBoolean()).setTexture((IGuiTexture)new ColorBorderTexture(-1, -1).setRadius(5.0f), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{new ColorBorderTexture(-1, -1).setRadius(5.0f), new ColorRectTexture(-1).setRadius(5.0f).scale(0.5f)})));
        this.content.addWidget((Widget)infoGroup);
        return infoGroup;
    }

    protected WidgetGroup addInformation(String title, Supplier<String> info) {
        int offsetY = this.content.widgets.size() * 15;
        WidgetGroup infoGroup = new WidgetGroup(3, offsetY + 3, 194, 10);
        infoGroup.addWidget((Widget)new LabelWidget(0, 0, title));
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format((String)title, (Object[])new Object[0])) + 6;
        infoGroup.addWidget((Widget)new ImageWidget(textWidth, 0, 194 - textWidth, 10, (IGuiTexture)new TextTexture().setWidth(194 - textWidth).setSupplier(info)));
        this.content.addWidget((Widget)infoGroup);
        return infoGroup;
    }
}

