/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.MeshData;
import com.mojang.datafixers.util.Either;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="mesh", group="resource")
public class MeshesResource
extends Resource<MeshData> {
    public static final String RESOURCE_NAME = "mesh";

    public MeshesResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/mesh"));
    }

    public String name() {
        return RESOURCE_NAME;
    }

    public void buildDefault() {
        this.addModelMesh("pedestal");
    }

    public void addModelMesh(String model) {
        MeshData mesh = new MeshData(LDLib.location((String)("block/" + model)));
        mesh.meshName = model;
        this.addBuiltinResource(model, mesh);
    }

    public ResourceContainer<MeshData, ImageWidget> createContainer(ResourcePanel panel) {
        ResourceContainer<MeshData, ImageWidget> container = new ResourceContainer<MeshData, ImageWidget>((Resource)this, panel){

            protected void renameResource() {
                if (this.selected != null) {
                    DialogWidget.showStringEditorDialog((WidgetGroup)Editor.INSTANCE, (String)(LocalizationUtils.format((String)"ldlib.gui.editor.tips.rename", (Object[])new Object[0]) + " " + LocalizationUtils.format((String)this.resource.name(), (Object[])new Object[0])), (String)this.resource.getResourceName(this.selected), s -> {
                        if (!((Boolean)this.selected.map(l -> this.resource.hasBuiltinResource(s), r -> this.resource.hasStaticResource(this.resource.getStaticResourceFile(s)))).booleanValue()) {
                            return false;
                        }
                        if (this.renamePredicate != null) {
                            return this.renamePredicate.test(s);
                        }
                        return true;
                    }, s -> {
                        if (s == null) {
                            return;
                        }
                        MeshData stored = (MeshData)this.resource.removeResource(this.selected);
                        if (stored != null) {
                            stored.meshName = s;
                            Either name = this.selected.mapBoth(l -> s, r -> this.resource.getStaticResourceFile(s));
                            this.resource.addResource(name, (Object)stored);
                        }
                        this.reBuild();
                    });
                }
            }
        };
        container.setWidgetSupplier(k -> new ImageWidget(0, 0, 30, 30, (IGuiTexture)Icons.MESH.copy())).setDragging(arg_0 -> ((MeshesResource)this).getResource(arg_0), r -> Icons.MESH.copy()).setOnEdit(k -> panel.getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, (IConfigurable)this.getResource((Either)k))).setOnAdd(key -> new MeshData());
        return container;
    }

    public Tag serialize(MeshData value) {
        return value.serializeNBT();
    }

    public MeshData deserialize(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            MeshData mesh = new MeshData();
            mesh.deserializeNBT(tag);
            return mesh;
        }
        return null;
    }
}

