/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.BlockTextureSheetMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.CustomShaderMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.IMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.TextureMaterial;
import com.lowdragmc.photon.gui.editor.MaterialsResourceContainer;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

@LDLRegister(name="material", group="resource")
public class MaterialsResource
extends Resource<IMaterial> {
    public static final String RESOURCE_NAME = "material";

    public MaterialsResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/material"));
    }

    public String name() {
        return RESOURCE_NAME;
    }

    public void buildDefault() {
        this.addVanillaTextureMaterial("angry");
        this.addVanillaTextureMaterial("bubble");
        this.addVanillaTextureMaterial("damage");
        this.addVanillaTextureMaterial("flame");
        this.addVanillaTextureMaterial("glow");
        this.addVanillaTextureMaterial("heart");
        this.addVanillaTextureMaterial("lava");
        this.addVanillaTextureMaterial("note");
        this.addBuiltinTextureMaterial("kila_tail");
        this.addBuiltinTextureMaterial("laser");
        this.addBuiltinTextureMaterial("smoke");
        this.addBuiltinTextureMaterial("thaumcraft");
        this.addBuiltinTextureMaterial("ring");
        this.addBuiltinShaderMaterial("circle");
        this.addBuiltinResource("block_texture_sheet", new BlockTextureSheetMaterial());
    }

    private void addVanillaTextureMaterial(String name) {
        this.addBuiltinResource(name, new TextureMaterial(new ResourceLocation("textures/particle/%s.png".formatted(name))));
    }

    private void addBuiltinTextureMaterial(String name) {
        this.addBuiltinResource(name, new TextureMaterial(new ResourceLocation("photon:textures/particle/%s.png".formatted(name))));
    }

    private void addBuiltinShaderMaterial(String name) {
        this.addBuiltinResource(name, new CustomShaderMaterial(new ResourceLocation("photon:%s".formatted(name))));
    }

    public ResourceContainer<IMaterial, ImageWidget> createContainer(ResourcePanel panel) {
        return new MaterialsResourceContainer(this, panel);
    }

    public Tag serialize(IMaterial value) {
        return value.serializeNBT();
    }

    public IMaterial deserialize(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            String type = tag.m_128461_("_type");
            for (Class<? extends IMaterial> clazz : IMaterial.MATERIALS) {
                if (!type.equals(clazz.getSimpleName())) continue;
                try {
                    IMaterial mat = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    mat.deserializeNBT((Tag)tag);
                    return mat;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }
}

