/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.GradientColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.GradientColor;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.GradientColorTexture;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradientColorTexture;
import com.mojang.datafixers.util.Either;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="gradients", group="resource")
public class GradientsResource
extends Resource<Gradients> {
    public static final String RESOURCE_NAME = "gradients";

    public GradientsResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/gradients"));
    }

    public String name() {
        return RESOURCE_NAME;
    }

    public void buildDefault() {
        this.addBuiltinResource("black white", new Gradients(new GradientColor(new int[]{-16777216, -1})));
        this.addBuiltinResource("gradient", new Gradients(new GradientColor(new int[]{0xFFFFFF, -1, 0xFFFFFF})));
        this.addBuiltinResource("rainbow", new Gradients(new GradientColor(new int[]{-65536, -23296, -256, -16711936, -16744449, -16776961, -7667457})));
        this.addBuiltinResource("random", new Gradients(new GradientColor(new int[]{-1, -1}), new GradientColor(new int[]{-16777216, -16777216})));
    }

    @Nullable
    public Tag serialize(Gradients gradients) {
        return gradients.serializeNBT();
    }

    public Gradients deserialize(Tag tag) {
        Gradients gradients = new Gradients();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            gradients.deserializeNBT(compoundTag);
        }
        return gradients;
    }

    public ResourceContainer<Gradients, ? extends Widget> createContainer(ResourcePanel panel) {
        ResourceContainer<Gradients, ImageWidget> container = new ResourceContainer<Gradients, ImageWidget>((Resource)this, panel){

            protected TreeBuilder.Menu getMenu() {
                return super.getMenu().leaf((IGuiTexture)Icons.ADD_FILE, "add gradient", () -> {
                    String randomName = this.genNewFileName();
                    this.resource.addBuiltinResource(randomName, (Object)new Gradients());
                    this.reBuild();
                }).leaf((IGuiTexture)Icons.ADD_FILE, "add random gradient", () -> {
                    String randomName = this.genNewFileName();
                    this.resource.addBuiltinResource(randomName, (Object)new Gradients(new GradientColor(), new GradientColor(new int[]{-16777216})));
                    this.reBuild();
                });
            }
        };
        container.setWidgetSupplier(k -> new ImageWidget(0, 0, 60, 15, (IGuiTexture)(((Gradients)this.getResource((Either)k)).isRandomGradient() ? new RandomGradientColorTexture(((Gradients)this.getResource((Either)k)).gradient0, ((Gradients)this.getResource((Either)k)).gradient1) : new GradientColorTexture(((Gradients)this.getResource((Either)k)).gradient0)))).setDragging(arg_0 -> ((GradientsResource)this).getResource(arg_0), gradients -> gradients.isRandomGradient() ? new RandomGradientColorTexture(gradients.gradient0, gradients.gradient1) : new GradientColorTexture(gradients.gradient0)).setOnEdit(arg_0 -> this.lambda$createContainer$2((ResourceContainer)container, arg_0));
        return container;
    }

    private void openConfigurator(ResourceContainer<Gradients, ImageWidget> container, final Either<String, File> key) {
        container.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, new IConfigurable(){

            public void buildConfigurator(ConfiguratorGroup father) {
                Gradients curves = (Gradients)GradientsResource.this.getResource(key);
                if (curves.isRandomGradient()) {
                    father.addConfigurators(new Configurator[]{new WrapperConfigurator("gradient0", (Widget)new GradientColorWidget(0, 0, 180, curves.gradient0)), new WrapperConfigurator("gradient1", (Widget)new GradientColorWidget(0, 0, 180, curves.gradient1))});
                } else {
                    father.addConfigurators(new Configurator[]{new WrapperConfigurator("gradient", (Widget)new GradientColorWidget(0, 0, 180, curves.gradient0))});
                }
            }
        });
    }

    private /* synthetic */ void lambda$createContainer$2(ResourceContainer container, Either k) {
        this.openConfigurator((ResourceContainer<Gradients, ImageWidget>)container, (Either<String, File>)k);
    }

    public static class Gradients
    implements ITagSerializable<CompoundTag> {
        @Nonnull
        public GradientColor gradient0;
        @Nullable
        public GradientColor gradient1;

        public Gradients(@Nonnull GradientColor gradient0, @Nullable GradientColor gradient1) {
            this.gradient0 = gradient0;
            this.gradient1 = gradient1;
        }

        public Gradients(@Nonnull GradientColor gradient0) {
            this(gradient0, null);
        }

        public Gradients() {
            this(new GradientColor(), null);
        }

        public boolean isRandomGradient() {
            return this.gradient1 != null;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("a", (Tag)this.gradient0.serializeNBT());
            if (this.gradient1 != null) {
                tag.m_128365_("b", (Tag)this.gradient1.serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            CompoundTag tag;
            Tag tag2 = nbt.m_128423_("a");
            if (tag2 instanceof CompoundTag) {
                tag = (CompoundTag)tag2;
                this.gradient0.deserializeNBT(tag);
            }
            if ((tag2 = nbt.m_128423_("b")) instanceof CompoundTag) {
                tag = (CompoundTag)tag2;
                if (this.gradient1 == null) {
                    this.gradient1 = new GradientColor();
                }
                this.gradient1.deserializeNBT(tag);
            }
        }
    }
}

