/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.ColorsResource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXData;
import com.lowdragmc.photon.gui.editor.CurvesResource;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.GradientsResource;
import com.lowdragmc.photon.gui.editor.MaterialsResource;
import com.lowdragmc.photon.gui.editor.MeshesResource;
import com.lowdragmc.photon.gui.editor.ParticleScenePanel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

@LDLRegister(name="fxproj", group="editor.fx")
public class FXProject
implements IProject {
    public static int VERSION = 1;
    protected Resources resources;
    protected FX fx = new FX();
    private boolean draggable = true;
    private boolean renderCullBox = false;

    private FXProject(Resources resources) {
        this.resources = resources;
    }

    private Resources createResources() {
        LinkedHashMap<String, Object> resources = new LinkedHashMap<String, Object>();
        MaterialsResource material = new MaterialsResource();
        material.buildDefault();
        resources.put(material.name(), (Object)material);
        MeshesResource mesh = new MeshesResource();
        mesh.buildDefault();
        resources.put(mesh.name(), (Object)mesh);
        ColorsResource color = new ColorsResource();
        color.buildDefault();
        resources.put("ldlib.gui.editor.group.colors", color);
        CurvesResource curve = new CurvesResource();
        curve.buildDefault();
        resources.put(curve.name(), (Object)curve);
        GradientsResource gradient = new GradientsResource();
        gradient.buildDefault();
        resources.put(gradient.name(), (Object)gradient);
        return new Resources(resources);
    }

    public FXProject newEmptyProject() {
        return new FXProject(this.createResources());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("resources", (Tag)this.resources.serializeNBT());
        tag.m_128365_("fx", (Tag)this.fx.serializeNBT());
        tag.m_128405_("_version", VERSION);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        int version = tag.m_128441_("_version") ? tag.m_128451_("_version") : 0;
        this.resources = this.loadResources(tag.m_128469_("resources"));
        this.fx.deserializeNBT(tag.m_128469_("fx"));
        if (version < 1) {
            CompoundTag emitters = new CompoundTag();
            emitters.m_128365_("fxObjects", (Tag)tag.m_128437_("emitters", 10));
            this.fx.getMainFX().deserializeNBT(emitters);
        }
    }

    public Resources loadResources(CompoundTag tag) {
        Resources resources = this.createResources();
        resources.deserializeNBT(tag);
        return resources;
    }

    public void saveProject(File file) {
        try {
            NbtIo.m_128955_((CompoundTag)this.serializeNBT(), (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void attachMenu(Editor editor, String name, TreeBuilder.Menu menu) {
        if (name.equals("file")) {
            menu.branch("ldlib.gui.editor.menu.export", m -> m.leaf("FX", () -> {
                File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/photon/fx");
                DialogWidget.showFileDialog((WidgetGroup)editor, (String)"Export FX", (File)path, (boolean)false, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".fx"}), r -> {
                    if (r != null && !r.isDirectory()) {
                        if (!r.getName().endsWith(".fx")) {
                            r = new File(r.getParentFile(), r.getName() + ".fx");
                        }
                        try {
                            CompoundTag tag = new CompoundTag();
                            tag.m_128365_("fx", (Tag)this.fx.serializeNBT());
                            tag.m_128405_("_version", VERSION);
                            NbtIo.m_128944_((CompoundTag)tag, (File)r);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }));
        }
    }

    public ParticleScenePanel createParticleScenePanel(FXEditor editor, FXData fxData) {
        return new ParticleScenePanel(editor, this, fxData);
    }

    public void onLoad(Editor editor) {
        if (editor instanceof FXEditor) {
            FXEditor fxEditor = (FXEditor)editor;
            super.onLoad(editor);
            StringTabContainer tabContainer = fxEditor.getTabPages();
            ParticleScenePanel mainFX = this.createParticleScenePanel(fxEditor, this.fx.getMainFX());
            tabContainer.addTab("photon.gui.editor.fx.particle_panel.main", (WidgetGroup)mainFX, mainFX::onPanelSelected, mainFX::onPanelDeselected);
            for (Map.Entry<String, FXData> entry : this.fx.getSubFXs().entrySet()) {
                String name = entry.getKey();
                FXData fxData = entry.getValue();
                ParticleScenePanel subFX = this.createParticleScenePanel(fxEditor, fxData);
                tabContainer.addTab(null, LocalizationUtils.format((String)"photon.gui.editor.fx.particle_panel.sub", (Object[])new Object[]{name}), (WidgetGroup)subFX, subFX::onPanelSelected, subFX::onPanelDeselected, () -> this.fx.getSubFXs().remove(name));
            }
            tabContainer.addTab("+", new WidgetGroup(), () -> DialogWidget.showStringEditorDialog((WidgetGroup)editor, (String)"photon.gui.editor.fx.particle_panel.add", (String)"sub_fx_name", s -> !this.fx.getSubFXs().containsKey(s), s -> {
                if (s != null) {
                    this.fx.getSubFXs().put((String)s, new FXData());
                    int lastIndex = tabContainer.getTabIndex();
                    editor.loadProject((IProject)this);
                    tabContainer.switchTabIndex(lastIndex);
                } else {
                    editor.loadProject((IProject)this);
                    tabContainer.switchTabIndex(0);
                }
            }), null);
        }
    }

    public void onClosed(Editor editor) {
        editor.getFloatView().clearAllWidgets();
    }

    public Resources getResources() {
        return this.resources;
    }

    public FX getFx() {
        return this.fx;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isRenderCullBox() {
        return this.renderCullBox;
    }

    public FXProject() {
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public void setRenderCullBox(boolean renderCullBox) {
        this.renderCullBox = renderCullBox;
    }
}

