/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MenuPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.ToolPanel;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.gui.editor.FXProject;
import java.io.File;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="editor.fx", group="editor")
@OnlyIn(value=Dist.CLIENT)
public class FXEditor
extends Editor {
    public static final ConfigPanel.Tab BASIC = ConfigPanel.Tab.WIDGET;
    public static final ConfigPanel.Tab RESOURCE = ConfigPanel.Tab.RESOURCE;
    protected IEffect effect;

    public FXEditor(File workSpace) {
        super(workSpace);
    }

    public IEffect getEditorFX() {
        return this.effect;
    }

    public void initEditorViews() {
        this.toolPanel = new ToolPanel((Editor)this);
        this.toolPanel.setSizeWidth(150);
        this.configPanel = new ConfigPanel((Editor)this, List.of(BASIC, RESOURCE));
        this.tabPages = new StringTabContainer((Editor)this);
        this.resourcePanel = new ResourcePanel((Editor)this);
        this.menuPanel = new MenuPanel((Editor)this);
        this.floatView = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.tabPages);
        this.addWidget((Widget)this.toolPanel);
        this.addWidget((Widget)this.configPanel);
        this.addWidget((Widget)this.resourcePanel);
        this.addWidget((Widget)this.menuPanel);
        this.addWidget((Widget)this.floatView);
    }

    public void loadProject(IProject project) {
        if (project != null && !(project instanceof FXProject)) {
            throw new IllegalArgumentException("Invalid project type");
        }
        super.loadProject(project);
    }
}

