/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.command;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.photon.PhotonNetworking;
import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.FXRuntime;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RemoveBlockEffectCommand
implements IPacket {
    protected BlockPos pos;
    protected boolean force;
    @Nullable
    protected ResourceLocation location;

    public static LiteralArgumentBuilder<CommandSourceStack> createServerCommand() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> RemoveBlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(c -> RemoveBlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, false))).then(Commands.m_82129_((String)"location", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(c -> RemoveBlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true)))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, boolean force, boolean location) throws CommandSyntaxException {
        RemoveBlockEffectCommand command = new RemoveBlockEffectCommand();
        command.pos = BlockPosArgument.m_118242_(context, (String)"pos");
        if (force) {
            command.setForce(BoolArgumentType.getBool(context, (String)"force"));
        }
        if (location) {
            command.setLocation(ResourceLocationArgument.m_107011_(context, (String)"location"));
        }
        PhotonNetworking.NETWORK.sendToTrackingChunk((IPacket)command, ((CommandSourceStack)context.getSource()).m_81372_().m_46745_(command.pos));
        return 1;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.force);
        buf.writeBoolean(this.location != null);
        if (this.location != null) {
            buf.m_130085_(this.location);
        }
    }

    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.force = buf.readBoolean();
        if (buf.readBoolean()) {
            this.location = buf.m_130281_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        List<BlockEffect> effects = BlockEffect.CACHE.get(this.pos);
        if (effects == null) {
            return;
        }
        Iterator<BlockEffect> iter = effects.iterator();
        while (iter.hasNext()) {
            BlockEffect effect = iter.next();
            if (this.location != null && !this.location.equals((Object)effect.getFx().getFxLocation())) continue;
            iter.remove();
            FXRuntime runtime = effect.getRuntime();
            if (runtime == null || !runtime.isAlive()) continue;
            runtime.destroy(this.force);
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setLocation(@Nullable ResourceLocation location) {
        this.location = location;
    }
}

