/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.command;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.photon.PhotonNetworking;
import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.lowdragmc.photon.command.EffectCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEffectCommand
extends EffectCommand {
    protected BlockPos pos;
    protected boolean checkState;

    public static LiteralArgumentBuilder<CommandSourceStack> createServerCommand() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, false, false, false, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"offset", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, false, false, false, false, false, false))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"rotation", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force death", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"allow multi", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, true, false))).then(Commands.m_82129_((String)"check state", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, true, true)))))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force death", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, true, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"allow multi", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, true, true, false))).then(Commands.m_82129_((String)"check state", (ArgumentType)BoolArgumentType.bool()).executes(c -> BlockEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, true, true, true)))))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, boolean offset, boolean rotation, boolean scale, boolean delay, boolean forceDeath, boolean allowMulti, boolean checkState) throws CommandSyntaxException {
        BlockEffectCommand command = new BlockEffectCommand();
        command.setLocation(ResourceLocationArgument.m_107011_(context, (String)"location"));
        command.setPos(BlockPosArgument.m_118242_(context, (String)"pos"));
        if (offset) {
            command.setOffset(Vec3Argument.m_120844_(context, (String)"offset"));
        }
        if (rotation) {
            command.setRotation(Vec3Argument.m_120844_(context, (String)"rotation"));
        }
        if (scale) {
            command.setScale(Vec3Argument.m_120844_(context, (String)"scale"));
        }
        if (delay) {
            command.setDelay(IntegerArgumentType.getInteger(context, (String)"delay"));
        }
        if (forceDeath) {
            command.setForcedDeath(BoolArgumentType.getBool(context, (String)"force death"));
        }
        if (allowMulti) {
            command.setAllowMulti(BoolArgumentType.getBool(context, (String)"allow multi"));
        }
        if (checkState) {
            command.setCheckState(BoolArgumentType.getBool(context, (String)"check state"));
        }
        PhotonNetworking.NETWORK.sendToTrackingChunk((IPacket)command, ((CommandSourceStack)context.getSource()).m_81372_().m_46745_(command.pos));
        return 1;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.checkState);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.pos = buf.m_130135_();
        this.checkState = buf.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        FX fx;
        if (handler.getLevel().m_46749_(this.pos) && (fx = FXHelper.getFX(this.location)) != null) {
            BlockEffect effect = new BlockEffect(fx, handler.getLevel(), this.pos);
            effect.setOffset(this.offset.f_82479_, this.offset.f_82480_, this.offset.f_82481_);
            effect.setRotation(this.rotation.f_82479_, this.rotation.f_82480_, this.rotation.f_82481_);
            effect.setScale(this.scale.f_82479_, this.scale.f_82480_, this.scale.f_82481_);
            effect.setDelay(this.delay);
            effect.setForcedDeath(this.forcedDeath);
            effect.setAllowMulti(this.allowMulti);
            effect.setCheckState(this.checkState);
            effect.start();
        }
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setCheckState(boolean checkState) {
        this.checkState = checkState;
    }
}

