/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.particle;

import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.IScene;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.fx.FXRuntime;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.data.InheritVelocitySetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.SubEmittersSetting;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleConfig;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleEmitter;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class TileParticle
implements IParticle {
    public static final Direction[] MODEL_SIDES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN, null};
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);
    protected float localX;
    protected float localY;
    protected float localZ;
    protected float localXo;
    protected float localYo;
    protected float localZo;
    protected float rotationX = 180.0f;
    protected float rotationY = 180.0f;
    protected float rotationZ = 180.0f;
    protected float rotationXo = 180.0f;
    protected float rotationYo = 180.0f;
    protected float rotationZo = 180.0f;
    protected float sizeX = 1.0f;
    protected float sizeY = 1.0f;
    protected float sizeZ = 1.0f;
    protected float sizeXo = 1.0f;
    protected float sizeYo = 1.0f;
    protected float sizeZo = 1.0f;
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected float ro = 1.0f;
    protected float go = 1.0f;
    protected float bo = 1.0f;
    protected float ao = 1.0f;
    protected float velocityX;
    protected float velocityY;
    protected float velocityZ;
    protected int light = -1;
    protected AABB boundingBox = new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
    protected boolean collided;
    protected int delay;
    protected int age;
    protected int lifetime;
    protected boolean isRemoved;
    protected float t;
    protected Matrix4f initialTransform;
    protected Matrix4f initialTransformInverse;
    protected Vector3f initialScale;
    protected Vector3f initialSize;
    protected Vector3f initialRotation;
    protected Vector4f initialColor;
    protected boolean isFirstCollision;
    protected ParticleConfig config;
    protected IParticleEmitter emitter;
    protected ConcurrentHashMap<Object, Float> memRandom = new ConcurrentHashMap();
    public RandomSource randomSource;

    public TileParticle(IParticleEmitter emitter, ParticleConfig config, RandomSource randomSource) {
        this.emitter = emitter;
        this.config = config;
        this.randomSource = randomSource;
        this.setup();
    }

    public void setup() {
        IParticleEmitter iParticleEmitter;
        this.initialTransform = this.emitter.transform().localToWorldMatrix();
        this.initialTransformInverse = this.emitter.transform().worldToLocalMatrix();
        this.initialScale = this.emitter.transform().scale();
        float emitterT = this.emitter.getT();
        this.setDelay(this.config.getStartDelay().get(this.randomSource, emitterT).intValue());
        if (this.config.lifetimeByEmitterSpeed.isEnable()) {
            this.setLifetime(this.config.lifetimeByEmitterSpeed.getLifetime(this, this.emitter, this.config.getStartLifetime().get(this.randomSource, emitterT).intValue()));
        } else {
            this.setLifetime(this.config.getStartLifetime().get(this.randomSource, emitterT).intValue());
        }
        this.config.shape.setupParticle(this, this.emitter);
        if (this.config.inheritVelocity.isEnable() && this.config.inheritVelocity.getMode() == InheritVelocitySetting.Mode.INITIAL) {
            this.addInternalVelocity(this.getSpaceTransformInverse().transformDirection(this.emitter.getVelocity()));
        }
        this.mulInternalVelocity(this.config.getStartSpeed().get(this.randomSource, emitterT).floatValue());
        this.initialSize = this.config.getStartSize().get(this.randomSource, emitterT);
        this.initialRotation = this.config.getStartRotation().get(this.randomSource, emitterT).mul((float)Math.PI / 180);
        int color = this.config.getStartColor().get(this.randomSource, emitterT).intValue();
        this.initialColor = new Vector4f(ColorUtils.red((int)color), ColorUtils.green((int)color), ColorUtils.blue((int)color), ColorUtils.alpha((int)color));
        this.setSize(this.initialSize);
        this.setRotation(this.initialRotation);
        this.setColor(this.initialColor);
        this.update();
        this.updateOrigin();
        if (this.config.trails.isEnable() && (iParticleEmitter = this.emitter) instanceof ParticleEmitter) {
            ParticleEmitter particleEmitter = (ParticleEmitter)iParticleEmitter;
            this.config.trails.setup(particleEmitter, this);
        }
    }

    @Override
    public PhotonParticleRenderType getRenderType() {
        return this.config.particleRenderType;
    }

    @Override
    public float getT(float partialTicks) {
        return this.t + partialTicks / (float)this.getLifetime();
    }

    @Override
    public float getMemRandom(Object object) {
        return this.getMemRandom(object, RandomSource::m_188501_);
    }

    @Override
    public float getMemRandom(Object object, Function<RandomSource, Float> randomFunc) {
        Float value = this.memRandom.get(object);
        if (value == null) {
            return this.memRandom.computeIfAbsent(object, o -> (Float)randomFunc.apply(this.randomSource)).floatValue();
        }
        return value.floatValue();
    }

    public void setLocalPos(float x, float y, float z, boolean setOrigin) {
        this.localX = x;
        this.localY = y;
        this.localZ = z;
        if (setOrigin) {
            this.localXo = x;
            this.localYo = y;
            this.localZo = z;
        }
    }

    public void setLocalPos(Vector3f realPos, boolean origin) {
        this.setLocalPos(realPos.x, realPos.y, realPos.z, origin);
    }

    public void setInternalVelocity(Vector3f vec) {
        this.velocityX = vec.x;
        this.velocityY = vec.y;
        this.velocityZ = vec.z;
    }

    public void mulInternalVelocity(float mul) {
        this.velocityX *= mul;
        this.velocityY *= mul;
        this.velocityZ *= mul;
    }

    public void addInternalVelocity(Vector3f vec) {
        this.velocityX += vec.x;
        this.velocityY += vec.y;
        this.velocityZ += vec.z;
    }

    public void setRotation(Vector3f rotation) {
        this.rotationX = rotation.x;
        this.rotationY = rotation.y;
        this.rotationZ = rotation.z;
    }

    public void setSize(Vector3f size) {
        this.sizeX = size.x;
        this.sizeY = size.y;
        this.sizeZ = size.z;
        this.boundingBox = new AABB((double)(-this.sizeX / 2.0f), (double)(-this.sizeY / 2.0f), (double)(-this.sizeZ / 2.0f), (double)(this.sizeX / 2.0f), (double)(this.sizeY / 2.0f), (double)(this.sizeZ / 2.0f));
    }

    public void mulSize(float size) {
        this.sizeX *= size;
        this.sizeY *= size;
        this.sizeZ *= size;
        this.boundingBox = new AABB((double)(-this.sizeX / 2.0f), (double)(-this.sizeY / 2.0f), (double)(-this.sizeZ / 2.0f), (double)(this.sizeX / 2.0f), (double)(this.sizeY / 2.0f), (double)(this.sizeZ / 2.0f));
    }

    public void setColor(Vector4f color) {
        this.r = color.x();
        this.g = color.y();
        this.b = color.z();
        this.a = color.w();
    }

    public void setARGBColor(int color) {
        this.a = ColorUtils.alpha((int)color);
        this.r = ColorUtils.red((int)color);
        this.g = ColorUtils.green((int)color);
        this.b = ColorUtils.blue((int)color);
    }

    public Vector3f getRealRotation(float partialTicks) {
        Vector3f rotation = new Vector3f(Mth.m_14179_((float)partialTicks, (float)this.rotationXo, (float)this.rotationX), Mth.m_14179_((float)partialTicks, (float)this.rotationYo, (float)this.rotationY), Mth.m_14179_((float)partialTicks, (float)this.rotationZo, (float)this.rotationZ));
        return rotation;
    }

    public Vector3f getRealSize(float partialTicks) {
        return new Vector3f(Mth.m_14179_((float)partialTicks, (float)this.sizeXo, (float)this.sizeX), Mth.m_14179_((float)partialTicks, (float)this.sizeYo, (float)this.sizeY), Mth.m_14179_((float)partialTicks, (float)this.sizeZo, (float)this.sizeZ));
    }

    public Vector3f getLocalPos() {
        return this.getLocalPos(0.0f);
    }

    public Vector3f getLocalPos(float partialTicks) {
        if (this.isRemoved) {
            return new Vector3f(this.localX, this.localY, this.localZ);
        }
        Vector3f pos = new Vector3f(Mth.m_14179_((float)partialTicks, (float)this.localXo, (float)this.localX), Mth.m_14179_((float)partialTicks, (float)this.localYo, (float)this.localY), Mth.m_14179_((float)partialTicks, (float)this.localZo, (float)this.localZ));
        if (this.config.noise.isEnable()) {
            pos.add((Vector3fc)this.config.noise.getPosition(this, partialTicks));
        }
        return pos;
    }

    public Vector3f getWorldPos() {
        return this.getWorldPos(0.0f);
    }

    public Matrix4f getSpaceTransform() {
        return this.config.getSimulationSpace() == ParticleConfig.Space.Local ? this.emitter.transform().localToWorldMatrix() : this.initialTransform;
    }

    public Matrix4f getSpaceTransformInverse() {
        return this.config.getSimulationSpace() == ParticleConfig.Space.Local ? this.emitter.transform().worldToLocalMatrix() : this.initialTransformInverse;
    }

    public Vector3f getSpaceScale() {
        return this.config.getSimulationSpace() == ParticleConfig.Space.Local ? this.emitter.transform().scale() : this.initialScale;
    }

    public Vector3f getWorldPos(float partialTicks) {
        Vector3f localPosition = this.getLocalPos(partialTicks);
        return new Vector3f((Vector3fc)localPosition).mulPosition((Matrix4fc)this.getSpaceTransform());
    }

    public AABB getRealBoundingBox(float partialTicks) {
        Vector3f pos = this.getWorldPos(partialTicks);
        return this.boundingBox.m_82386_((double)pos.x, (double)pos.y, (double)pos.z);
    }

    public Vector4f getRealColor(float partialTicks) {
        Vector4f emitterColor = this.emitter.getRGBAColor();
        float a = Mth.m_14179_((float)partialTicks, (float)this.ao, (float)this.a);
        float r = Mth.m_14179_((float)partialTicks, (float)this.ro, (float)this.r);
        float g = Mth.m_14179_((float)partialTicks, (float)this.go, (float)this.g);
        float b = Mth.m_14179_((float)partialTicks, (float)this.bo, (float)this.b);
        return emitterColor.mul(r, g, b, a);
    }

    public Vector4f getRealUVs(float partialTicks) {
        if (this.config.uvAnimation.isEnable()) {
            return this.config.uvAnimation.getUVs(this, partialTicks);
        }
        return new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public int getRealLight(float partialTicks) {
        if (this.config.renderer.isBloomEffect()) {
            return 0xF000F0;
        }
        if (this.config.lights.isEnable()) {
            return this.config.lights.getLight(this, partialTicks);
        }
        return this.light;
    }

    public int getLightColor() {
        Vector3f pos = this.getWorldPos();
        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        return this.emitter.getLightColor(blockPos);
    }

    @Override
    public void tick() {
        FXRuntime fxRuntime;
        IScene iScene;
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.updateOrigin();
        if (this.age == 0 && this.config.subEmitters.isEnable() && (iScene = this.emitter.getScene()) instanceof FXRuntime) {
            fxRuntime = (FXRuntime)iScene;
            this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.Birth);
        }
        if (this.age++ >= this.lifetime && this.lifetime > 0) {
            this.setRemoved(true);
            if (this.config.subEmitters.isEnable() && (iScene = this.emitter.getScene()) instanceof FXRuntime) {
                fxRuntime = (FXRuntime)iScene;
                this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.Death);
            }
        }
        this.update();
        if (this.config.subEmitters.isEnable() && (iScene = this.emitter.getScene()) instanceof FXRuntime) {
            fxRuntime = (FXRuntime)iScene;
            this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.Tick);
        }
        if (this.lifetime > 0) {
            this.t = 1.0f * (float)this.age / (float)this.lifetime;
        }
    }

    protected void updateOrigin() {
        this.localXo = this.localX;
        this.localYo = this.localY;
        this.localZo = this.localZ;
        this.rotationXo = this.rotationX;
        this.rotationYo = this.rotationY;
        this.rotationZo = this.rotationZ;
        this.sizeXo = this.sizeX;
        this.sizeYo = this.sizeY;
        this.sizeZo = this.sizeZ;
        this.ro = this.r;
        this.go = this.g;
        this.bo = this.b;
        this.ao = this.a;
    }

    protected void update() {
        this.updateChanges();
    }

    protected void updateChanges() {
        this.updatePositionAndInternalVelocity();
        this.updateColor();
        this.updateSize();
        this.updateRotation();
        this.updateLight();
    }

    protected void updatePositionAndInternalVelocity() {
        float gravity;
        Vector3f velocity = this.getRealVelocity();
        float moveX = velocity.x;
        float moveY = velocity.y;
        float moveZ = velocity.z;
        Level level = this.emitter.getLevel();
        if (this.config.physics.isEnable() && this.config.physics.isHasCollision() && level != null && ((double)moveX != 0.0 || (double)moveY != 0.0 || (double)moveZ != 0.0) && (double)(moveX * moveX + moveY * moveY + moveZ * moveZ) < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.m_198894_(null, (Vec3)new Vec3((double)moveX, (double)moveY, (double)moveZ), (AABB)this.getRealBoundingBox(0.0f), (Level)level, List.of());
            moveX = (float)vec3.f_82479_;
            moveY = (float)vec3.f_82480_;
            moveZ = (float)vec3.f_82481_;
        }
        if ((double)moveX != 0.0 || (double)moveY != 0.0 || (double)moveZ != 0.0) {
            Vector3f moveLocal = this.getSpaceTransformInverse().transformDirection(new Vector3f(moveX, moveY, moveZ));
            this.setLocalPos(this.localX + moveLocal.x, this.localY + moveLocal.y, this.localZ + moveLocal.z, false);
        }
        if (!this.config.physics.isEnable()) {
            return;
        }
        if (this.config.physics.isHasCollision() && !this.collided) {
            float bounceChance = this.config.physics.getBounceChance(this);
            float bounceRate = this.config.physics.getBounceRate(this);
            float bounceSpreadRate = this.config.physics.getBounceSpreadRate(this);
            if ((double)(Math.abs(velocity.x) / Math.abs(moveX)) > 1.001) {
                this.updateCollisionBounce(bounceChance, velocity, bounceRate, bounceSpreadRate, Direction.Axis.X);
            } else if ((double)(Math.abs(velocity.y) / Math.abs(moveY)) > 1.001) {
                this.updateCollisionBounce(bounceChance, velocity, bounceRate, bounceSpreadRate, Direction.Axis.Y);
            } else if ((double)(Math.abs(velocity.z) / Math.abs(moveZ)) > 1.001) {
                this.updateCollisionBounce(bounceChance, velocity, bounceRate, bounceSpreadRate, Direction.Axis.Z);
            }
        }
        if ((gravity = this.config.physics.getGravity(this)) != 0.0f) {
            this.addInternalVelocity(this.getSpaceTransformInverse().transformDirection(new Vector3f(0.0f, -gravity * 0.04f, 0.0f)));
        }
        float friction = this.config.physics.getFriction(this);
        this.velocityX *= friction;
        this.velocityY *= friction;
        this.velocityZ *= friction;
        if (this.collided && (double)friction != 1.0) {
            this.velocityX *= 0.7f;
            this.velocityY *= 0.7f;
            this.velocityZ *= 0.7f;
        }
    }

    private void updateCollisionBounce(float bounceChance, Vector3f velocity, float bounceRate, float bounceSpreadRate, Direction.Axis axis) {
        FXRuntime fxRuntime;
        IScene iScene;
        if (bounceChance < 1.0f && bounceChance < this.randomSource.m_188501_()) {
            this.collided = true;
        } else {
            Vector3f newVelocity = this.getSpaceTransformInverse().transformDirection(new Vector3f(axis == Direction.Axis.X ? -velocity.x * bounceRate : velocity.x + (bounceSpreadRate > 0.0f ? (float)((double)bounceSpreadRate * this.randomSource.m_188583_()) : 0.0f), axis == Direction.Axis.Y ? -velocity.y * bounceRate : velocity.y + (bounceSpreadRate > 0.0f ? (float)((double)bounceSpreadRate * this.randomSource.m_188583_()) : 0.0f), axis == Direction.Axis.Z ? -velocity.z * bounceRate : velocity.z + (bounceSpreadRate > 0.0f ? (float)((double)bounceSpreadRate * this.randomSource.m_188583_()) : 0.0f)));
            this.setInternalVelocity(newVelocity);
        }
        if (this.config.physics.isEnable() && this.config.physics.isRemovedWhenCollided()) {
            this.setRemoved(true);
            if (this.config.subEmitters.isEnable() && (iScene = this.emitter.getScene()) instanceof FXRuntime) {
                fxRuntime = (FXRuntime)iScene;
                this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.Death);
            }
        }
        if (this.config.subEmitters.isEnable() && (iScene = this.emitter.getScene()) instanceof FXRuntime) {
            fxRuntime = (FXRuntime)iScene;
            this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.Collision);
            if (!this.isFirstCollision) {
                this.isFirstCollision = true;
                this.config.subEmitters.triggerEvent(fxRuntime.getFx(), this, SubEmittersSetting.Event.FirstCollision);
            }
        }
    }

    public Vector3f getInternalVelocity() {
        Vector3f velocity = new Vector3f(this.velocityX, this.velocityY, this.velocityZ);
        if (this.config.velocityOverLifetime.isEnable()) {
            Vector3f velocityAddition = this.config.velocityOverLifetime.getVelocityAddition(this);
            velocity.add((Vector3fc)velocityAddition);
        }
        if (this.config.forceOverLifetime.isEnable() && this.config.forceOverLifetime.getSimulationSpace() == ParticleConfig.Space.Local) {
            velocity.add((Vector3fc)this.config.forceOverLifetime.getForce(this));
        }
        return velocity;
    }

    public Vector3f getRealVelocity() {
        Vector3f velocity = this.getSpaceTransform().transformDirection(this.getInternalVelocity());
        if (this.config.forceOverLifetime.isEnable() && this.config.forceOverLifetime.getSimulationSpace() == ParticleConfig.Space.World) {
            velocity.add((Vector3fc)this.config.forceOverLifetime.getForce(this));
        }
        if (this.config.inheritVelocity.isEnable() && this.config.inheritVelocity.getMode() == InheritVelocitySetting.Mode.CURRENT) {
            velocity.add((Vector3fc)this.emitter.getVelocity());
        }
        if (this.config.velocityOverLifetime.isEnable()) {
            float velocityMultiplier = this.config.velocityOverLifetime.getVelocityMultiplier(this);
            velocity.mul(velocityMultiplier);
        }
        return velocity;
    }

    protected void updateSize() {
        if (this.config.sizeBySpeed.isEnable() || this.config.sizeOverLifetime.isEnable() || this.config.noise.isEnable()) {
            Vector3f size = new Vector3f((Vector3fc)this.initialSize);
            Vector3f mul = new Vector3f(1.0f, 1.0f, 1.0f);
            if (this.config.noise.isEnable()) {
                size.add((Vector3fc)this.config.noise.getSize(this, 0.0f));
            }
            if (this.config.sizeBySpeed.isEnable()) {
                mul.mul((Vector3fc)this.config.sizeBySpeed.getSize(this));
            }
            if (this.config.sizeOverLifetime.isEnable()) {
                mul.mul((Vector3fc)this.config.sizeOverLifetime.getSize(this, 0.0f));
            }
            this.setSize(size.mul((Vector3fc)mul));
        }
    }

    protected void updateRotation() {
        if (this.config.rotationOverLifetime.isEnable() || this.config.rotationBySpeed.isEnable() || this.config.noise.isEnable()) {
            Vector3f rotation = new Vector3f((Vector3fc)this.initialRotation);
            if (this.config.rotationOverLifetime.isEnable()) {
                rotation.add((Vector3fc)this.config.rotationOverLifetime.getRotation(this, 0.0f));
            }
            if (this.config.rotationBySpeed.isEnable()) {
                rotation.add((Vector3fc)this.config.rotationBySpeed.getRotation(this));
            }
            if (this.config.noise.isEnable()) {
                rotation.add((Vector3fc)this.config.noise.getRotation(this, 0.0f));
            }
            this.setRotation(rotation);
        }
    }

    protected void updateColor() {
        if (this.config.colorOverLifetime.isEnable() || this.config.colorBySpeed.isEnable()) {
            Vector4f color = new Vector4f((Vector4fc)this.initialColor);
            if (this.config.colorOverLifetime.isEnable()) {
                color.mul((Vector4fc)this.config.colorOverLifetime.getColor(this, 0.0f));
            }
            if (this.config.colorBySpeed.isEnable()) {
                color.mul((Vector4fc)this.config.colorBySpeed.getColor(this));
            }
            this.setColor(color);
        }
    }

    protected void updateLight() {
        if (this.config.lights.isEnable() || this.config.renderer.isBloomEffect()) {
            return;
        }
        this.light = this.getLightColor();
    }

    @Override
    public void render(@Nonnull VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (this.delay <= 0 && this.emitter.isVisible()) {
            this.renderInternal(pBuffer, pRenderInfo, pPartialTicks);
        }
    }

    public void renderInternal(@Nonnull VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.m_90583_();
        Vector3f localPos = this.getLocalPos(partialTicks).mulPosition((Matrix4fc)this.getSpaceTransform());
        float x = (float)((double)localPos.x - vec3.f_82479_);
        float y = (float)((double)localPos.y - vec3.f_82480_);
        float z = (float)((double)localPos.z - vec3.f_82481_);
        Vector4f color = this.getRealColor(partialTicks);
        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();
        int light = this.getRealLight(partialTicks);
        Vector3f rotation = this.getRealRotation(partialTicks);
        RendererSetting.Particle.Mode renderMode = this.config.renderer.getRenderMode();
        Quaternionf quaternion = (Quaternionf)renderMode.quaternion.apply((Object)this, (Object)camera, (Object)Float.valueOf(partialTicks));
        if (!Vector3fHelper.isZero((Vector3f)rotation)) {
            quaternion = new Quaternionf((Quaternionfc)quaternion).rotateXYZ(rotation.x, rotation.y, rotation.z);
        }
        Vector3f size = this.getRealSize(partialTicks);
        if (renderMode == RendererSetting.Particle.Mode.Model) {
            Matrix4f transform = new Matrix4f().translate(x, y, z).rotate((Quaternionfc)new Quaternionf().rotateXYZ(rotation.x, rotation.y, rotation.z)).scale((Vector3fc)size).translate(-0.5f, -0.5f, -0.5f);
            IModelRenderer model = this.config.renderer.getModel();
            Vector4f uvs = this.getRealUVs(partialTicks);
            for (Direction side : MODEL_SIDES) {
                float f;
                if (side != null && this.config.renderer.isShade()) {
                    switch (side) {
                        case DOWN: 
                        case UP: {
                            f = 0.9f;
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            f = 0.8f;
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            f = 0.6f;
                            break;
                        }
                        default: {
                            f = 1.0f;
                            break;
                        }
                    }
                } else {
                    f = 1.0f;
                }
                float brightness = f;
                List quads = model.renderModel(null, null, null, side, this.randomSource);
                for (BakedQuad quad : quads) {
                    this.putBulkData(transform, buffer, quad, brightness, uvs, r, g, b, a, light);
                }
            }
        } else {
            Vector3f[] rawVertexes = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = rawVertexes[i];
                vertex.mul(size.x, size.y, size.z);
                vertex = quaternion.transform(vertex);
                vertex.mul((Vector3fc)this.getSpaceScale());
                vertex.add(x, y, z);
            }
            Vector4f uvs = this.getRealUVs(partialTicks);
            float u0 = uvs.x();
            float v0 = uvs.y();
            float u1 = uvs.z();
            float v1 = uvs.w();
            buffer.m_5483_((double)rawVertexes[0].x(), (double)rawVertexes[0].y(), (double)rawVertexes[0].z()).m_7421_(u1, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            buffer.m_5483_((double)rawVertexes[1].x(), (double)rawVertexes[1].y(), (double)rawVertexes[1].z()).m_7421_(u1, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            buffer.m_5483_((double)rawVertexes[2].x(), (double)rawVertexes[2].y(), (double)rawVertexes[2].z()).m_7421_(u0, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            buffer.m_5483_((double)rawVertexes[3].x(), (double)rawVertexes[3].y(), (double)rawVertexes[3].z()).m_7421_(u0, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        }
    }

    public void putBulkData(Matrix4f transform, VertexConsumer buffer, BakedQuad quad, float brightness, Vector4f uvs, float red, float green, float blue, float alpha, int light) {
        int[] vertices = quad.m_111303_();
        int points = vertices.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < points; ++k) {
                intBuffer.clear();
                intBuffer.put(vertices, k * 8, 8);
                float x = byteBuffer.getFloat(0);
                float y = byteBuffer.getFloat(4);
                float z = byteBuffer.getFloat(8);
                float u = byteBuffer.getFloat(16);
                float v = byteBuffer.getFloat(20);
                if (!this.config.renderer.isUseBlockUV()) {
                    u = k == 0 || k == 3 ? uvs.x : uvs.z;
                    v = k == 0 || k == 1 ? uvs.y : uvs.w;
                }
                Vector4f pos = transform.transform(new Vector4f(x, y, z, 1.0f));
                buffer.m_5483_((double)pos.x, (double)pos.y, (double)pos.z).m_7421_(u, v).m_85950_(red * brightness, green * brightness, blue * brightness, alpha).m_85969_(light).m_5752_();
            }
        }
    }

    public void setCollided(boolean collided) {
        this.collided = collided;
    }

    public boolean isCollided() {
        return this.collided;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public float getT() {
        return this.t;
    }

    public void setInitialScale(Vector3f initialScale) {
        this.initialScale = initialScale;
    }

    public IParticleEmitter getEmitter() {
        return this.emitter;
    }

    public ConcurrentHashMap<Object, Float> getMemRandom() {
        return this.memRandom;
    }

    @Override
    public RandomSource getRandomSource() {
        return this.randomSource;
    }
}

